/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class JdbcRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(JdbcRecordCursor.class);
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstance((DateTimeZone)DateTimeZone.UTC);
    private final List<JdbcColumnHandle> columnHandles;
    private final Connection connection;
    private final Statement statement;
    private final ResultSet resultSet;
    private boolean closed;

    public JdbcRecordCursor(JdbcClient jdbcClient, JdbcSplit split, List<JdbcColumnHandle> columnHandles) {
        this.columnHandles = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnHandles, (Object)"columnHandles is null")));
        String sql = jdbcClient.buildSql(split, columnHandles);
        try {
            this.connection = jdbcClient.getConnection(split);
            this.statement = this.connection.createStatement();
            this.statement.setFetchSize(1000);
            log.debug("Executing: %s", new Object[]{sql});
            this.resultSet = this.statement.executeQuery(sql);
        }
        catch (SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public long getTotalBytes() {
        return 0L;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public Type getType(int field) {
        return this.columnHandles.get(field).getColumnType();
    }

    public boolean advanceNextPosition() {
        if (this.closed) {
            return false;
        }
        try {
            boolean result = this.resultSet.next();
            if (!result) {
                this.close();
            }
            return result;
        }
        catch (SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean getBoolean(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.resultSet.getBoolean(field + 1);
        }
        catch (SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getLong(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            Type type = this.getType(field);
            if (type.equals(BigintType.BIGINT)) {
                return this.resultSet.getLong(field + 1);
            }
            if (type.equals(DateType.DATE)) {
                Date date = this.resultSet.getDate(field + 1);
                return UTC_CHRONOLOGY.dayOfMonth().roundFloor(date.getTime());
            }
            if (type.equals(TimeType.TIME)) {
                Time time = this.resultSet.getTime(field + 1);
                return UTC_CHRONOLOGY.millisOfDay().get(time.getTime());
            }
            if (type.equals(TimestampType.TIMESTAMP)) {
                Timestamp timestamp = this.resultSet.getTimestamp(field + 1);
                return timestamp.getTime();
            }
            throw new PrestoException(StandardErrorCode.INTERNAL_ERROR.toErrorCode(), "Unhandled type for long: " + type.getName());
        }
        catch (SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public double getDouble(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.resultSet.getDouble(field + 1);
        }
        catch (SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Slice getSlice(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            Type type = this.getType(field);
            if (type.equals(VarcharType.VARCHAR)) {
                return Slices.utf8Slice((String)this.resultSet.getString(field + 1));
            }
            if (type.equals(VarbinaryType.VARBINARY)) {
                return Slices.wrappedBuffer((byte[])this.resultSet.getBytes(field + 1));
            }
            throw new PrestoException(StandardErrorCode.INTERNAL_ERROR.toErrorCode(), "Unhandled type for slice: " + type.getName());
        }
        catch (SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean isNull(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        try {
            this.resultSet.getObject(field + 1);
            return this.resultSet.wasNull();
        }
        catch (SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        try (ResultSet resultSet = this.resultSet;
             Statement statement = this.statement;){
            Connection connection = this.connection;
            Throwable throwable = null;
            if (connection != null) {
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private RuntimeException handleSqlException(SQLException e) {
        try {
            this.close();
        }
        catch (Exception closeException) {
            e.addSuppressed(closeException);
        }
        return Throwables.propagate((Throwable)e);
    }
}

