/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import java.util.Objects;
import java.util.Optional;

public class Field {
    private final Optional<NodeLocation> nodeLocation;
    private final Optional<QualifiedObjectName> originTable;
    private final Optional<String> originColumnName;
    private final Optional<QualifiedName> relationAlias;
    private final Optional<String> name;
    private final Type type;
    private final boolean hidden;
    private final boolean aliased;

    public static Field newUnqualified(Optional<NodeLocation> nodeLocation, String name, Type type) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(nodeLocation, Optional.empty(), Optional.of(name), type, false, Optional.empty(), Optional.empty(), false);
    }

    public static Field newUnqualified(Optional<NodeLocation> nodeLocation, Optional<String> name, Type type) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(nodeLocation, Optional.empty(), name, type, false, Optional.empty(), Optional.empty(), false);
    }

    public static Field newUnqualified(Optional<NodeLocation> nodeLocation, Optional<String> name, Type type, Optional<QualifiedObjectName> originTable, Optional<String> originColumn, boolean aliased) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(originTable, "originTable is null");
        return new Field(nodeLocation, Optional.empty(), name, type, false, originTable, originColumn, aliased);
    }

    public static Field newQualified(Optional<NodeLocation> nodeLocation, QualifiedName relationAlias, Optional<String> name, Type type, boolean hidden, Optional<QualifiedObjectName> originTable, Optional<String> originColumn, boolean aliased) {
        Objects.requireNonNull(relationAlias, "relationAlias is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(originTable, "originTable is null");
        return new Field(nodeLocation, Optional.of(relationAlias), name, type, hidden, originTable, originColumn, aliased);
    }

    public Field(Optional<NodeLocation> nodeLocation, Optional<QualifiedName> relationAlias, Optional<String> name, Type type, boolean hidden, Optional<QualifiedObjectName> originTable, Optional<String> originColumnName, boolean aliased) {
        this.nodeLocation = nodeLocation;
        Objects.requireNonNull(relationAlias, "relationAlias is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(originTable, "originTable is null");
        Objects.requireNonNull(originColumnName, "originColumnName is null");
        this.relationAlias = relationAlias;
        this.name = name;
        this.type = type;
        this.hidden = hidden;
        this.originTable = originTable;
        this.originColumnName = originColumnName;
        this.aliased = aliased;
    }

    public static Field newUnqualified(Optional<String> name, Type type) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(Optional.empty(), Optional.empty(), name, type, false, Optional.empty(), Optional.empty(), false);
    }

    public Optional<NodeLocation> getNodeLocation() {
        return this.nodeLocation;
    }

    public Optional<QualifiedObjectName> getOriginTable() {
        return this.originTable;
    }

    public Optional<String> getOriginColumnName() {
        return this.originColumnName;
    }

    public Optional<QualifiedName> getRelationAlias() {
        return this.relationAlias;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isAliased() {
        return this.aliased;
    }

    public boolean matchesPrefix(Optional<QualifiedName> prefix) {
        return !prefix.isPresent() || this.relationAlias.isPresent() && this.relationAlias.get().hasSuffix(prefix.get());
    }

    public boolean canResolve(QualifiedName name) {
        if (!this.name.isPresent()) {
            return false;
        }
        return this.matchesPrefix(name.getPrefix()) && this.name.get().equalsIgnoreCase(name.getSuffix());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.relationAlias.isPresent()) {
            result.append(this.relationAlias.get()).append(".");
        }
        result.append(this.name.orElse("<anonymous>")).append(":").append(this.type);
        return result.toString();
    }
}

