/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer.utils;

import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AlterFunction;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.CreateRole;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateType;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DescribeInput;
import com.facebook.presto.sql.tree.DescribeOutput;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.DropMaterializedView;
import com.facebook.presto.sql.tree.DropRole;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GrantRoles;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.RevokeRoles;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.SetRole;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.ShowCreateFunction;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowGrants;
import com.facebook.presto.sql.tree.ShowRoleGrants;
import com.facebook.presto.sql.tree.ShowRoles;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowStats;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.TruncateTable;
import com.facebook.presto.sql.tree.Use;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class StatementUtils {
    private static final Map<Class<? extends Statement>, QueryType> STATEMENT_QUERY_TYPES;
    private static final List<Class<? extends Statement>> SESSION_TRANSACTION_CONTROL_TYPES;

    private StatementUtils() {
    }

    public static Map<Class<? extends Statement>, QueryType> getAllQueryTypes() {
        return STATEMENT_QUERY_TYPES;
    }

    public static Optional<QueryType> getQueryType(Class<? extends Statement> statement) {
        return Optional.ofNullable(STATEMENT_QUERY_TYPES.get(statement));
    }

    public static boolean isTransactionControlStatement(Statement statement) {
        return statement instanceof StartTransaction || statement instanceof Commit || statement instanceof Rollback;
    }

    public static boolean isSessionTransactionControlStatement(Class<? extends Statement> statement) {
        return SESSION_TRANSACTION_CONTROL_TYPES.contains(statement);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableList.Builder sessionTransactionBuilder = ImmutableList.builder();
        builder.put(Query.class, (Object)QueryType.SELECT);
        builder.put(Explain.class, (Object)QueryType.EXPLAIN);
        builder.put(Analyze.class, (Object)QueryType.ANALYZE);
        builder.put(CreateTableAsSelect.class, (Object)QueryType.INSERT);
        builder.put(Insert.class, (Object)QueryType.INSERT);
        builder.put(RefreshMaterializedView.class, (Object)QueryType.INSERT);
        builder.put(Delete.class, (Object)QueryType.DELETE);
        builder.put(ShowCatalogs.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowCreate.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowCreateFunction.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowFunctions.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowGrants.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowRoles.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowRoleGrants.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowSchemas.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowSession.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowStats.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowTables.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowColumns.class, (Object)QueryType.DESCRIBE);
        builder.put(DescribeInput.class, (Object)QueryType.DESCRIBE);
        builder.put(DescribeOutput.class, (Object)QueryType.DESCRIBE);
        builder.put(CreateSchema.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropSchema.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RenameSchema.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateType.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(AddColumn.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateTable.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RenameTable.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RenameColumn.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropColumn.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropTable.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(TruncateTable.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateMaterializedView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropMaterializedView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateFunction.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(AlterFunction.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropFunction.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Use.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetSession.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(ResetSession.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(StartTransaction.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Commit.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Rollback.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Call.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateRole.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropRole.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(GrantRoles.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RevokeRoles.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetRole.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Grant.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Revoke.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Prepare.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Deallocate.class, (Object)QueryType.DATA_DEFINITION);
        sessionTransactionBuilder.add(Use.class);
        sessionTransactionBuilder.add(SetSession.class);
        sessionTransactionBuilder.add(ResetSession.class);
        sessionTransactionBuilder.add(SetRole.class);
        sessionTransactionBuilder.add(StartTransaction.class);
        sessionTransactionBuilder.add(Commit.class);
        sessionTransactionBuilder.add(Rollback.class);
        sessionTransactionBuilder.add(Prepare.class);
        sessionTransactionBuilder.add(Deallocate.class);
        STATEMENT_QUERY_TYPES = builder.build();
        SESSION_TRANSACTION_CONTROL_TYPES = sessionTransactionBuilder.build();
    }
}

