/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.sql.parser.ParsingOptions;

public class AnalyzerOptions {
    private final ParsingOptions parsingOptions;
    private final boolean isLogFormattedQueryEnabled;
    private final WarningHandlingLevel warningHandlingLevel;

    private AnalyzerOptions(ParsingOptions parsingOptions, boolean isLogFormattedQueryEnabled, WarningHandlingLevel warningHandlingLevel) {
        this.parsingOptions = parsingOptions;
        this.isLogFormattedQueryEnabled = isLogFormattedQueryEnabled;
        this.warningHandlingLevel = warningHandlingLevel;
    }

    public ParsingOptions getParsingOptions() {
        return this.parsingOptions;
    }

    public boolean isLogFormattedQueryEnabled() {
        return this.isLogFormattedQueryEnabled;
    }

    public WarningHandlingLevel getWarningHandlingLevel() {
        return this.warningHandlingLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ParsingOptions parsingOptions = ParsingOptions.builder().build();
        private boolean isLogFormattedQueryEnabled;
        private WarningHandlingLevel warningHandlingLevel = WarningHandlingLevel.NORMAL;

        private Builder() {
        }

        public Builder setParsingOptions(ParsingOptions parsingOptions) {
            this.parsingOptions = parsingOptions;
            return this;
        }

        public Builder setLogFormattedQueryEnabled(boolean logFormattedQueryEnabled) {
            this.isLogFormattedQueryEnabled = logFormattedQueryEnabled;
            return this;
        }

        public Builder setWarningHandlingLevel(WarningHandlingLevel warningHandlingLevel) {
            this.warningHandlingLevel = warningHandlingLevel;
            return this;
        }

        public AnalyzerOptions build() {
            return new AnalyzerOptions(this.parsingOptions, this.isLogFormattedQueryEnabled, this.warningHandlingLevel);
        }
    }
}

