/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.ThriftServerDef;
import io.airlift.units.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ThriftServerDefBuilder {
    private static final AtomicInteger ID = new AtomicInteger(1);
    private int serverPort = 8080;
    private int maxFrameSize = 0x100000;
    private int queuedResponseLimit = 16;
    private TProcessorFactory processorFactory;
    private TProtocolFactory inProtocolFact;
    private TProtocolFactory outProtocolFact;
    private Executor executor;
    private String name = "nifty-" + ID.getAndIncrement();
    private boolean useHeaderTransport = false;
    private Duration clientIdleTimeout = null;

    public ThriftServerDefBuilder() {
        this.inProtocolFact = new TBinaryProtocol.Factory();
        this.outProtocolFact = new TBinaryProtocol.Factory();
        this.executor = new Executor(){

            @Override
            public void execute(Runnable runnable) {
                runnable.run();
            }
        };
    }

    public ThriftServerDefBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ThriftServerDefBuilder listen(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public ThriftServerDefBuilder speaks(TProtocolFactory tProtocolFactory) {
        this.inProtocolFact = tProtocolFactory;
        this.outProtocolFact = tProtocolFactory;
        return this;
    }

    public ThriftServerDefBuilder withProcessor(TProcessor p) {
        this.processorFactory = new TProcessorFactory(p);
        return this;
    }

    public ThriftServerDefBuilder limitFrameSizeTo(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public ThriftServerDefBuilder limitQueuedResponsesPerConnection(int queuedResponseLimit) {
        this.queuedResponseLimit = queuedResponseLimit;
        return this;
    }

    public ThriftServerDefBuilder withProcessorFactory(TProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
        return this;
    }

    public ThriftServerDefBuilder inProtocol(TProtocolFactory tProtocolFactory) {
        this.inProtocolFact = tProtocolFactory;
        return this;
    }

    public ThriftServerDefBuilder outProtocol(TProtocolFactory tProtocolFactory) {
        this.outProtocolFact = tProtocolFactory;
        return this;
    }

    public ThriftServerDefBuilder clientIdleTimeout(Duration clientIdleTimeout) {
        this.clientIdleTimeout = clientIdleTimeout;
        return this;
    }

    public ThriftServerDefBuilder using(Executor exe) {
        this.executor = exe;
        return this;
    }

    public ThriftServerDefBuilder usingHeaderTransport() {
        this.useHeaderTransport = true;
        return this;
    }

    public ThriftServerDef build() {
        if (this.processorFactory == null) {
            throw new IllegalStateException("processor not defined !");
        }
        return new ThriftServerDef(this.name, this.serverPort, this.maxFrameSize, this.queuedResponseLimit, this.processorFactory, this.inProtocolFact, this.outProtocolFact, this.clientIdleTimeout, this.useHeaderTransport, this.executor);
    }
}

