/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.TNiftyTransport;
import com.facebook.nifty.core.ThriftTransportType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public class ThriftFrameDecoder
extends FrameDecoder {
    public static final int MESSAGE_FRAME_SIZE = 4;
    private final int maxFrameSize;
    private final TProtocolFactory inputProtocolFactory;

    public ThriftFrameDecoder(int maxFrameSize, TProtocolFactory inputProtocolFactory) {
        this.maxFrameSize = maxFrameSize;
        this.inputProtocolFactory = inputProtocolFactory;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (!buffer.readable()) {
            return null;
        }
        short firstByte = buffer.getUnsignedByte(0);
        if (firstByte >= 128) {
            return this.tryDecodeUnframedMessage(ctx, channel, buffer);
        }
        if (buffer.readableBytes() < 4) {
            return null;
        }
        return this.tryDecodeFramedMessage(ctx, channel, buffer);
    }

    private TTransport tryDecodeFramedMessage(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) {
        int messageStartReaderIndex = buffer.readerIndex();
        int messageContentsLength = buffer.getInt(messageStartReaderIndex);
        int messageLength = messageContentsLength + 4;
        if (messageContentsLength > this.maxFrameSize) {
            Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new TooLongFrameException("Maximum frame size of " + this.maxFrameSize + " exceeded"));
        }
        int messageContentsOffset = messageStartReaderIndex + 4;
        if (messageLength == 0) {
            buffer.readerIndex(messageContentsOffset);
            return null;
        }
        if (buffer.readableBytes() < messageLength) {
            return null;
        }
        ChannelBuffer messageBuffer = this.extractFrame(buffer, messageContentsOffset, messageContentsLength);
        buffer.readerIndex(messageStartReaderIndex + messageLength);
        return new TNiftyTransport(channel, messageBuffer, ThriftTransportType.FRAMED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTransport tryDecodeUnframedMessage(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws TException {
        int messageLength = 0;
        int messageStartReaderIndex = buffer.readerIndex();
        try {
            TNiftyTransport decodeAttemptTransport = new TNiftyTransport(channel, buffer, ThriftTransportType.UNFRAMED);
            TProtocol inputProtocol = this.inputProtocolFactory.getProtocol((TTransport)decodeAttemptTransport);
            inputProtocol.readMessageBegin();
            TProtocolUtil.skip((TProtocol)inputProtocol, (byte)12);
            inputProtocol.readMessageEnd();
            messageLength = buffer.readerIndex() - messageStartReaderIndex;
        }
        catch (IndexOutOfBoundsException e) {
            TTransport tTransport = null;
            return tTransport;
        }
        finally {
            if (buffer.readerIndex() - messageStartReaderIndex > this.maxFrameSize) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new TooLongFrameException("Maximum frame size of " + this.maxFrameSize + " exceeded"));
            }
            buffer.readerIndex(messageStartReaderIndex);
        }
        if (messageLength <= 0) {
            return null;
        }
        ChannelBuffer messageBuffer = this.extractFrame(buffer, messageStartReaderIndex, messageLength);
        buffer.readerIndex(messageStartReaderIndex + messageLength);
        return new TNiftyTransport(channel, messageBuffer, ThriftTransportType.UNFRAMED);
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

