/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.ThriftTransportType;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;

public class TNiftyTransport
extends TTransport {
    private final Channel channel;
    private final ChannelBuffer in;
    private final ThriftTransportType thriftTransportType;
    private final ChannelBuffer out;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 1024;

    public TNiftyTransport(Channel channel, ChannelBuffer in, ThriftTransportType thriftTransportType) {
        this.channel = channel;
        this.in = in;
        this.thriftTransportType = thriftTransportType;
        this.out = ChannelBuffers.dynamicBuffer((int)1024);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void open() throws TTransportException {
    }

    public void close() {
        this.channel.close();
    }

    public int read(byte[] bytes, int offset, int length) throws TTransportException {
        int _read = Math.min(this.in.readableBytes(), length);
        this.in.readBytes(bytes, offset, _read);
        return _read;
    }

    public int readAll(byte[] bytes, int offset, int length) throws TTransportException {
        this.in.readBytes(bytes, offset, length);
        return length;
    }

    public void write(byte[] bytes, int offset, int length) throws TTransportException {
        this.out.writeBytes(bytes, offset, length);
    }

    public ChannelBuffer getOutputBuffer() {
        return this.out;
    }

    public ThriftTransportType getTransportType() {
        return this.thriftTransportType;
    }

    public void flush() throws TTransportException {
    }
}

