/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownUtil {
    private static final Logger log = LoggerFactory.getLogger(ShutdownUtil.class);

    public static void shutdownChannelFactory(ChannelFactory channelFactory, ExecutorService bossExecutor, ExecutorService workerExecutor, ChannelGroup allChannels) {
        if (allChannels != null) {
            ShutdownUtil.closeChannels(allChannels);
        }
        if (channelFactory != null) {
            channelFactory.shutdown();
        }
        if (bossExecutor != null) {
            ShutdownUtil.shutdownExecutor(bossExecutor, "bossExecutor");
        }
        if (workerExecutor != null) {
            ShutdownUtil.shutdownExecutor(workerExecutor, "workerExecutor");
        }
        if (channelFactory != null) {
            channelFactory.releaseExternalResources();
        }
    }

    public static void closeChannels(ChannelGroup allChannels) {
        if (allChannels.size() > 0) {
            try {
                log.info("Closing " + allChannels.size() + " open client connections");
                if (!allChannels.close().await(5L, TimeUnit.SECONDS)) {
                    log.warn("Failed to close all open client connections");
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while closing client connections");
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void shutdownExecutor(ExecutorService executor, String name) {
        executor.shutdown();
        try {
            log.info("Waiting for {} to shutdown", (Object)name);
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                log.warn("{} did not shutdown properly", (Object)name);
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for {} to shutdown", (Object)name);
            Thread.currentThread().interrupt();
        }
    }
}

