/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.NettyConfigBuilder;
import com.facebook.nifty.core.NettyServerTransport;
import com.facebook.nifty.core.ShutdownUtil;
import com.facebook.nifty.core.ThriftServerDef;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ServerChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class NiftyBootstrap {
    private final ChannelGroup allChannels;
    private ArrayList<NettyServerTransport> transports;
    private ExecutorService bossExecutor;
    private ExecutorService workerExecutor;
    private final Timer timer;
    private NioServerSocketChannelFactory serverChannelFactory;

    @Inject
    public NiftyBootstrap(Set<ThriftServerDef> thriftServerDefs, NettyConfigBuilder configBuilder, ChannelGroup allChannels) {
        this.allChannels = allChannels;
        this.transports = new ArrayList();
        this.timer = new HashedWheelTimer();
        for (ThriftServerDef thriftServerDef : thriftServerDefs) {
            this.transports.add(new NettyServerTransport(thriftServerDef, configBuilder, allChannels, this.timer));
        }
    }

    @PostConstruct
    public void start() {
        this.bossExecutor = Executors.newCachedThreadPool();
        this.workerExecutor = Executors.newCachedThreadPool();
        this.serverChannelFactory = new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor);
        for (NettyServerTransport transport : this.transports) {
            transport.start((ServerChannelFactory)this.serverChannelFactory);
        }
    }

    @PreDestroy
    public void stop() {
        for (NettyServerTransport transport : this.transports) {
            try {
                transport.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        ShutdownUtil.shutdownChannelFactory((ChannelFactory)this.serverChannelFactory, this.bossExecutor, this.workerExecutor, this.allChannels);
    }
}

