/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.ChannelStatistics;
import com.facebook.nifty.core.IdleDisconnectHandler;
import com.facebook.nifty.core.NettyConfigBuilder;
import com.facebook.nifty.core.NiftyDispatcher;
import com.facebook.nifty.core.ShutdownUtil;
import com.facebook.nifty.core.ThriftFrameDecoder;
import com.facebook.nifty.core.ThriftServerDef;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ServerChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerTransport
implements ExternalResourceReleasable {
    private static final Logger log = LoggerFactory.getLogger(NettyServerTransport.class);
    private final int port;
    private final ChannelPipelineFactory pipelineFactory;
    private static final int NO_WRITER_IDLE_TIMEOUT = 0;
    private static final int NO_ALL_IDLE_TIMEOUT = 0;
    private ServerBootstrap bootstrap;
    private Channel serverChannel;
    private final ThriftServerDef def;
    private final NettyConfigBuilder configBuilder;

    @Inject
    public NettyServerTransport(final ThriftServerDef def, NettyConfigBuilder configBuilder, final ChannelGroup allChannels, final Timer timer) {
        this.def = def;
        this.configBuilder = configBuilder;
        this.port = def.getServerPort();
        if (def.isHeaderTransport()) {
            throw new UnsupportedOperationException("ASF version does not support THeaderTransport !");
        }
        this.pipelineFactory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                cp.addLast(ChannelStatistics.NAME, (ChannelHandler)new ChannelStatistics(allChannels));
                cp.addLast("frameDecoder", (ChannelHandler)new ThriftFrameDecoder(def.getMaxFrameSize(), def.getInProtocolFactory()));
                if (def.getClientIdleTimeout() != null) {
                    cp.addLast("idleTimeoutHandler", (ChannelHandler)new IdleStateHandler(timer, (long)((int)def.getClientIdleTimeout().toMillis()), 0L, 0L, TimeUnit.MILLISECONDS));
                    cp.addLast("idleDisconnectHandler", (ChannelHandler)new IdleDisconnectHandler());
                }
                cp.addLast("dispatcher", (ChannelHandler)new NiftyDispatcher(def));
                return cp;
            }
        };
    }

    public void start(ServerChannelFactory serverChannelFactory) {
        this.bootstrap = new ServerBootstrap((ChannelFactory)serverChannelFactory);
        this.bootstrap.setOptions(this.configBuilder.getOptions());
        this.bootstrap.setPipelineFactory(this.pipelineFactory);
        log.info("starting transport {}:{}", (Object)this.def.getName(), (Object)this.port);
        this.serverChannel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
    }

    public void stop() throws InterruptedException {
        if (this.serverChannel != null) {
            log.info("stopping transport {}:{}", (Object)this.def.getName(), (Object)this.port);
            final CountDownLatch latch = new CountDownLatch(1);
            this.serverChannel.close().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (NettyServerTransport.this.def.getExecutor() instanceof ExecutorService) {
                        ExecutorService exe = (ExecutorService)NettyServerTransport.this.def.getExecutor();
                        ShutdownUtil.shutdownExecutor(exe, "dispatcher");
                    }
                    latch.countDown();
                }
            });
            latch.await();
            this.serverChannel = null;
        }
    }

    public Channel getServerChannel() {
        return this.serverChannel;
    }

    public void releaseExternalResources() {
        this.bootstrap.releaseExternalResources();
    }
}

