/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.TNiftyAsyncClientTransport;
import com.facebook.nifty.client.TNiftyClientListener;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ExceptionEvent;

public class TNiftyClientTransport
extends TNiftyAsyncClientTransport {
    private final ChannelBuffer readBuffer;
    private final Duration readTimeout;
    private final Lock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private final Condition condition = this.lock.newCondition();
    private boolean closed;
    private Throwable exception;

    public TNiftyClientTransport(Channel channel, Duration readTimeout) {
        super(channel);
        this.readTimeout = readTimeout;
        this.readBuffer = ChannelBuffers.dynamicBuffer((int)256);
        this.setListener(new TNiftyClientListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFrameRead(Channel c, ChannelBuffer buffer) {
                TNiftyClientTransport.this.lock.lock();
                try {
                    TNiftyClientTransport.this.readBuffer.discardReadBytes();
                    TNiftyClientTransport.this.readBuffer.writeBytes(buffer);
                    TNiftyClientTransport.this.condition.signal();
                }
                finally {
                    TNiftyClientTransport.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChannelClosedOrDisconnected(Channel channel) {
                TNiftyClientTransport.this.lock.lock();
                try {
                    TNiftyClientTransport.this.closed = true;
                    TNiftyClientTransport.this.condition.signal();
                }
                finally {
                    TNiftyClientTransport.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onExceptionEvent(ExceptionEvent e) {
                TNiftyClientTransport.this.lock.lock();
                try {
                    TNiftyClientTransport.this.exception = e.getCause();
                    TNiftyClientTransport.this.condition.signal();
                }
                finally {
                    TNiftyClientTransport.this.lock.unlock();
                }
            }
        });
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws TTransportException {
        try {
            return this.read(bytes, offset, length, this.readTimeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TTransportException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(byte[] bytes, int offset, int length, Duration timeout) throws InterruptedException, TTransportException {
        long timeRemaining = (long)timeout.convertTo(TimeUnit.NANOSECONDS);
        this.lock.lock();
        try {
            while (!this.closed) {
                int bytesAvailable = this.readBuffer.readableBytes();
                if (bytesAvailable > 0) {
                    int begin = this.readBuffer.readerIndex();
                    this.readBuffer.readBytes(bytes, offset, Math.min(bytesAvailable, length));
                    int end = this.readBuffer.readerIndex();
                    int n = end - begin;
                    return n;
                }
                if (timeRemaining <= 0L) break;
                timeRemaining = this.condition.awaitNanos(timeRemaining);
                if (this.exception == null) continue;
                try {
                    throw new TTransportException(this.exception);
                }
                catch (Throwable throwable) {
                    this.exception = null;
                    this.closed = true;
                    this.close();
                    throw throwable;
                }
            }
            if (this.closed) {
                throw new TTransportException("channel closed !");
            }
        }
        finally {
            this.lock.unlock();
        }
        throw new TTransportException(String.format("read timeout, %d ms has elapsed", (long)timeout.toMillis()));
    }
}

