/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.NettyClientConfigBuilder;
import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.NiftyClientChannelPipelineFactory;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.client.TNiftyClientTransport;
import com.facebook.nifty.client.socks.Socks4ClientBootstrap;
import com.facebook.nifty.core.ShutdownUtil;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

public class NiftyClient
implements Closeable {
    public static final Duration DEFAULT_CONNECT_TIMEOUT = new Duration(2.0, TimeUnit.SECONDS);
    public static final Duration DEFAULT_READ_TIMEOUT = new Duration(2.0, TimeUnit.SECONDS);
    private static final Duration DEFAULT_WRITE_TIMEOUT = new Duration(2.0, TimeUnit.SECONDS);
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x1000000;
    private final NettyClientConfigBuilder configBuilder;
    private final ExecutorService bossExecutor;
    private final ExecutorService workerExecutor;
    private final NioClientSocketChannelFactory channelFactory;
    private final InetSocketAddress defaultSocksProxyAddress;
    private final ChannelGroup allChannels = new DefaultChannelGroup();
    private final HashedWheelTimer hashedWheelTimer;

    public NiftyClient() {
        this(new NettyClientConfigBuilder());
    }

    public NiftyClient(NettyClientConfigBuilder configBuilder) {
        this(configBuilder, null);
    }

    public NiftyClient(NettyClientConfigBuilder configBuilder, @Nullable InetSocketAddress defaultSocksProxyAddress) {
        this.configBuilder = configBuilder;
        String name = configBuilder.getNiftyName();
        String prefix = "nifty-client" + (Strings.isNullOrEmpty((String)name) ? "" : "-" + name);
        this.hashedWheelTimer = new HashedWheelTimer(this.renamingDaemonThreadFactory(prefix + "-timer-%s"));
        this.bossExecutor = Executors.newCachedThreadPool(this.renamingDaemonThreadFactory(prefix + "-boss-%s"));
        this.workerExecutor = Executors.newCachedThreadPool(this.renamingDaemonThreadFactory(prefix + "-worker-%s"));
        this.defaultSocksProxyAddress = defaultSocksProxyAddress;
        int bossThreadCount = configBuilder.getNiftyBossThreadCount();
        int workerThreadCount = configBuilder.getNiftyWorkerThreadCount();
        NioWorkerPool workerPool = new NioWorkerPool((Executor)this.workerExecutor, workerThreadCount, ThreadNameDeterminer.CURRENT);
        NioClientBossPool bossPool = new NioClientBossPool((Executor)this.bossExecutor, bossThreadCount, (Timer)this.hashedWheelTimer, ThreadNameDeterminer.CURRENT);
        this.channelFactory = new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
    }

    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector) {
        return this.connectAsync(clientChannelConnector, DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT, DEFAULT_WRITE_TIMEOUT, 0x1000000, this.defaultSocksProxyAddress);
    }

    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector, Duration connectTimeout, Duration receiveTimeout, Duration sendTimeout, int maxFrameSize) {
        return this.connectAsync(clientChannelConnector, connectTimeout, receiveTimeout, sendTimeout, maxFrameSize, this.defaultSocksProxyAddress);
    }

    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector, Duration connectTimeout, Duration receiveTimeout, Duration sendTimeout, int maxFrameSize, @Nullable InetSocketAddress socksProxyAddress) {
        ClientBootstrap bootstrap = this.createClientBootstrap(socksProxyAddress);
        bootstrap.setOptions(this.configBuilder.getOptions());
        bootstrap.setOption("connectTimeoutMillis", (Object)((long)connectTimeout.toMillis()));
        bootstrap.setPipelineFactory(clientChannelConnector.newChannelPipelineFactory(maxFrameSize));
        ChannelFuture nettyChannelFuture = clientChannelConnector.connect(bootstrap);
        nettyChannelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Channel channel = future.getChannel();
                if (channel != null && channel.isOpen()) {
                    NiftyClient.this.allChannels.add((Object)channel);
                    channel.getCloseFuture().addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            Channel channel = future.getChannel();
                            NiftyClient.this.allChannels.remove((Object)channel);
                        }
                    });
                }
            }
        });
        return new TNiftyFuture(clientChannelConnector, receiveTimeout, sendTimeout, nettyChannelFuture);
    }

    public TNiftyClientTransport connectSync(InetSocketAddress addr) throws TTransportException, InterruptedException {
        return this.connectSync(addr, DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT, DEFAULT_WRITE_TIMEOUT, 0x1000000);
    }

    public TNiftyClientTransport connectSync(InetSocketAddress addr, Duration connectTimeout, Duration receiveTimeout, Duration sendTimeout, int maxFrameSize) throws TTransportException, InterruptedException {
        return this.connectSync(addr, connectTimeout, receiveTimeout, sendTimeout, maxFrameSize, this.defaultSocksProxyAddress);
    }

    public TNiftyClientTransport connectSync(InetSocketAddress addr, Duration connectTimeout, Duration receiveTimeout, Duration sendTimeout, int maxFrameSize, @Nullable InetSocketAddress socksProxyAddress) throws TTransportException, InterruptedException {
        ClientBootstrap bootstrap = this.createClientBootstrap(socksProxyAddress);
        bootstrap.setOptions(this.configBuilder.getOptions());
        bootstrap.setOption("connectTimeoutMillis", (Object)((long)connectTimeout.toMillis()));
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new NiftyClientChannelPipelineFactory(maxFrameSize));
        ChannelFuture f = bootstrap.connect((SocketAddress)addr);
        f.await();
        Channel channel = f.getChannel();
        if (f.getCause() != null) {
            String message = String.format("unable to connect to %s:%d %s", addr.getHostName(), addr.getPort(), socksProxyAddress == null ? "" : "via socks proxy at " + socksProxyAddress);
            throw new TTransportException(message, f.getCause());
        }
        if (f.isSuccess() && channel != null) {
            if (channel.isOpen()) {
                this.allChannels.add((Object)channel);
                channel.getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        Channel channel = future.getChannel();
                        NiftyClient.this.allChannels.remove((Object)channel);
                    }
                });
            }
            TNiftyClientTransport transport = new TNiftyClientTransport(channel, receiveTimeout);
            channel.getPipeline().addLast("thrift", (ChannelHandler)transport);
            return transport;
        }
        throw new TTransportException(String.format("unknown error connecting to %s:%d %s", addr.getHostName(), addr.getPort(), socksProxyAddress == null ? "" : "via socks proxy at " + socksProxyAddress));
    }

    @Override
    public void close() {
        this.hashedWheelTimer.stop();
        ShutdownUtil.shutdownChannelFactory((ChannelFactory)this.channelFactory, (ExecutorService)this.bossExecutor, (ExecutorService)this.workerExecutor, (ChannelGroup)this.allChannels);
    }

    private ThreadFactory renamingDaemonThreadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).build();
    }

    private ClientBootstrap createClientBootstrap(InetSocketAddress socksProxyAddress) {
        if (socksProxyAddress != null) {
            return new Socks4ClientBootstrap((ChannelFactory)this.channelFactory, socksProxyAddress);
        }
        return new ClientBootstrap((ChannelFactory)this.channelFactory);
    }

    private class TNiftyFuture<T extends NiftyClientChannel>
    extends AbstractFuture<T> {
        private TNiftyFuture(final NiftyClientConnector<T> clientChannelConnector, final Duration receiveTimeout, final Duration sendTimeout, ChannelFuture channelFuture) {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Channel nettyChannel = future.getChannel();
                        Object channel = clientChannelConnector.newThriftClientChannel(nettyChannel, (Timer)NiftyClient.this.hashedWheelTimer);
                        channel.setReceiveTimeout(receiveTimeout);
                        channel.setSendTimeout(sendTimeout);
                        TNiftyFuture.this.set(channel);
                    } else if (future.isCancelled()) {
                        TNiftyFuture.this.cancel(true);
                    } else {
                        TNiftyFuture.this.setException(future.getCause());
                    }
                }
            });
        }
    }
}

