/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.core.NettyConfigBuilderBase;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;

public class NettyClientConfigBuilder
extends NettyConfigBuilderBase {
    private static final int DEFAULT_BOSS_THREAD_COUNT = 1;
    private static final int DEFAULT_WORKER_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private int bossThreadCount = 1;
    private int workerThreadCount = DEFAULT_WORKER_THREAD_COUNT;
    private String name = "";
    private final NioSocketChannelConfig socketChannelConfig = (NioSocketChannelConfig)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{NioSocketChannelConfig.class}, (InvocationHandler)new NettyConfigBuilderBase.Magic((NettyConfigBuilderBase)this, ""));

    @Inject
    public NettyClientConfigBuilder() {
    }

    public NioSocketChannelConfig getSocketChannelConfig() {
        return this.socketChannelConfig;
    }

    public NettyClientConfigBuilder setNiftyBossThreadCount(int bossThreadCount) {
        this.bossThreadCount = bossThreadCount;
        return this;
    }

    public int getNiftyBossThreadCount() {
        return this.bossThreadCount;
    }

    public NettyClientConfigBuilder setNiftyWorkerThreadCount(int workerThreadCount) {
        this.workerThreadCount = workerThreadCount;
        return this;
    }

    public int getNiftyWorkerThreadCount() {
        return this.workerThreadCount;
    }

    public NettyClientConfigBuilder setNiftyName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.name = name;
        return this;
    }

    public String getNiftyName() {
        return this.name;
    }
}

