/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.AbstractClientConnector;
import com.facebook.nifty.client.FramedClientChannel;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.util.Timer;

public class FramedClientConnector
extends AbstractClientConnector<FramedClientChannel> {
    private static final int LENGTH_FIELD_OFFSET = 0;
    private static final int LENGTH_FIELD_LENGTH = 4;
    private static final int LENGTH_ADJUSTMENT = 0;
    private static final int INITIAL_BYTES_TO_STRIP = 4;

    public FramedClientConnector(InetSocketAddress address) {
        super(address);
    }

    public FramedClientConnector(HostAndPort address) {
        super(address);
    }

    @Override
    public FramedClientChannel newThriftClientChannel(Channel nettyChannel, Timer timer) {
        FramedClientChannel channel = new FramedClientChannel(nettyChannel, timer);
        channel.getNettyChannel().getPipeline().addLast("thriftHandler", (ChannelHandler)channel);
        return channel;
    }

    @Override
    public ChannelPipelineFactory newChannelPipelineFactory(final int maxFrameSize) {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                cp.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                cp.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(maxFrameSize, 0, 4, 0, 4));
                return cp;
            }
        };
    }
}

