/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.NiftyClientChannel;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.handler.timeout.WriteTimeoutException;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

@NotThreadSafe
public abstract class AbstractClientChannel
extends SimpleChannelHandler
implements NiftyClientChannel {
    private final Channel nettyChannel;
    private Duration sendTimeout = null;
    private Duration requestTimeout = null;
    private final Map<Integer, Request> requestMap = new HashMap<Integer, Request>();
    private volatile TException channelError;
    private final Timer timer;

    public AbstractClientChannel(Channel nettyChannel, Timer timer) {
        this.nettyChannel = nettyChannel;
        this.timer = timer;
    }

    @Override
    public Channel getNettyChannel() {
        return this.nettyChannel;
    }

    protected abstract ChannelBuffer extractResponse(Object var1) throws TTransportException;

    protected abstract int extractSequenceId(ChannelBuffer var1) throws TTransportException;

    protected abstract ChannelFuture writeRequest(ChannelBuffer var1);

    @Override
    public void close() {
        this.getNettyChannel().close();
    }

    @Override
    public void setSendTimeout(Duration sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    @Override
    public Duration getSendTimeout() {
        return this.sendTimeout;
    }

    @Override
    public void setReceiveTimeout(Duration receiveTimeout) {
        this.requestTimeout = receiveTimeout;
    }

    @Override
    public Duration getReceiveTimeout() {
        return this.requestTimeout;
    }

    @Override
    public boolean hasError() {
        return this.channelError != null;
    }

    @Override
    public TException getError() {
        return this.channelError;
    }

    @Override
    public void executeInIoThread(Runnable runnable) {
        NioSocketChannel nioSocketChannel = (NioSocketChannel)this.getNettyChannel();
        nioSocketChannel.getWorker().executeInIoThread(runnable, true);
    }

    private boolean hasRequestTimeout() {
        return this.requestTimeout != null;
    }

    @Override
    public void sendAsynchronousRequest(final ChannelBuffer message, final boolean oneway, final NiftyClientChannel.Listener listener) throws TException {
        final int sequenceId = this.extractSequenceId(message);
        this.executeInIoThread(new Runnable(){

            @Override
            public void run() {
                ChannelFuture sendFuture = AbstractClientChannel.this.writeRequest(message);
                final Request request = AbstractClientChannel.this.makeRequest(sequenceId, listener);
                AbstractClientChannel.this.queueSendTimeout(request);
                sendFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            AbstractClientChannel.this.cancelRequestTimeouts(request);
                            listener.onRequestSent();
                            if (oneway) {
                                AbstractClientChannel.this.retireRequest(sequenceId);
                            } else {
                                AbstractClientChannel.this.queueReceiveTimeout(request);
                            }
                        } else {
                            TTransportException transportException = new TTransportException("Sending request failed", future.getCause());
                            listener.onChannelError((TException)transportException);
                            AbstractClientChannel.this.onError((Throwable)transportException);
                        }
                    }
                });
            }
        });
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        try {
            ChannelBuffer response = this.extractResponse(e.getMessage());
            if (response != null) {
                int sequenceId = this.extractSequenceId(response);
                this.onResponseReceived(sequenceId, response);
            } else {
                ctx.sendUpstream((ChannelEvent)e);
            }
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        Throwable t = event.getCause();
        ctx.getChannel().close();
        this.onError(t);
    }

    private Request makeRequest(int sequenceId, NiftyClientChannel.Listener listener) {
        Request request = new Request(sequenceId, listener);
        this.requestMap.put(sequenceId, request);
        return request;
    }

    private Request retireRequest(int sequenceId) {
        Request request = this.requestMap.remove(sequenceId);
        this.cancelRequestTimeouts(request);
        return request;
    }

    private void cancelRequestTimeouts(Request request) {
        Timeout responseTimeout;
        Timeout sendTimeout = request.getSendTimeout();
        if (sendTimeout != null) {
            sendTimeout.cancel();
        }
        if ((responseTimeout = request.getReceiveTimeout()) != null) {
            responseTimeout.cancel();
        }
    }

    private void cancelAllTimeouts() {
        for (Request request : this.requestMap.values()) {
            this.cancelRequestTimeouts(request);
        }
    }

    private void onResponseReceived(int sequenceId, ChannelBuffer response) {
        Request request = this.retireRequest(sequenceId);
        if (request == null) {
            this.onError((Throwable)new TTransportException("Bad sequence id in response: " + sequenceId));
        } else {
            request.getListener().onResponseReceived(response);
        }
    }

    protected void onError(Throwable t) {
        TException wrappedException = this.wrapException(t);
        if (this.channelError == null) {
            this.channelError = wrappedException;
        }
        this.cancelAllTimeouts();
        ArrayList<Request> requests = new ArrayList<Request>();
        requests.addAll(this.requestMap.values());
        this.requestMap.clear();
        for (Request request : requests) {
            request.getListener().onChannelError(wrappedException);
        }
    }

    protected TException wrapException(Throwable t) {
        if (t instanceof TException) {
            return (TException)t;
        }
        return new TException(t);
    }

    private void onSendTimeoutExpired(Request request) {
        Timeout expiredTimeout = request.getSendTimeout();
        if (!expiredTimeout.isCancelled()) {
            this.cancelAllTimeouts();
            WriteTimeoutException timeoutException = new WriteTimeoutException("Timed out waiting " + this.getSendTimeout() + " to send request");
            request.getListener().onChannelError((TException)new TTransportException((Throwable)timeoutException));
        }
    }

    private void onReceiveTimeoutExpired(Request request) {
        Timeout expiredTimeout = request.getReceiveTimeout();
        if (!expiredTimeout.isCancelled()) {
            this.cancelAllTimeouts();
            ReadTimeoutException timeoutException = new ReadTimeoutException("Timed out waiting " + this.getReceiveTimeout() + " to receive response");
            request.getListener().onChannelError((TException)new TTransportException((Throwable)timeoutException));
        }
    }

    private void queueSendTimeout(final Request request) {
        double sendTimeoutMs;
        if (this.sendTimeout != null && (sendTimeoutMs = this.sendTimeout.toMillis()) > 0.0) {
            IoThreadBoundTimerTask sendTimeoutTask = new IoThreadBoundTimerTask(this, new TimerTask(){

                public void run(Timeout timeout) {
                    AbstractClientChannel.this.onSendTimeoutExpired(request);
                }
            });
            Timeout sendTimeout = this.timer.newTimeout((TimerTask)sendTimeoutTask, (long)sendTimeoutMs, TimeUnit.MILLISECONDS);
            request.setSendTimeout(sendTimeout);
        }
    }

    private void queueReceiveTimeout(final Request request) {
        double requestTimeoutMs;
        if (this.requestTimeout != null && (requestTimeoutMs = this.requestTimeout.toMillis()) > 0.0) {
            IoThreadBoundTimerTask receiveTimeoutTask = new IoThreadBoundTimerTask(this, new TimerTask(){

                public void run(Timeout timeout) {
                    AbstractClientChannel.this.onReceiveTimeoutExpired(request);
                }
            });
            Timeout timeout = this.timer.newTimeout((TimerTask)receiveTimeoutTask, (long)requestTimeoutMs, TimeUnit.MILLISECONDS);
            request.setReceiveTimeout(timeout);
        }
    }

    private static class Request {
        private final int sequenceId;
        private final NiftyClientChannel.Listener listener;
        private Timeout sendTimeout;
        private Timeout receiveTimeout;

        public Request(int sequenceId, NiftyClientChannel.Listener listener) {
            this.sequenceId = sequenceId;
            this.listener = listener;
        }

        public int getSequenceId() {
            return this.sequenceId;
        }

        public NiftyClientChannel.Listener getListener() {
            return this.listener;
        }

        public Timeout getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(Timeout receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public Timeout getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(Timeout sendTimeout) {
            this.sendTimeout = sendTimeout;
        }
    }

    private static class IoThreadBoundTimerTask
    implements TimerTask {
        private final NiftyClientChannel channel;
        private final TimerTask timerTask;

        public IoThreadBoundTimerTask(NiftyClientChannel channel, TimerTask timerTask) {
            this.channel = channel;
            this.timerTask = timerTask;
        }

        public void run(final Timeout timeout) throws Exception {
            this.channel.executeInIoThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        IoThreadBoundTimerTask.this.timerTask.run(timeout);
                    }
                    catch (Exception e) {
                        Channels.fireExceptionCaught((Channel)IoThreadBoundTimerTask.this.channel.getNettyChannel(), (Throwable)e);
                    }
                }
            });
        }
    }
}

