/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v7.widget.RecyclerView;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.ViewportInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ViewportManager {
    private int mCurrentFirstVisiblePosition;
    private int mCurrentLastVisiblePosition;
    private int mCurrentFirstFullyVisiblePosition;
    private int mCurrentLastFullyVisiblePosition;
    private int mTotalItemCount;
    private int mScrollingState;
    private boolean mIsDataChangedVisible;
    @Nullable
    private List<ViewportInfo.ViewportChanged> mViewportChangedListeners;
    private final LayoutInfo mLayoutInfo;
    private final Handler mMainThreadHandler;
    private final ViewportScrollListener mViewportScrollListener = new ViewportScrollListener();
    private final Runnable mViewportChangedRunnable = new Runnable(){

        @Override
        public void run() {
            ViewportManager.this.onViewportChanged();
        }
    };

    ViewportManager(int currentFirstVisiblePosition, int currentLastVisiblePosition, LayoutInfo layoutInfo, Handler mainThreadHandler, int initialScrollingState) {
        this.mCurrentFirstVisiblePosition = currentFirstVisiblePosition;
        this.mCurrentLastVisiblePosition = currentLastVisiblePosition;
        this.mCurrentFirstFullyVisiblePosition = layoutInfo.findFirstFullyVisibleItemPosition();
        this.mCurrentLastFullyVisiblePosition = layoutInfo.findLastFullyVisibleItemPosition();
        this.mTotalItemCount = layoutInfo.getItemCount();
        this.mScrollingState = initialScrollingState;
        this.mLayoutInfo = layoutInfo;
        this.mMainThreadHandler = mainThreadHandler;
    }

    @UiThread
    void onViewportChanged() {
        int firstVisiblePosition = this.mLayoutInfo.findFirstVisibleItemPosition();
        int lastVisiblePosition = this.mLayoutInfo.findLastVisibleItemPosition();
        int firstFullyVisibleItemPosition = this.mLayoutInfo.findFirstFullyVisibleItemPosition();
        int lastFullyVisibleItemPosition = this.mLayoutInfo.findLastFullyVisibleItemPosition();
        int totalItemCount = this.mLayoutInfo.getItemCount();
        if (firstVisiblePosition < 0 || lastVisiblePosition < 0) {
            return;
        }
        if (firstVisiblePosition == this.mCurrentFirstVisiblePosition && lastVisiblePosition == this.mCurrentLastVisiblePosition && firstFullyVisibleItemPosition == this.mCurrentFirstFullyVisiblePosition && lastFullyVisibleItemPosition == this.mCurrentLastFullyVisiblePosition && totalItemCount == this.mTotalItemCount && !this.mIsDataChangedVisible) {
            return;
        }
        this.mCurrentFirstVisiblePosition = firstVisiblePosition;
        this.mCurrentLastVisiblePosition = lastVisiblePosition;
        this.mCurrentFirstFullyVisiblePosition = firstFullyVisibleItemPosition;
        this.mCurrentLastFullyVisiblePosition = lastFullyVisibleItemPosition;
        this.mTotalItemCount = totalItemCount;
        if (this.mViewportChangedListeners == null || this.mViewportChangedListeners.isEmpty()) {
            return;
        }
        for (ViewportInfo.ViewportChanged viewportChangedListener : this.mViewportChangedListeners) {
            viewportChangedListener.viewportChanged(firstVisiblePosition, lastVisiblePosition, firstFullyVisibleItemPosition, lastFullyVisibleItemPosition, this.mIsDataChangedVisible);
        }
        this.resetDataChangedIsVisible();
    }

    @UiThread
    void onViewportchangedAfterViewAdded(int addedPosition) {
        boolean isPositionAddedWithinRange;
        if (this.isScrolling()) {
            return;
        }
        boolean isRangeNotInitialised = this.mCurrentFirstVisiblePosition <= 0 && this.mCurrentLastVisiblePosition <= 0;
        boolean bl = isPositionAddedWithinRange = this.mCurrentFirstVisiblePosition <= addedPosition && addedPosition <= this.mCurrentLastVisiblePosition;
        if (isRangeNotInitialised || isPositionAddedWithinRange) {
            this.putViewportChangedRunnableToEndOfUIThreadQueue();
        }
    }

    @UiThread
    void onViewportChangedAfterViewRemoval(int removedPosition) {
        boolean isPositionRemovedWithinRange;
        if (this.isScrolling()) {
            return;
        }
        boolean isRangeNotInitialised = this.mCurrentFirstVisiblePosition <= 0 && this.mCurrentLastVisiblePosition <= 0;
        boolean bl = isPositionRemovedWithinRange = this.mCurrentFirstVisiblePosition <= removedPosition && removedPosition <= this.mCurrentLastVisiblePosition;
        if (isRangeNotInitialised || isPositionRemovedWithinRange) {
            this.putViewportChangedRunnableToEndOfUIThreadQueue();
        }
    }

    @UiThread
    void setDataChangedIsVisible(boolean isUpdated) {
        if (this.mIsDataChangedVisible) {
            return;
        }
        this.mIsDataChangedVisible = isUpdated;
    }

    @UiThread
    void resetDataChangedIsVisible() {
        this.mIsDataChangedVisible = false;
    }

    @UiThread
    boolean isInsertInVisibleRange(int position, int size, int viewportCount) {
        if (this.shouldForceDataChangedIsVisibleToTrue() || viewportCount == -1) {
            return true;
        }
        int lastPosition = this.mCurrentFirstVisiblePosition + viewportCount - 1 > this.mCurrentLastVisiblePosition ? this.mCurrentFirstVisiblePosition + viewportCount - 1 : this.mCurrentLastVisiblePosition;
        for (int index = position; index < position + size; ++index) {
            if (this.mCurrentFirstVisiblePosition > index || index > lastPosition) continue;
            return true;
        }
        return false;
    }

    @UiThread
    boolean isUpdateInVisibleRange(int position, int size) {
        if (this.shouldForceDataChangedIsVisibleToTrue()) {
            return true;
        }
        for (int index = position; index < position + size; ++index) {
            if (this.mCurrentFirstVisiblePosition > index || index > this.mCurrentLastVisiblePosition) continue;
            return true;
        }
        return false;
    }

    @UiThread
    boolean isMoveInVisibleRange(int fromPosition, int toPosition, int viewportCount) {
        if (this.shouldForceDataChangedIsVisibleToTrue() || viewportCount == -1) {
            return true;
        }
        boolean isNewPositionInVisibleRange = toPosition >= this.mCurrentFirstVisiblePosition && toPosition <= this.mCurrentFirstVisiblePosition + viewportCount - 1;
        boolean isOldPositionInVisibleRange = fromPosition >= this.mCurrentFirstVisiblePosition && fromPosition <= this.mCurrentFirstVisiblePosition + viewportCount - 1;
        return isNewPositionInVisibleRange || isOldPositionInVisibleRange;
    }

    @UiThread
    boolean isRemoveInVisibleRange(int position, int size) {
        if (this.shouldForceDataChangedIsVisibleToTrue()) {
            return true;
        }
        for (int index = position; index < position + size; ++index) {
            if (this.mCurrentFirstVisiblePosition > index || index > this.mCurrentLastVisiblePosition) continue;
            return true;
        }
        return false;
    }

    private boolean shouldForceDataChangedIsVisibleToTrue() {
        return this.mCurrentFirstVisiblePosition < 0 || this.mCurrentLastVisiblePosition < 0 || this.mIsDataChangedVisible;
    }

    private void putViewportChangedRunnableToEndOfUIThreadQueue() {
        this.mMainThreadHandler.removeCallbacks(this.mViewportChangedRunnable);
        this.mMainThreadHandler.post(this.mViewportChangedRunnable);
    }

    @UiThread
    void addViewportChangedListener(@Nullable ViewportInfo.ViewportChanged viewportChangedListener) {
        if (viewportChangedListener == null) {
            return;
        }
        if (this.mViewportChangedListeners == null) {
            this.mViewportChangedListeners = new ArrayList<ViewportInfo.ViewportChanged>(2);
        }
        this.mViewportChangedListeners.add(viewportChangedListener);
    }

    @UiThread
    void removeViewportChangedListener(@Nullable ViewportInfo.ViewportChanged viewportChangedListener) {
        if (viewportChangedListener == null || this.mViewportChangedListeners == null) {
            return;
        }
        this.mViewportChangedListeners.remove(viewportChangedListener);
    }

    @UiThread
    ViewportScrollListener getScrollListener() {
        return this.mViewportScrollListener;
    }

    private boolean isScrolling() {
        return this.mScrollingState != 0;
    }

    private class ViewportScrollListener
    extends RecyclerView.OnScrollListener {
        private ViewportScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            ViewportManager.this.onViewportChanged();
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            ViewportManager.this.mScrollingState = newState;
        }
    }
}

