/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.util.Pools;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.util.Log;
import com.facebook.fbui.textlayoutbuilder.TextLayoutBuilder;
import com.facebook.fbui.textlayoutbuilder.util.LayoutMeasureUtil;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.EventHandler;
import com.facebook.litho.LogEvent;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.annotations.FromMeasure;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.utils.DisplayListUtils;
import com.facebook.litho.widget.GlyphWarmer;
import com.facebook.litho.widget.MountableCharSequence;
import com.facebook.litho.widget.SynchronizedTypefaceHelper;
import com.facebook.litho.widget.Text;
import com.facebook.litho.widget.TextDrawable;
import com.facebook.litho.widget.TextOffsetOnTouchEvent;
import com.facebook.litho.widget.VerticalGravity;
import com.facebook.widget.accessibility.delegates.AccessibleClickableSpan;
import com.facebook.yoga.YogaDirection;

@MountSpec(isPureRender=true, shouldUseDisplayList=true, poolSize=30, events={TextOffsetOnTouchEvent.class})
class TextSpec {
    private static final TextUtils.TruncateAt[] TRUNCATE_AT;
    private static final Typeface DEFAULT_TYPEFACE;
    private static final int DEFAULT_COLOR = 0;
    private static final int DEFAULT_EMS = -1;
    private static final int DEFAULT_MIN_WIDTH = 0;
    private static final int DEFAULT_MAX_WIDTH = Integer.MAX_VALUE;
    private static final int[][] DEFAULT_TEXT_COLOR_STATE_LIST_STATES;
    private static final int[] DEFAULT_TEXT_COLOR_STATE_LIST_COLORS;
    private static final int[] DEFAULT_TEXT_DRAWABLE_STATE;
    private static final String TAG = "TextSpec";
    @PropDefault
    protected static final int minLines = Integer.MIN_VALUE;
    @PropDefault
    protected static final int maxLines = Integer.MAX_VALUE;
    @PropDefault
    protected static final int minEms = -1;
    @PropDefault
    protected static final int maxEms = -1;
    @PropDefault
    protected static final int minTextWidth = 0;
    @PropDefault
    protected static final int maxTextWidth = Integer.MAX_VALUE;
    @PropDefault
    protected static final int shadowColor = -7829368;
    @PropDefault
    protected static final int textColor = 0;
    @PropDefault
    protected static final int linkColor = 0;
    @PropDefault
    protected static final ColorStateList textColorStateList;
    @PropDefault
    protected static final int textSize = 13;
    @PropDefault
    protected static final int textStyle;
    @PropDefault
    protected static final Typeface typeface;
    @PropDefault
    protected static final float spacingMultiplier = 1.0f;
    @PropDefault
    protected static final VerticalGravity verticalGravity;
    @PropDefault
    protected static final boolean glyphWarming = false;
    @PropDefault
    protected static final boolean shouldIncludeFontPadding = true;
    @PropDefault
    protected static final Layout.Alignment textAlignment;
    @PropDefault
    protected static final int highlightStartOffset = -1;
    @PropDefault
    protected static final int highlightEndOffset = -1;
    private static final Path sTempPath;
    private static final Rect sTempRect;
    private static final RectF sTempRectF;
    private static final Pools.SynchronizedPool<TextLayoutBuilder> sTextLayoutBuilderPool;

    TextSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<TextUtils.TruncateAt> ellipsize, Output<Boolean> shouldIncludeFontPadding, Output<Float> spacingMultiplier, Output<Integer> minLines, Output<Integer> maxLines, Output<Integer> minEms, Output<Integer> maxEms, Output<Integer> minTextWidth, Output<Integer> maxTextWidth, Output<Boolean> isSingleLine, Output<CharSequence> text, Output<ColorStateList> textColorStateList, Output<Integer> linkColor, Output<Integer> highlightColor, Output<Integer> textSize, Output<Layout.Alignment> textAlignment, Output<Integer> textStyle, Output<Float> shadowRadius, Output<Float> shadowDx, Output<Float> shadowDy, Output<Integer> shadowColor, Output<VerticalGravity> verticalGravity, Output<Typeface> typeface) {
        TypedArray a = c.obtainStyledAttributes(R.styleable.Text_TextAppearanceAttr, 0);
        int textAppearanceResId = a.getResourceId(R.styleable.Text_TextAppearanceAttr_android_textAppearance, -1);
        a.recycle();
        if (textAppearanceResId != -1) {
            a = c.getTheme().obtainStyledAttributes(textAppearanceResId, R.styleable.Text);
            TextSpec.resolveStyleAttrsForTypedArray(a, ellipsize, shouldIncludeFontPadding, spacingMultiplier, minLines, maxLines, minEms, maxEms, minTextWidth, maxTextWidth, isSingleLine, text, textColorStateList, linkColor, highlightColor, textSize, textAlignment, textStyle, shadowRadius, shadowDx, shadowDy, shadowColor, verticalGravity, typeface);
            a.recycle();
        }
        a = c.obtainStyledAttributes(R.styleable.Text, 0);
        TextSpec.resolveStyleAttrsForTypedArray(a, ellipsize, shouldIncludeFontPadding, spacingMultiplier, minLines, maxLines, minEms, maxEms, minTextWidth, maxTextWidth, isSingleLine, text, textColorStateList, linkColor, highlightColor, textSize, textAlignment, textStyle, shadowRadius, shadowDx, shadowDy, shadowColor, verticalGravity, typeface);
        a.recycle();
    }

    private static void resolveStyleAttrsForTypedArray(TypedArray a, Output<TextUtils.TruncateAt> ellipsize, Output<Boolean> shouldIncludeFontPadding, Output<Float> spacingMultiplier, Output<Integer> minLines, Output<Integer> maxLines, Output<Integer> minEms, Output<Integer> maxEms, Output<Integer> minTextWidth, Output<Integer> maxTextWidth, Output<Boolean> isSingleLine, Output<CharSequence> text, Output<ColorStateList> textColorStateList, Output<Integer> linkColor, Output<Integer> highlightColor, Output<Integer> textSize, Output<Layout.Alignment> textAlignment, Output<Integer> textStyle, Output<Float> shadowRadius, Output<Float> shadowDx, Output<Float> shadowDy, Output<Integer> shadowColor, Output<VerticalGravity> verticalGravity, Output<Typeface> typeface) {
        int viewTextAlignment = 1;
        int gravity = 0;
        String fontFamily = null;
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.Text_android_text) {
                text.set((Object)a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColor) {
                textColorStateList.set((Object)a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textSize) {
                textSize.set((Object)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_ellipsize) {
                int index = a.getInteger(attr2, 0);
                if (index <= 0) continue;
                ellipsize.set((Object)TRUNCATE_AT[index - 1]);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 17 && attr2 == R.styleable.Text_android_textAlignment) {
                viewTextAlignment = a.getInt(attr2, -1);
                textAlignment.set((Object)TextSpec.getAlignment(viewTextAlignment, gravity));
                continue;
            }
            if (attr2 == R.styleable.Text_android_gravity) {
                gravity = a.getInt(attr2, -1);
                textAlignment.set((Object)TextSpec.getAlignment(viewTextAlignment, gravity));
                verticalGravity.set((Object)TextSpec.getVerticalGravity(gravity));
                continue;
            }
            if (attr2 == R.styleable.Text_android_includeFontPadding) {
                shouldIncludeFontPadding.set((Object)a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.Text_android_minLines) {
                minLines.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_maxLines) {
                maxLines.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_singleLine) {
                isSingleLine.set((Object)a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColorLink) {
                linkColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColorHighlight) {
                highlightColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textStyle) {
                textStyle.set((Object)a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_lineSpacingMultiplier) {
                spacingMultiplier.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowDx) {
                shadowDx.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowDy) {
                shadowDy.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowRadius) {
                shadowRadius.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowColor) {
                shadowColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_minEms) {
                minEms.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_maxEms) {
                maxEms.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_minWidth) {
                minTextWidth.set((Object)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_maxWidth) {
                maxTextWidth.set((Object)a.getDimensionPixelSize(attr2, Integer.MAX_VALUE));
                continue;
            }
            if (attr2 != R.styleable.Text_android_fontFamily) continue;
            fontFamily = a.getString(attr2);
        }
        if (fontFamily != null) {
            Integer n = (Integer)textStyle.get();
        }
    }

    static void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size, @Prop(resType=ResType.STRING) CharSequence text, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.BOOL) boolean shouldIncludeFontPadding, @Prop(optional=true, resType=ResType.INT) int minLines, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int minEms, @Prop(optional=true, resType=ResType.INT) int maxEms, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int minTextWidth, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int maxTextWidth, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true) int textStyle, @Prop(optional=true) Typeface typeface, @Prop(optional=true) Layout.Alignment textAlignment, @Prop(optional=true) boolean glyphWarming, @Prop(optional=true) TextDirectionHeuristicCompat textDirection, Output<Layout> measureLayout, Output<Integer> measuredWidth, Output<Integer> measuredHeight) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            measureLayout.set(null);
            size.width = 0;
            size.height = 0;
            return;
        }
        Layout newLayout = TextSpec.createTextLayout(widthSpec, ellipsize, shouldIncludeFontPadding, maxLines, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, text, textColor, textColorStateList, linkColor, textSize, extraSpacing, spacingMultiplier, textStyle, typeface, textAlignment, glyphWarming, layout.getResolvedLayoutDirection(), minEms, maxEms, minTextWidth, maxTextWidth, textDirection);
        measureLayout.set((Object)newLayout);
        size.width = SizeSpec.resolveSize((int)widthSpec, (int)newLayout.getWidth());
        int preferredHeight = LayoutMeasureUtil.getHeight((Layout)newLayout);
        int lineCount = newLayout.getLineCount();
        if (lineCount < minLines) {
            TextPaint paint = newLayout.getPaint();
            int lineHeight = Math.round((float)paint.getFontMetricsInt(null) * spacingMultiplier + extraSpacing);
            preferredHeight += lineHeight * (minLines - lineCount);
        }
        size.height = SizeSpec.resolveSize((int)heightSpec, (int)preferredHeight);
        if (size.width < 0 || size.height < 0) {
            size.width = Math.max(size.width, 0);
            size.height = Math.max(size.height, 0);
            ComponentsLogger logger = context.getLogger();
            if (logger != null) {
                LogEvent event = logger.newEvent(11);
                event.addParam("message", (Object)"Text layout measured to less than 0 pixels");
                logger.log(event);
            }
        }
        measuredWidth.set((Object)size.width);
        measuredHeight.set((Object)size.height);
    }

    private static Layout createTextLayout(int widthSpec, TextUtils.TruncateAt ellipsize, boolean shouldIncludeFontPadding, int maxLines, float shadowRadius, float shadowDx, float shadowDy, int shadowColor, boolean isSingleLine, CharSequence text, int textColor, ColorStateList textColorStateList, int linkColor, int textSize, float extraSpacing, float spacingMultiplier, int textStyle, Typeface typeface, Layout.Alignment textAlignment, boolean glyphWarming, YogaDirection layoutDirection, int minEms, int maxEms, int minTextWidth, int maxTextWidth, TextDirectionHeuristicCompat textDirection) {
        int textMeasureMode;
        TextLayoutBuilder layoutBuilder = (TextLayoutBuilder)sTextLayoutBuilderPool.acquire();
        if (layoutBuilder == null) {
            layoutBuilder = new TextLayoutBuilder();
            layoutBuilder.setShouldCacheLayout(false);
        }
        switch (SizeSpec.getMode((int)widthSpec)) {
            case 0: {
                textMeasureMode = 0;
                break;
            }
            case 0x40000000: {
                textMeasureMode = 1;
                break;
            }
            case -2147483648: {
                textMeasureMode = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected size mode: " + SizeSpec.getMode((int)widthSpec));
            }
        }
        layoutBuilder.setEllipsize(ellipsize).setMaxLines(maxLines).setShadowLayer(shadowRadius, shadowDx, shadowDy, shadowColor).setSingleLine(isSingleLine).setText(text).setTextSize(textSize).setWidth(SizeSpec.getSize((int)widthSpec), textMeasureMode);
        if (minEms != -1) {
            layoutBuilder.setMinEms(minEms);
        } else {
            layoutBuilder.setMinWidth(minTextWidth);
        }
        if (maxEms != -1) {
            layoutBuilder.setMaxEms(maxEms);
        } else {
            layoutBuilder.setMaxWidth(maxTextWidth);
        }
        if (textColor != 0) {
            layoutBuilder.setTextColor(textColor);
        } else {
            layoutBuilder.setTextColor(textColorStateList);
        }
        if (typeface != DEFAULT_TYPEFACE) {
            layoutBuilder.setTypeface(typeface);
        } else {
            layoutBuilder.setTextStyle(textStyle);
        }
        if (textDirection != null) {
            layoutBuilder.setTextDirection(textDirection);
        } else {
            layoutBuilder.setTextDirection(layoutDirection == YogaDirection.RTL ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR);
        }
        layoutBuilder.setIncludeFontPadding(shouldIncludeFontPadding);
        layoutBuilder.setTextSpacingExtra(extraSpacing);
        layoutBuilder.setTextSpacingMultiplier(spacingMultiplier);
        layoutBuilder.setAlignment(textAlignment);
        layoutBuilder.setLinkColor(linkColor);
        Layout newLayout = layoutBuilder.build();
        layoutBuilder.setText(null);
        sTextLayoutBuilderPool.release((Object)layoutBuilder);
        if (glyphWarming && !DisplayListUtils.isEligibleForCreatingDisplayLists()) {
            GlyphWarmer.getInstance().warmLayout(newLayout);
        }
        return newLayout;
    }

    private static Layout.Alignment getAlignment(int viewTextAlignment, int gravity) {
        Layout.Alignment alignment;
        switch (viewTextAlignment) {
            case 1: {
                alignment = TextSpec.getAlignment(gravity);
                break;
            }
            case 2: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 4: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 5: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 6: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 0: {
                alignment = TextSpec.getAlignment(gravity);
                break;
            }
            default: {
                alignment = textAlignment;
            }
        }
        return alignment;
    }

    private static Layout.Alignment getAlignment(int gravity) {
        Layout.Alignment alignment;
        switch (gravity & 0x800007) {
            case 0x800003: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 0x800005: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 5: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 1: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            default: {
                alignment = textAlignment;
            }
        }
        return alignment;
    }

    private static VerticalGravity getVerticalGravity(int gravity) {
        VerticalGravity verticalGravity;
        switch (gravity & 0x70) {
            case 48: {
                verticalGravity = VerticalGravity.TOP;
                break;
            }
            case 16: {
                verticalGravity = VerticalGravity.CENTER;
                break;
            }
            case 80: {
                verticalGravity = VerticalGravity.BOTTOM;
                break;
            }
            default: {
                verticalGravity = TextSpec.verticalGravity;
            }
        }
        return verticalGravity;
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext c, ComponentLayout layout, @Prop(resType=ResType.STRING) CharSequence text, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.BOOL) boolean shouldIncludeFontPadding, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int minEms, @Prop(optional=true, resType=ResType.INT) int maxEms, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int minTextWidth, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int maxTextWidth, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true) VerticalGravity verticalGravity, @Prop(optional=true) int textStyle, @Prop(optional=true) Typeface typeface, @Prop(optional=true) Layout.Alignment textAlignment, @Prop(optional=true) boolean glyphWarming, @Prop(optional=true) TextDirectionHeuristicCompat textDirection, @FromMeasure Layout measureLayout, @FromMeasure Integer measuredWidth, @FromMeasure Integer measuredHeight, Output<Layout> textLayout, Output<Float> textLayoutTranslationY, Output<ClickableSpan[]> clickableSpans, Output<ImageSpan[]> imageSpans) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        float layoutWidth = layout.getWidth() - layout.getPaddingLeft() - layout.getPaddingRight();
        float layoutHeight = layout.getHeight() - layout.getPaddingTop() - layout.getPaddingBottom();
        if (measureLayout != null && (float)measuredWidth.intValue() == layoutWidth && (float)measuredHeight.intValue() == layoutHeight) {
            textLayout.set((Object)measureLayout);
        } else {
            if (measureLayout != null) {
                Log.w((String)TAG, (String)"Remeasuring Text component.  This is expensive: consider changing parent layout so that double measurement is not necessary.");
            }
            textLayout.set((Object)TextSpec.createTextLayout(SizeSpec.makeSizeSpec((int)((int)layoutWidth), (int)0x40000000), ellipsize, shouldIncludeFontPadding, maxLines, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, text, textColor, textColorStateList, linkColor, textSize, extraSpacing, spacingMultiplier, textStyle, typeface, textAlignment, glyphWarming, layout.getResolvedLayoutDirection(), minEms, maxEms, minTextWidth, maxTextWidth, textDirection));
        }
        float textHeight = LayoutMeasureUtil.getHeight((Layout)((Layout)textLayout.get()));
        switch (verticalGravity) {
            case CENTER: {
                textLayoutTranslationY.set((Object)Float.valueOf((layoutHeight - textHeight) / 2.0f));
                break;
            }
            case BOTTOM: {
                textLayoutTranslationY.set((Object)Float.valueOf(layoutHeight - textHeight));
                break;
            }
            default: {
                textLayoutTranslationY.set((Object)Float.valueOf(0.0f));
            }
        }
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            clickableSpans.set((Object)spanned.getSpans(0, text.length(), ClickableSpan.class));
            imageSpans.set((Object)spanned.getSpans(0, text.length(), ImageSpan.class));
        }
    }

    static TextDrawable onCreateMountContent(ComponentContext c) {
        return new TextDrawable();
    }

    @OnMount
    static void onMount(ComponentContext c, TextDrawable textDrawable, final @Prop(resType=ResType.STRING) CharSequence text, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true, resType=ResType.COLOR) int highlightColor, @Prop(optional=true) ColorStateList textColorStateList, final @Prop(optional=true) EventHandler textOffsetOnTouchHandler, @Prop(optional=true) int highlightStartOffset, @Prop(optional=true) int highlightEndOffset, Layout textLayout, Float textLayoutTranslationY, ClickableSpan[] clickableSpans, ImageSpan[] imageSpans) {
        textDrawable.setState(DEFAULT_TEXT_DRAWABLE_STATE);
        TextDrawable.TextOffsetOnTouchListener textOffsetOnTouchListener = null;
        if (textOffsetOnTouchHandler != null) {
            textOffsetOnTouchListener = new TextDrawable.TextOffsetOnTouchListener(){

                @Override
                public void textOffsetOnTouch(int textOffset) {
                    Text.dispatchTextOffsetOnTouchEvent(textOffsetOnTouchHandler, text, textOffset);
                }
            };
        }
        textDrawable.mount(text, textLayout, textLayoutTranslationY == null ? 0.0f : textLayoutTranslationY.floatValue(), textColorStateList, textColor, highlightColor, clickableSpans, imageSpans, textOffsetOnTouchListener, highlightStartOffset, highlightEndOffset);
        if (text instanceof MountableCharSequence) {
            ((MountableCharSequence)text).onMount(textDrawable);
        }
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, TextDrawable textDrawable, @Prop(resType=ResType.STRING) CharSequence text) {
        textDrawable.unmount();
        if (text instanceof MountableCharSequence) {
            ((MountableCharSequence)text).onUnmount(textDrawable);
        }
    }

    static void onPopulateAccessibilityNode(AccessibilityNodeInfoCompat node, @Prop(resType=ResType.STRING) CharSequence text) {
        node.setText(text);
    }

    static int getExtraAccessibilityNodesCount(@Prop(optional=true, resType=ResType.BOOL) boolean accessibleClickableSpans, ClickableSpan[] clickableSpans) {
        return accessibleClickableSpans && clickableSpans != null ? clickableSpans.length : 0;
    }

    static void onPopulateExtraAccessibilityNode(AccessibilityNodeInfoCompat node, int extraNodeIndex, int componentBoundsLeft, int componentBoundsTop, @Prop(resType=ResType.STRING) CharSequence text, Layout textLayout, ClickableSpan[] clickableSpans) {
        int endLine;
        Spanned spanned = (Spanned)text;
        ClickableSpan span = clickableSpans[extraNodeIndex];
        int start = spanned.getSpanStart((Object)span);
        int end = spanned.getSpanEnd((Object)span);
        int startLine = textLayout.getLineForOffset(start);
        int selectionPathEnd = startLine == (endLine = textLayout.getLineForOffset(end)) ? end : textLayout.getLineVisibleEnd(startLine);
        textLayout.getSelectionPath(start, selectionPathEnd, sTempPath);
        sTempPath.computeBounds(sTempRectF, true);
        sTempRect.set(componentBoundsLeft + (int)TextSpec.sTempRectF.left, componentBoundsTop + (int)TextSpec.sTempRectF.top, componentBoundsLeft + (int)TextSpec.sTempRectF.right, componentBoundsTop + (int)TextSpec.sTempRectF.bottom);
        if (sTempRect.isEmpty()) {
            sTempRect.set(0, 0, 1, 1);
            node.setBoundsInParent(sTempRect);
            node.setContentDescription((CharSequence)"");
            return;
        }
        node.setBoundsInParent(sTempRect);
        node.setClickable(true);
        node.setFocusable(true);
        node.setEnabled(true);
        node.setVisibleToUser(true);
        if (span instanceof AccessibleClickableSpan) {
            node.setText((CharSequence)((AccessibleClickableSpan)span).getAccessibilityDescription());
        } else {
            node.setText(spanned.subSequence(start, end));
        }
    }

    static int getExtraAccessibilityNodeAt(int x, int y, @Prop(resType=ResType.STRING) CharSequence text, Layout textLayout, ClickableSpan[] clickableSpans) {
        Spanned spanned = (Spanned)text;
        for (int i = 0; i < clickableSpans.length; ++i) {
            ClickableSpan span = clickableSpans[i];
            int start = spanned.getSpanStart((Object)span);
            int end = spanned.getSpanEnd((Object)span);
            textLayout.getSelectionPath(start, end, sTempPath);
            sTempPath.computeBounds(sTempRectF, true);
            if (!sTempRectF.contains((float)x, (float)y)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    static {
        SynchronizedTypefaceHelper.setupSynchronizedTypeface();
        TRUNCATE_AT = TextUtils.TruncateAt.values();
        DEFAULT_TYPEFACE = Typeface.DEFAULT;
        DEFAULT_TEXT_COLOR_STATE_LIST_STATES = new int[][]{{0}};
        DEFAULT_TEXT_COLOR_STATE_LIST_COLORS = new int[]{-16777216};
        DEFAULT_TEXT_DRAWABLE_STATE = new int[]{16842910};
        textColorStateList = new ColorStateList(DEFAULT_TEXT_COLOR_STATE_LIST_STATES, DEFAULT_TEXT_COLOR_STATE_LIST_COLORS);
        textStyle = DEFAULT_TYPEFACE.getStyle();
        typeface = DEFAULT_TYPEFACE;
        verticalGravity = VerticalGravity.TOP;
        textAlignment = Layout.Alignment.ALIGN_NORMAL;
        sTempPath = new Path();
        sTempRect = new Rect();
        sTempRectF = new RectF();
        sTextLayoutBuilderPool = new Pools.SynchronizedPool(2);
    }
}

