/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.fbui.textlayoutbuilder.util.LayoutMeasureUtil;
import com.facebook.litho.TextContent;
import com.facebook.litho.Touchable;
import com.facebook.litho.widget.TextSpec;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class TextDrawable
extends Drawable
implements Touchable,
TextContent,
Drawable.Callback {
    private static final float DEFAULT_TOUCH_RADIUS_IN_SP = 18.0f;
    private Layout mLayout;
    private float mLayoutTranslationY;
    private boolean mShouldHandleTouch;
    private CharSequence mText;
    private ColorStateList mColorStateList;
    private int mUserColor;
    private int mHighlightColor;
    private ClickableSpan[] mClickableSpans;
    private ImageSpan[] mImageSpans;
    private int mSelectionStart;
    private int mSelectionEnd;
    private Path mSelectionPath;
    private Path mTouchAreaPath;
    private boolean mSelectionPathNeedsUpdate;
    private Paint mHighlightPaint;
    private TextOffsetOnTouchListener mTextOffsetOnTouchListener;

    public void draw(Canvas canvas) {
        if (this.mLayout == null) {
            return;
        }
        Rect bounds = this.getBounds();
        canvas.translate((float)bounds.left, (float)bounds.top + this.mLayoutTranslationY);
        this.mLayout.draw(canvas, this.getSelectionPath(), this.mHighlightPaint, 0);
        canvas.translate((float)(-bounds.left), (float)(-bounds.top) - this.mLayoutTranslationY);
    }

    public boolean isStateful() {
        return this.mColorStateList != null;
    }

    protected boolean onStateChange(int[] states) {
        if (this.mColorStateList != null && this.mLayout != null) {
            int previousColor = this.mLayout.getPaint().getColor();
            int currentColor = this.mColorStateList.getColorForState(states, this.mUserColor);
            if (currentColor != previousColor) {
                this.mLayout.getPaint().setColor(currentColor);
                this.invalidateSelf();
            }
        }
        return super.onStateChange(states);
    }

    public boolean onTouchEvent(MotionEvent event, View view) {
        if (this.shouldHandleTouchForClickableSpan(event) && this.handleTouchForClickableSpan(event, view)) {
            return true;
        }
        if (this.shouldHandleTextOffsetOnTouch(event)) {
            this.handleTextOffsetChange(event);
        }
        return false;
    }

    private boolean handleTouchForClickableSpan(MotionEvent event, View view) {
        int action = event.getActionMasked();
        if (action == 3) {
            this.clearSelection();
            return false;
        }
        Rect bounds = this.getBounds();
        int x = (int)event.getX() - bounds.left;
        int y = (int)event.getY() - bounds.top;
        float touchRadius = TypedValue.applyDimension((int)2, (float)18.0f, (DisplayMetrics)view.getResources().getDisplayMetrics());
        ClickableSpan clickedSpan = this.getClickableSpanInCoords(x, y);
        if (clickedSpan == null) {
            clickedSpan = this.getClickableSpanInProximityToClick(x, y, touchRadius);
        }
        if (clickedSpan != null) {
            if (action == 1) {
                this.clearSelection();
                clickedSpan.onClick(view);
            } else if (action == 0) {
                this.setSelection(clickedSpan);
            }
            return true;
        }
        this.clearSelection();
        return false;
    }

    private void handleTextOffsetChange(MotionEvent event) {
        int y;
        Rect bounds = this.getBounds();
        int x = (int)event.getX() - bounds.left;
        int offset = this.getTextOffsetAt(x, y = (int)event.getY() - bounds.top);
        if (offset >= 0 && offset <= this.mText.length()) {
            this.mTextOffsetOnTouchListener.textOffsetOnTouch(offset);
        }
    }

    public boolean shouldHandleTouchEvent(MotionEvent event) {
        return this.shouldHandleTouchForClickableSpan(event) || this.shouldHandleTextOffsetOnTouch(event);
    }

    private boolean shouldHandleTouchForClickableSpan(MotionEvent event) {
        int action = event.getActionMasked();
        boolean isWithinBounds = this.getBounds().contains((int)event.getX(), (int)event.getY());
        boolean isUpOrDown = action == 1 || action == 0;
        return this.mShouldHandleTouch && isWithinBounds && isUpOrDown || action == 3;
    }

    private boolean shouldHandleTextOffsetOnTouch(MotionEvent event) {
        return this.mTextOffsetOnTouchListener != null && event.getActionMasked() == 0 && this.getBounds().contains((int)event.getX(), (int)event.getY());
    }

    public void mount(CharSequence text, Layout layout, int userColor, ClickableSpan[] clickableSpans) {
        this.mount(text, layout, 0.0f, null, userColor, 0, clickableSpans, null, null, -1, -1);
    }

    public void mount(CharSequence text, Layout layout, int userColor, int highlightColor) {
        this.mount(text, layout, 0.0f, null, userColor, highlightColor, null, null, null, -1, -1);
    }

    public void mount(CharSequence text, Layout layout, float layoutTranslationY, ColorStateList colorStateList, int userColor, int highlightColor, ClickableSpan[] clickableSpans) {
        this.mount(text, layout, 0.0f, null, userColor, highlightColor, clickableSpans, null, null, -1, -1);
    }

    public void mount(CharSequence text, Layout layout, float layoutTranslationY, ColorStateList colorStateList, int userColor, int highlightColor, ClickableSpan[] clickableSpans, ImageSpan[] imageSpans, TextOffsetOnTouchListener textOffsetOnTouchListener, int highlightStartOffset, int highlightEndOffset) {
        this.mLayout = layout;
        this.mLayoutTranslationY = layoutTranslationY;
        this.mText = text;
        this.mClickableSpans = clickableSpans;
        this.mTextOffsetOnTouchListener = textOffsetOnTouchListener;
        this.mShouldHandleTouch = clickableSpans != null && clickableSpans.length > 0;
        this.mHighlightColor = highlightColor;
        if (userColor != 0) {
            this.mColorStateList = null;
            this.mUserColor = userColor;
        } else {
            this.mColorStateList = colorStateList != null ? colorStateList : TextSpec.textColorStateList;
            this.mUserColor = this.mColorStateList.getDefaultColor();
            if (this.mLayout != null) {
                this.mLayout.getPaint().setColor(this.mColorStateList.getColorForState(this.getState(), this.mUserColor));
            }
        }
        if (this.highlightOffsetsValid(text, highlightStartOffset, highlightEndOffset)) {
            this.setSelection(highlightStartOffset, highlightEndOffset);
        } else {
            this.clearSelection();
        }
        if (imageSpans != null) {
            int size = imageSpans.length;
            for (int i = 0; i < size; ++i) {
                Drawable drawable = imageSpans[i].getDrawable();
                drawable.setCallback((Drawable.Callback)this);
                drawable.setVisible(true, false);
            }
        }
        this.mImageSpans = imageSpans;
        this.invalidateSelf();
    }

    private boolean highlightOffsetsValid(CharSequence text, int highlightStart, int highlightEnd) {
        return highlightStart >= 0 && highlightEnd <= text.length() && highlightStart < highlightEnd;
    }

    public void unmount() {
        this.mLayout = null;
        this.mLayoutTranslationY = 0.0f;
        this.mText = null;
        this.mClickableSpans = null;
        this.mShouldHandleTouch = false;
        this.mHighlightColor = 0;
        this.mTextOffsetOnTouchListener = null;
        this.mColorStateList = null;
        this.mUserColor = 0;
        if (this.mImageSpans != null) {
            int size = this.mImageSpans.length;
            for (int i = 0; i < size; ++i) {
                Drawable drawable = this.mImageSpans[i].getDrawable();
                drawable.setCallback(null);
                drawable.setVisible(false, false);
            }
            this.mImageSpans = null;
        }
    }

    public ClickableSpan[] getClickableSpans() {
        return this.mClickableSpans;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return 0;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public int getColor() {
        return this.mLayout.getPaint().getColor();
    }

    public List<CharSequence> getTextItems() {
        return this.mText != null ? Collections.singletonList(this.mText) : Collections.emptyList();
    }

    @Nullable
    private ClickableSpan getClickableSpanInCoords(int x, int y) {
        int offset = this.getTextOffsetAt(x, y);
        if (offset < 0) {
            return null;
        }
        ClickableSpan[] clickableSpans = (ClickableSpan[])((Spanned)this.mText).getSpans(offset, offset, ClickableSpan.class);
        if (clickableSpans != null && clickableSpans.length > 0) {
            return clickableSpans[0];
        }
        return null;
    }

    private int getTextOffsetAt(int x, int y) {
        float end;
        int line = this.mLayout.getLineForVertical(y);
        float start = this.mLayout.getPrimaryHorizontal(this.mLayout.getLineStart(line));
        if (start > (end = this.mLayout.getPrimaryHorizontal(this.mLayout.getLineVisibleEnd(line)))) {
            float temp = start;
            start = end;
            end = temp;
        }
        if ((float)x < start || (float)x > end) {
            return -1;
        }
        return this.mLayout.getOffsetForHorizontal(line, (float)x);
    }

    @Nullable
    private ClickableSpan getClickableSpanInProximityToClick(float x, float y, float tapRadius) {
        Region touchAreaRegion = new Region();
        Region clipBoundsRegion = new Region();
        if (this.mTouchAreaPath == null) {
            this.mTouchAreaPath = new Path();
        }
        clipBoundsRegion.set(0, 0, LayoutMeasureUtil.getWidth((Layout)this.mLayout), LayoutMeasureUtil.getHeight((Layout)this.mLayout));
        this.mTouchAreaPath.reset();
        this.mTouchAreaPath.addCircle(x, y, tapRadius, Path.Direction.CW);
        touchAreaRegion.setPath(this.mTouchAreaPath, clipBoundsRegion);
        ClickableSpan result = null;
        for (ClickableSpan span : this.mClickableSpans) {
            if (!this.isClickCloseToSpan(span, (Spanned)this.mText, this.mLayout, touchAreaRegion, clipBoundsRegion)) continue;
            if (result != null) {
                return null;
            }
            result = span;
        }
        return result;
    }

    private Path getSelectionPath() {
        if (this.mSelectionStart == this.mSelectionEnd) {
            return null;
        }
        if (Color.alpha((int)this.mHighlightColor) == 0) {
            return null;
        }
        if (this.mSelectionPathNeedsUpdate) {
            if (this.mSelectionPath == null) {
                this.mSelectionPath = new Path();
            }
            this.mLayout.getSelectionPath(this.mSelectionStart, this.mSelectionEnd, this.mSelectionPath);
            this.mSelectionPathNeedsUpdate = false;
        }
        return this.mSelectionPath;
    }

    private void setSelection(ClickableSpan span) {
        Spanned text = (Spanned)this.mText;
        this.setSelection(text.getSpanStart((Object)span), text.getSpanEnd((Object)span));
    }

    private void setSelection(int selectionStart, int selectionEnd) {
        if (Color.alpha((int)this.mHighlightColor) == 0 || this.mSelectionStart == selectionStart && this.mSelectionEnd == selectionEnd) {
            return;
        }
        this.mSelectionStart = selectionStart;
        this.mSelectionEnd = selectionEnd;
        if (this.mHighlightPaint == null) {
            this.mHighlightPaint = new Paint();
            this.mHighlightPaint.setColor(this.mHighlightColor);
        } else {
            this.mHighlightPaint.setColor(this.mHighlightColor);
        }
        this.mSelectionPathNeedsUpdate = true;
        this.invalidateSelf();
    }

    private void clearSelection() {
        this.setSelection(0, 0);
    }

    private boolean isClickCloseToSpan(ClickableSpan span, Spanned buffer, Layout layout, Region touchAreaRegion, Region clipBoundsRegion) {
        Region clickableSpanAreaRegion = new Region();
        Path clickableSpanAreaPath = new Path();
        layout.getSelectionPath(buffer.getSpanStart((Object)span), buffer.getSpanEnd((Object)span), clickableSpanAreaPath);
        clickableSpanAreaRegion.setPath(clickableSpanAreaPath, clipBoundsRegion);
        return clickableSpanAreaRegion.op(touchAreaRegion, Region.Op.INTERSECT);
    }

    public void invalidateDrawable(Drawable drawable) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable drawable, Runnable runnable, long l) {
        this.scheduleSelf(runnable, l);
    }

    public void unscheduleDrawable(Drawable drawable, Runnable runnable) {
        this.unscheduleSelf(runnable);
    }

    static interface TextOffsetOnTouchListener {
        public void textOffsetOnTouch(int var1);
    }
}

