/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.util.Pools;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.SolidColorSpec;
import java.util.BitSet;

public final class SolidColor
extends ComponentLifecycle {
    private static SolidColor sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private SolidColor() {
    }

    private static synchronized SolidColor get() {
        if (sInstance == null) {
            sInstance = new SolidColor();
        }
        return sInstance;
    }

    protected ComponentLayout onCreateLayout(ComponentContext c, Component _abstractImpl) {
        SolidColorImpl _impl = (SolidColorImpl)_abstractImpl;
        ComponentLayout _result = SolidColorSpec.onCreateLayout(c, _impl.color);
        return _result;
    }

    public static Builder create(ComponentContext context) {
        return SolidColor.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new SolidColorImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<SolidColor, Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"color"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        SolidColorImpl mSolidColorImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, SolidColorImpl solidColorImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)solidColorImpl);
            this.mSolidColorImpl = solidColorImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder color(@ColorInt int color) {
            this.mSolidColorImpl.color = color;
            this.mRequired.set(0);
            return this;
        }

        public Builder colorRes(@ColorRes int resId) {
            this.mSolidColorImpl.color = this.resolveColorRes(resId);
            this.mRequired.set(0);
            return this;
        }

        public Builder colorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mSolidColorImpl.color = this.resolveColorAttr(attrResId, defResId);
            this.mRequired.set(0);
            return this;
        }

        public Builder colorAttr(@AttrRes int attrResId) {
            this.mSolidColorImpl.color = this.resolveColorAttr(attrResId, 0);
            this.mRequired.set(0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<SolidColor> build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])REQUIRED_PROPS_NAMES);
            SolidColorImpl solidColorImpl = this.mSolidColorImpl;
            this.release();
            return solidColorImpl;
        }

        protected void release() {
            super.release();
            this.mSolidColorImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class SolidColorImpl
    extends Component<SolidColor>
    implements Cloneable {
        @Prop(resType=ResType.COLOR, optional=false)
        int color;

        private SolidColorImpl() {
            super((ComponentLifecycle)SolidColor.get());
        }

        public String getSimpleName() {
            return "SolidColor";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SolidColorImpl solidColorImpl = (SolidColorImpl)other;
            if (this.getId() == solidColorImpl.getId()) {
                return true;
            }
            return this.color == solidColorImpl.color;
        }
    }
}

