/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.v4.util.SimpleArrayMap;
import com.facebook.litho.Component;
import com.facebook.litho.viewcompat.ViewBinder;
import com.facebook.litho.viewcompat.ViewCreator;
import javax.annotation.Nullable;

public abstract class RenderInfo {
    public static final String CLIP_CHILDREN = "clip_children";
    private static final String IS_STICKY = "is_sticky";
    private static final String SPAN_SIZE = "span_size";
    @Nullable
    private final SimpleArrayMap<String, Object> mCustomAttributes;

    RenderInfo(Builder builder) {
        this.mCustomAttributes = builder.mCustomAttributes;
    }

    public boolean isSticky() {
        if (this.mCustomAttributes == null || !this.mCustomAttributes.containsKey((Object)IS_STICKY)) {
            return false;
        }
        return (Boolean)this.mCustomAttributes.get((Object)IS_STICKY);
    }

    public int getSpanSize() {
        if (this.mCustomAttributes == null || !this.mCustomAttributes.containsKey((Object)SPAN_SIZE)) {
            return 1;
        }
        return (Integer)this.mCustomAttributes.get((Object)SPAN_SIZE);
    }

    @Nullable
    public Object getCustomAttribute(String key) {
        return this.mCustomAttributes == null ? null : this.mCustomAttributes.get((Object)key);
    }

    public boolean rendersComponent() {
        return false;
    }

    public Component getComponent() {
        throw new UnsupportedOperationException();
    }

    public boolean rendersView() {
        return false;
    }

    public ViewBinder getViewBinder() {
        throw new UnsupportedOperationException();
    }

    public ViewCreator getViewCreator() {
        throw new UnsupportedOperationException();
    }

    public int getViewType() {
        throw new UnsupportedOperationException();
    }

    public void setViewType(int viewType) {
        throw new UnsupportedOperationException();
    }

    public abstract String getName();

    public static abstract class Builder<T> {
        @Nullable
        private SimpleArrayMap<String, Object> mCustomAttributes;

        public T isSticky(boolean isSticky) {
            return this.customAttribute(RenderInfo.IS_STICKY, isSticky);
        }

        public T spanSize(int spanSize) {
            return this.customAttribute(RenderInfo.SPAN_SIZE, spanSize);
        }

        public T customAttribute(String key, Object value) {
            if (this.mCustomAttributes == null) {
                this.mCustomAttributes = new SimpleArrayMap();
            }
            this.mCustomAttributes.put((Object)key, value);
            return (T)this;
        }

        void release() {
            this.mCustomAttributes = null;
        }
    }
}

