/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.LithoView;
import java.util.List;

public class RecyclerViewWrapper
extends SwipeRefreshLayout
implements HasLithoViewChildren {
    private final LithoView mStickyHeader;
    private final RecyclerView mRecyclerView;
    private boolean mHasBeenDetachedFromWindow = false;

    public RecyclerViewWrapper(Context context, RecyclerView recyclerView) {
        super(context);
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.setChildDrawingOrderCallback(new RecyclerView.ChildDrawingOrderCallback(){

            public int onGetChildDrawingOrder(int childCount, int i) {
                return childCount - 1 - i;
            }
        });
        this.addView((View)this.mRecyclerView);
        this.mStickyHeader = new LithoView(new ComponentContext(this.getContext()), null);
        this.mStickyHeader.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.addView((View)this.mStickyHeader);
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public void setStickyComponent(ComponentTree component) {
        if (component.getLithoView() != null) {
            component.getLithoView().startTemporaryDetach();
        }
        this.mStickyHeader.setComponentTree(component);
        this.measureStickyHeader(this.getWidth());
    }

    public LithoView getStickyHeader() {
        return this.mStickyHeader;
    }

    public void setStickyHeaderVerticalOffset(int verticalOffset) {
        this.mStickyHeader.setTranslationY((float)verticalOffset);
    }

    public void showStickyHeader() {
        this.mStickyHeader.setVisibility(0);
    }

    public void hideStickyHeader() {
        this.mStickyHeader.setVisibility(8);
    }

    public boolean isStickyHeaderHidden() {
        return this.mStickyHeader.getVisibility() == 8;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureStickyHeader(View.MeasureSpec.getSize((int)widthMeasureSpec));
    }

    private void measureStickyHeader(int parentWidth) {
        this.measureChild((View)this.mStickyHeader, View.MeasureSpec.makeMeasureSpec((int)parentWidth, (int)0x40000000), 0);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mStickyHeader.getVisibility() == 8) {
            return;
        }
        int stickyHeaderLeft = this.getPaddingLeft();
        int stickyHeaderTop = this.getPaddingTop();
        this.mStickyHeader.layout(stickyHeaderLeft, stickyHeaderTop, stickyHeaderLeft + this.mStickyHeader.getMeasuredWidth(), stickyHeaderTop + this.mStickyHeader.getMeasuredHeight());
    }

    static RecyclerViewWrapper getParentWrapper(RecyclerView recyclerView) {
        if (recyclerView.getParent() instanceof RecyclerViewWrapper) {
            return (RecyclerViewWrapper)recyclerView.getParent();
        }
        return null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHasBeenDetachedFromWindow = true;
    }

    public boolean isLayoutRequested() {
        if (this.getParent() != null) {
            return this.getParent().isLayoutRequested() || super.isLayoutRequested();
        }
        return super.isLayoutRequested();
    }

    boolean hasBeenDetachedFromWindow() {
        return this.mHasBeenDetachedFromWindow;
    }

    void setHasBeenDetachedFromWindow(boolean hasBeenDetachedFromWindow) {
        this.mHasBeenDetachedFromWindow = hasBeenDetachedFromWindow;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        if (this.getParent() != null && !this.isNestedScrollingEnabled()) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mRecyclerView.setOnTouchListener(listener);
    }

    public void obtainLithoViewChildren(List<LithoView> lithoViews) {
        int size = this.mRecyclerView.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.mRecyclerView.getChildAt(i);
            if (!(child instanceof LithoView)) continue;
            lithoViews.add((LithoView)child);
        }
    }
}

