/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.widget.RecyclerViewWrapper;

public class RecyclerEventsController {
    private RecyclerViewWrapper mRecyclerViewWrapper;
    private final Runnable mClearRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            if (RecyclerEventsController.this.mRecyclerViewWrapper != null && RecyclerEventsController.this.mRecyclerViewWrapper.isRefreshing()) {
                RecyclerEventsController.this.mRecyclerViewWrapper.setRefreshing(false);
            }
        }
    };

    public void requestScrollToTop(boolean animated) {
        this.requestScrollToPosition(0, animated);
    }

    public void requestScrollToPosition(int position, boolean animated) {
        if (this.mRecyclerViewWrapper != null) {
            if (animated) {
                this.mRecyclerViewWrapper.getRecyclerView().smoothScrollToPosition(position);
            } else {
                this.mRecyclerViewWrapper.getRecyclerView().scrollToPosition(position);
            }
        }
    }

    public void clearRefreshing() {
        if (this.mRecyclerViewWrapper == null || !this.mRecyclerViewWrapper.isRefreshing()) {
            return;
        }
        if (ThreadUtils.isMainThread()) {
            this.mRecyclerViewWrapper.setRefreshing(false);
            return;
        }
        this.mRecyclerViewWrapper.removeCallbacks(this.mClearRefreshRunnable);
        this.mRecyclerViewWrapper.post(this.mClearRefreshRunnable);
    }

    public void showRefreshing() {
        if (this.mRecyclerViewWrapper == null || this.mRecyclerViewWrapper.isRefreshing()) {
            return;
        }
        ThreadUtils.assertMainThread();
        this.mRecyclerViewWrapper.setRefreshing(true);
    }

    void setRecyclerViewWrapper(RecyclerViewWrapper recyclerViewWrapper) {
        this.mRecyclerViewWrapper = recyclerViewWrapper;
    }

    @Nullable
    protected RecyclerView getRecyclerView() {
        return this.mRecyclerViewWrapper == null ? null : this.mRecyclerViewWrapper.getRecyclerView();
    }
}

