/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.v4.util.Pools;
import android.support.v7.util.ListUpdateCallback;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.litho.widget.RecyclerBinderOperationExecutor;
import com.facebook.litho.widget.RenderInfo;
import java.util.ArrayList;
import java.util.List;

public class RecyclerBinderUpdateCallback<T>
implements ListUpdateCallback {
    private static final Pools.SynchronizedPool<RecyclerBinderUpdateCallback> sUpdatesCallbackPool = new Pools.SynchronizedPool(4);
    private List<T> mData;
    private List<Operation> mOperations;
    private List<ComponentContainer> mPlaceholders;
    private ComponentRenderer mComponentRenderer;
    private OperationExecutor mOperationExecutor;

    public static <T> RecyclerBinderUpdateCallback<T> acquire(int oldDataSize, List<T> data, ComponentRenderer<T> componentRenderer, RecyclerBinder recyclerBinder) {
        return RecyclerBinderUpdateCallback.acquire(oldDataSize, data, componentRenderer, new RecyclerBinderOperationExecutor(recyclerBinder));
    }

    public static <T> RecyclerBinderUpdateCallback<T> acquire(int oldDataSize, List<T> data, ComponentRenderer<T> componentRenderer, OperationExecutor operationExecutor) {
        RecyclerBinderUpdateCallback<T> instance = (RecyclerBinderUpdateCallback<T>)sUpdatesCallbackPool.acquire();
        if (instance == null) {
            instance = new RecyclerBinderUpdateCallback<T>();
        }
        super.init(oldDataSize, data, componentRenderer, operationExecutor);
        return instance;
    }

    public static <T> void release(RecyclerBinderUpdateCallback<T> updatesCallback) {
        int i;
        List<Operation> operations = updatesCallback.mOperations;
        int size = operations.size();
        for (i = 0; i < size; ++i) {
            operations.get(i).release();
        }
        updatesCallback.mOperations = null;
        updatesCallback.mData = null;
        size = updatesCallback.mPlaceholders.size();
        for (i = 0; i < size; ++i) {
            updatesCallback.mPlaceholders.get(i).release();
        }
        updatesCallback.mComponentRenderer = null;
        updatesCallback.mOperationExecutor = null;
        sUpdatesCallbackPool.release(updatesCallback);
    }

    private RecyclerBinderUpdateCallback() {
    }

    private void init(int oldDataSize, List<T> data, ComponentRenderer<T> componentRenderer, OperationExecutor operationExecutor) {
        this.mData = data;
        this.mComponentRenderer = componentRenderer;
        this.mOperationExecutor = operationExecutor;
        this.mOperations = new ArrayList<Operation>();
        this.mPlaceholders = new ArrayList<ComponentContainer>();
        for (int i = 0; i < oldDataSize; ++i) {
            this.mPlaceholders.add(ComponentContainer.acquire());
        }
    }

    public void onInserted(int position, int count) {
        ArrayList<ComponentContainer> placeholders = new ArrayList<ComponentContainer>();
        for (int i = 0; i < count; ++i) {
            int index = position + i;
            ComponentContainer componentContainer = ComponentContainer.acquire();
            componentContainer.mNeedsComputation = true;
            this.mPlaceholders.add(index, componentContainer);
            placeholders.add(componentContainer);
        }
        this.mOperations.add(Operation.acquire(0, position, -1, placeholders));
    }

    public void onRemoved(int position, int count) {
        for (int i = 0; i < count; ++i) {
            ComponentContainer componentContainer = this.mPlaceholders.remove(position);
            componentContainer.release();
        }
        this.mOperations.add(Operation.acquire(2, position, count, null));
    }

    public void onMoved(int fromPosition, int toPosition) {
        this.mOperations.add(Operation.acquire(3, fromPosition, toPosition, null));
        ComponentContainer placeholder = this.mPlaceholders.remove(fromPosition);
        this.mPlaceholders.add(toPosition, placeholder);
    }

    public void onChanged(int position, int count, Object payload) {
        ArrayList<ComponentContainer> placeholders = new ArrayList<ComponentContainer>();
        for (int i = 0; i < count; ++i) {
            int index = position + i;
            ComponentContainer placeholder = this.mPlaceholders.get(index);
            placeholder.mNeedsComputation = true;
            placeholders.add(placeholder);
        }
        this.mOperations.add(Operation.acquire(1, position, -1, placeholders));
    }

    public void applyChangeset() {
        int size = this.mPlaceholders.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mPlaceholders.get(i).mNeedsComputation) continue;
            this.mPlaceholders.get(i).mRenderInfo = this.mComponentRenderer.render(this.mData.get(i), i);
        }
        this.mOperationExecutor.executeOperations(this.mOperations);
    }

    public static class ComponentContainer {
        private static final Pools.SynchronizedPool<ComponentContainer> sComponentContainerPool = new Pools.SynchronizedPool(8);
        private RenderInfo mRenderInfo;
        private boolean mNeedsComputation = false;

        public static ComponentContainer acquire() {
            ComponentContainer componentContainer = (ComponentContainer)sComponentContainerPool.acquire();
            if (componentContainer == null) {
                componentContainer = new ComponentContainer();
            }
            return componentContainer;
        }

        public void release() {
            this.mRenderInfo = null;
            this.mNeedsComputation = false;
            sComponentContainerPool.release((Object)this);
        }

        public RenderInfo getRenderInfo() {
            return this.mRenderInfo;
        }
    }

    public static class Operation {
        private static final Pools.SynchronizedPool<Operation> sOperationsPool = new Pools.SynchronizedPool(8);
        public static final int INSERT = 0;
        public static final int UPDATE = 1;
        public static final int DELETE = 2;
        public static final int MOVE = 3;
        private int mType;
        private int mIndex;
        private int mToIndex;
        private List<ComponentContainer> mComponentContainers;

        private Operation() {
        }

        private void init(int type, int index, int toIndex, List<ComponentContainer> placeholder) {
            this.mType = type;
            this.mIndex = index;
            this.mToIndex = toIndex;
            this.mComponentContainers = placeholder;
        }

        private static Operation acquire(int type, int index, int toIndex, List<ComponentContainer> placeholder) {
            Operation operation = (Operation)sOperationsPool.acquire();
            if (operation == null) {
                operation = new Operation();
            }
            operation.init(type, index, toIndex, placeholder);
            return operation;
        }

        private void release() {
            if (this.mComponentContainers != null) {
                this.mComponentContainers.clear();
                this.mComponentContainers = null;
            }
            sOperationsPool.release((Object)this);
        }

        public int getType() {
            return this.mType;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getToIndex() {
            return this.mToIndex;
        }

        public List<ComponentContainer> getComponentContainers() {
            return this.mComponentContainers;
        }
    }

    public static interface OperationExecutor {
        public void executeOperations(List<Operation> var1);
    }

    public static interface ComponentRenderer<T> {
        public RenderInfo render(T var1, int var2);
    }
}

