/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.util.Pools;
import android.widget.ProgressBar;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.ProgressSpec;

public final class Progress
extends ComponentLifecycle {
    private static Progress sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private Progress() {
    }

    private static synchronized Progress get() {
        if (sInstance == null) {
            sInstance = new Progress();
        }
        return sInstance;
    }

    protected void onLoadStyle(ComponentContext c, Component _abstractImpl) {
        ProgressImpl _impl = (ProgressImpl)_abstractImpl;
        Output indeterminateDrawable = this.acquireOutput();
        ProgressSpec.onLoadStyle(c, (Output<Drawable>)indeterminateDrawable);
        if (indeterminateDrawable.get() != null) {
            _impl.indeterminateDrawable = (Drawable)indeterminateDrawable.get();
        }
        this.releaseOutput(indeterminateDrawable);
    }

    protected void onPrepare(ComponentContext c, Component _abstractImpl) {
        ProgressImpl _impl = (ProgressImpl)_abstractImpl;
        Output resolvedIndeterminateDrawable = this.acquireOutput();
        ProgressSpec.onPrepare(c, _impl.indeterminateDrawable, (Output<Drawable>)resolvedIndeterminateDrawable);
        _impl.resolvedIndeterminateDrawable = (Drawable)resolvedIndeterminateDrawable.get();
        this.releaseOutput(resolvedIndeterminateDrawable);
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component _abstractImpl) {
        ProgressImpl _impl = (ProgressImpl)_abstractImpl;
        ProgressSpec.onMeasure(c, layout, widthSpec, heightSpec, size);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onMount(ComponentContext c, Object progressBar, Component _abstractImpl) {
        ProgressImpl _impl = (ProgressImpl)_abstractImpl;
        ProgressSpec.onMount(c, (ProgressBar)progressBar, _impl.color, _impl.resolvedIndeterminateDrawable);
    }

    protected void onUnmount(ComponentContext c, Object progressBar, Component _abstractImpl) {
        ProgressImpl _impl = (ProgressImpl)_abstractImpl;
        ProgressSpec.onUnmount(c, (ProgressBar)progressBar, _impl.color, _impl.resolvedIndeterminateDrawable);
    }

    protected Object onCreateMountContent(ComponentContext c) {
        ProgressBar _result = ProgressSpec.onCreateMountContent(c);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 15;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Progress.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new ProgressImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<Progress, Builder> {
        ProgressImpl mProgressImpl;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, ProgressImpl progressImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)progressImpl);
            this.mProgressImpl = progressImpl;
            this.mContext = context;
        }

        public Builder indeterminateDrawable(Drawable indeterminateDrawable) {
            this.mProgressImpl.indeterminateDrawable = indeterminateDrawable;
            return this;
        }

        public Builder indeterminateDrawableRes(@DrawableRes int resId) {
            this.mProgressImpl.indeterminateDrawable = this.resolveDrawableRes(resId);
            return this;
        }

        public Builder indeterminateDrawableAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mProgressImpl.indeterminateDrawable = this.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        public Builder indeterminateDrawableAttr(@AttrRes int attrResId) {
            this.mProgressImpl.indeterminateDrawable = this.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        public Builder color(@ColorInt int color) {
            this.mProgressImpl.color = color;
            return this;
        }

        public Builder colorRes(@ColorRes int resId) {
            this.mProgressImpl.color = this.resolveColorRes(resId);
            return this;
        }

        public Builder colorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mProgressImpl.color = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder colorAttr(@AttrRes int attrResId) {
            this.mProgressImpl.color = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<Progress> build() {
            ProgressImpl progressImpl = this.mProgressImpl;
            this.release();
            return progressImpl;
        }

        protected void release() {
            super.release();
            this.mProgressImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class ProgressImpl
    extends Component<Progress>
    implements Cloneable {
        @Prop(resType=ResType.DRAWABLE, optional=true)
        Drawable indeterminateDrawable;
        @Prop(resType=ResType.COLOR, optional=true)
        int color = 0;
        Drawable resolvedIndeterminateDrawable;

        private ProgressImpl() {
            super((ComponentLifecycle)Progress.get());
        }

        public String getSimpleName() {
            return "Progress";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ProgressImpl progressImpl = (ProgressImpl)other;
            if (this.getId() == progressImpl.getId()) {
                return true;
            }
            if (this.indeterminateDrawable != null ? !this.indeterminateDrawable.equals(progressImpl.indeterminateDrawable) : progressImpl.indeterminateDrawable != null) {
                return false;
            }
            return this.color == progressImpl.color;
        }

        protected void copyInterStageImpl(Component<Progress> impl) {
            ProgressImpl progressImpl = (ProgressImpl)impl;
            this.resolvedIndeterminateDrawable = progressImpl.resolvedIndeterminateDrawable;
        }

        public ProgressImpl makeShallowCopy() {
            ProgressImpl component = (ProgressImpl)super.makeShallowCopy();
            component.resolvedIndeterminateDrawable = null;
            return component;
        }
    }
}

