/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.AttrRes;
import android.support.annotation.BoolRes;
import android.support.v4.util.Pools;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.HorizontalScrollSpec;
import java.util.BitSet;

public final class HorizontalScroll
extends ComponentLifecycle {
    private static HorizontalScroll sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private HorizontalScroll() {
    }

    private static synchronized HorizontalScroll get() {
        if (sInstance == null) {
            sInstance = new HorizontalScroll();
        }
        return sInstance;
    }

    protected void onLoadStyle(ComponentContext c, Component _abstractImpl) {
        HorizontalScrollImpl _impl = (HorizontalScrollImpl)_abstractImpl;
        Output scrollbarEnabled = this.acquireOutput();
        HorizontalScrollSpec.onLoadStyle(c, (Output<Boolean>)scrollbarEnabled);
        if (scrollbarEnabled.get() != null) {
            _impl.scrollbarEnabled = (Boolean)scrollbarEnabled.get();
        }
        this.releaseOutput(scrollbarEnabled);
    }

    protected void onPrepare(ComponentContext context, Component _abstractImpl) {
        HorizontalScrollImpl _impl = (HorizontalScrollImpl)_abstractImpl;
        Output contentComponent = this.acquireOutput();
        HorizontalScrollSpec.onPrepare(context, _impl.contentProps, (Output<ComponentTree>)contentComponent);
        _impl.contentComponent = (ComponentTree)contentComponent.get();
        this.releaseOutput(contentComponent);
    }

    protected void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component _abstractImpl) {
        HorizontalScrollImpl _impl = (HorizontalScrollImpl)_abstractImpl;
        Output measuredComponentWidth = this.acquireOutput();
        Output measuredComponentHeight = this.acquireOutput();
        HorizontalScrollSpec.onMeasure(context, layout, widthSpec, heightSpec, size, _impl.contentComponent, (Output<Integer>)measuredComponentWidth, (Output<Integer>)measuredComponentHeight);
        _impl.measuredComponentWidth = (Integer)measuredComponentWidth.get();
        this.releaseOutput(measuredComponentWidth);
        _impl.measuredComponentHeight = (Integer)measuredComponentHeight.get();
        this.releaseOutput(measuredComponentHeight);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext context, ComponentLayout layout, Component _abstractImpl) {
        HorizontalScrollImpl _impl = (HorizontalScrollImpl)_abstractImpl;
        Output componentWidth = this.acquireOutput();
        Output componentHeight = this.acquireOutput();
        HorizontalScrollSpec.onBoundsDefined(context, layout, _impl.contentComponent, _impl.measuredComponentWidth, _impl.measuredComponentHeight, (Output<Integer>)componentWidth, (Output<Integer>)componentHeight);
        _impl.componentWidth = (Integer)componentWidth.get();
        this.releaseOutput(componentWidth);
        _impl.componentHeight = (Integer)componentHeight.get();
        this.releaseOutput(componentHeight);
    }

    protected Object onCreateMountContent(ComponentContext c) {
        HorizontalScrollSpec.HorizontalScrollLithoView _result = HorizontalScrollSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext context, Object horizontalScrollLithoView, Component _abstractImpl) {
        HorizontalScrollImpl _impl = (HorizontalScrollImpl)_abstractImpl;
        HorizontalScrollSpec.onMount(context, (HorizontalScrollSpec.HorizontalScrollLithoView)((Object)horizontalScrollLithoView), _impl.scrollbarEnabled, _impl.mStateContainerImpl.lastScrollPosition, _impl.contentComponent, _impl.componentWidth, _impl.componentHeight);
    }

    protected void onUnmount(ComponentContext context, Object mountedView, Component _abstractImpl) {
        HorizontalScrollImpl _impl = (HorizontalScrollImpl)_abstractImpl;
        HorizontalScrollSpec.onUnmount(context, (HorizontalScrollSpec.HorizontalScrollLithoView)((Object)mountedView));
    }

    protected void createInitialState(ComponentContext c, Component _abstractImpl) {
        HorizontalScrollImpl _impl = (HorizontalScrollImpl)_abstractImpl;
        StateValue lastScrollPosition = new StateValue();
        HorizontalScrollSpec.onCreateInitialState(c, (StateValue<HorizontalScrollSpec.ScrollPosition>)lastScrollPosition);
        _impl.mStateContainerImpl.lastScrollPosition = (HorizontalScrollSpec.ScrollPosition)lastScrollPosition.get();
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 15;
    }

    protected boolean isMountSizeDependent() {
        return true;
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(ComponentContext context, ComponentLifecycle.StateContainer prevStateContainer, Component component) {
        HorizontalScrollStateContainerImpl prevStateContainerImpl = (HorizontalScrollStateContainerImpl)prevStateContainer;
        HorizontalScrollImpl componentImpl = (HorizontalScrollImpl)component;
        componentImpl.mStateContainerImpl.lastScrollPosition = prevStateContainerImpl.lastScrollPosition;
    }

    public static Builder create(ComponentContext context) {
        return HorizontalScroll.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new HorizontalScrollImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<HorizontalScroll, Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"contentProps"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        HorizontalScrollImpl mHorizontalScrollImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, HorizontalScrollImpl horizontalScrollImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)horizontalScrollImpl);
            this.mHorizontalScrollImpl = horizontalScrollImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder contentProps(Component<?> contentProps) {
            this.mHorizontalScrollImpl.contentProps = contentProps;
            this.mRequired.set(0);
            return this;
        }

        public Builder contentProps(Component.Builder<?, ?> contentPropsBuilder) {
            this.mHorizontalScrollImpl.contentProps = contentPropsBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        public Builder scrollbarEnabled(boolean scrollbarEnabled) {
            this.mHorizontalScrollImpl.scrollbarEnabled = scrollbarEnabled;
            return this;
        }

        public Builder scrollbarEnabledRes(@BoolRes int resId) {
            this.mHorizontalScrollImpl.scrollbarEnabled = this.resolveBoolRes(resId);
            return this;
        }

        public Builder scrollbarEnabledAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mHorizontalScrollImpl.scrollbarEnabled = this.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        public Builder scrollbarEnabledAttr(@AttrRes int attrResId) {
            this.mHorizontalScrollImpl.scrollbarEnabled = this.resolveBoolAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<HorizontalScroll> build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])REQUIRED_PROPS_NAMES);
            HorizontalScrollImpl horizontalScrollImpl = this.mHorizontalScrollImpl;
            this.release();
            return horizontalScrollImpl;
        }

        protected void release() {
            super.release();
            this.mHorizontalScrollImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class HorizontalScrollImpl
    extends Component<HorizontalScroll>
    implements Cloneable {
        HorizontalScrollStateContainerImpl mStateContainerImpl = new HorizontalScrollStateContainerImpl();
        @Prop(resType=ResType.NONE, optional=false)
        Component<?> contentProps;
        @Prop(resType=ResType.BOOL, optional=true)
        boolean scrollbarEnabled = true;
        ComponentTree contentComponent;
        Integer measuredComponentWidth;
        Integer measuredComponentHeight;
        Integer componentWidth;
        Integer componentHeight;

        private HorizontalScrollImpl() {
            super((ComponentLifecycle)HorizontalScroll.get());
        }

        protected ComponentLifecycle.StateContainer getStateContainer() {
            return this.mStateContainerImpl;
        }

        public String getSimpleName() {
            return "HorizontalScroll";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            HorizontalScrollImpl horizontalScrollImpl = (HorizontalScrollImpl)other;
            if (this.getId() == horizontalScrollImpl.getId()) {
                return true;
            }
            if (this.contentProps != null ? !this.contentProps.equals(horizontalScrollImpl.contentProps) : horizontalScrollImpl.contentProps != null) {
                return false;
            }
            if (this.scrollbarEnabled != horizontalScrollImpl.scrollbarEnabled) {
                return false;
            }
            return !(this.mStateContainerImpl.lastScrollPosition != null ? !this.mStateContainerImpl.lastScrollPosition.equals(horizontalScrollImpl.mStateContainerImpl.lastScrollPosition) : horizontalScrollImpl.mStateContainerImpl.lastScrollPosition != null);
        }

        protected void copyInterStageImpl(Component<HorizontalScroll> impl) {
            HorizontalScrollImpl horizontalScrollImpl = (HorizontalScrollImpl)impl;
            this.contentComponent = horizontalScrollImpl.contentComponent;
            this.measuredComponentWidth = horizontalScrollImpl.measuredComponentWidth;
            this.measuredComponentHeight = horizontalScrollImpl.measuredComponentHeight;
            this.componentWidth = horizontalScrollImpl.componentWidth;
            this.componentHeight = horizontalScrollImpl.componentHeight;
        }

        public HorizontalScrollImpl makeShallowCopy() {
            HorizontalScrollImpl component = (HorizontalScrollImpl)super.makeShallowCopy();
            component.contentProps = component.contentProps != null ? component.contentProps.makeShallowCopy() : null;
            component.contentComponent = null;
            component.measuredComponentWidth = null;
            component.measuredComponentHeight = null;
            component.componentWidth = null;
            component.componentHeight = null;
            component.mStateContainerImpl = new HorizontalScrollStateContainerImpl();
            return component;
        }
    }

    private static class HorizontalScrollStateContainerImpl
    implements ComponentLifecycle.StateContainer {
        @State
        HorizontalScrollSpec.ScrollPosition lastScrollPosition;

        private HorizontalScrollStateContainerImpl() {
        }
    }
}

