/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.RenderInfo;

public class GridLayoutInfo
implements LayoutInfo {
    private final GridLayoutManager mGridLayoutManager;
    private final GridSpanSizeLookup mGridSpanSizeLookup;
    private LayoutInfo.RenderInfoCollection mRenderInfoCollection;

    public GridLayoutInfo(Context context, int spanCount, int orientation, boolean reverseLayout) {
        this.mGridLayoutManager = new GridLayoutManager(context, spanCount, orientation, reverseLayout);
        this.mGridSpanSizeLookup = new GridSpanSizeLookup();
        this.mGridLayoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.mGridSpanSizeLookup);
    }

    public GridLayoutInfo(Context context, int spanCount) {
        this(context, spanCount, 1, false);
    }

    @Override
    public int getScrollDirection() {
        return this.mGridLayoutManager.getOrientation();
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return this.mGridLayoutManager.findFirstVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        return this.mGridLayoutManager.findLastVisibleItemPosition();
    }

    @Override
    public int findFirstFullyVisibleItemPosition() {
        return this.mGridLayoutManager.findFirstCompletelyVisibleItemPosition();
    }

    @Override
    public int findLastFullyVisibleItemPosition() {
        return this.mGridLayoutManager.findLastCompletelyVisibleItemPosition();
    }

    @Override
    public int getItemCount() {
        return this.mGridLayoutManager.getItemCount();
    }

    @Override
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mGridLayoutManager;
    }

    @Override
    public void setRenderInfoCollection(LayoutInfo.RenderInfoCollection renderInfoCollection) {
        this.mRenderInfoCollection = renderInfoCollection;
    }

    @Override
    public int approximateRangeSize(int firstMeasuredItemWidth, int firstMeasuredItemHeight, int recyclerMeasuredWidth, int recyclerMeasuredHeight) {
        int spanCount = this.mGridLayoutManager.getSpanCount();
        switch (this.mGridLayoutManager.getOrientation()) {
            case 0: {
                int colCount = (int)Math.ceil((double)recyclerMeasuredWidth / (double)firstMeasuredItemWidth);
                return colCount * spanCount;
            }
        }
        int rowCount = (int)Math.ceil((double)recyclerMeasuredHeight / (double)firstMeasuredItemHeight);
        return rowCount * spanCount;
    }

    @Override
    public int getChildWidthSpec(int widthSpec, RenderInfo renderInfo) {
        switch (this.mGridLayoutManager.getOrientation()) {
            case 0: {
                return SizeSpec.makeSizeSpec((int)0, (int)0);
            }
        }
        int spanCount = this.mGridLayoutManager.getSpanCount();
        int spanSize = renderInfo.getSpanSize();
        return spanSize * SizeSpec.makeSizeSpec((int)(SizeSpec.getSize((int)widthSpec) / spanCount), (int)0x40000000);
    }

    @Override
    public int getChildHeightSpec(int heightSpec, RenderInfo renderInfo) {
        switch (this.mGridLayoutManager.getOrientation()) {
            case 0: {
                int spanCount = this.mGridLayoutManager.getSpanCount();
                int spanSize = renderInfo.getSpanSize();
                return spanSize * SizeSpec.makeSizeSpec((int)(SizeSpec.getSize((int)heightSpec) / spanCount), (int)0x40000000);
            }
        }
        return SizeSpec.makeSizeSpec((int)0, (int)0);
    }

    private class GridSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private GridSpanSizeLookup() {
        }

        public int getSpanSize(int position) {
            if (GridLayoutInfo.this.mRenderInfoCollection == null) {
                return 1;
            }
            return GridLayoutInfo.this.mRenderInfoCollection.getRenderInfoAt(position).getSpanSize();
        }
    }
}

