/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.support.annotation.AttrRes;
import android.support.annotation.BoolRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.IntegerRes;
import android.support.annotation.Px;
import android.support.annotation.StringRes;
import android.support.v4.util.Pools;
import android.text.Layout;
import android.text.TextUtils;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.EditTextSpec;
import com.facebook.litho.widget.TextChangedEvent;

public final class EditText
extends ComponentLifecycle {
    private static EditText sInstance = null;
    static final Pools.SynchronizedPool<TextChangedEvent> sTextChangedEventPool = new Pools.SynchronizedPool(2);
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private EditText() {
    }

    private static synchronized EditText get() {
        if (sInstance == null) {
            sInstance = new EditText();
        }
        return sInstance;
    }

    protected void onLoadStyle(ComponentContext c, Component _abstractImpl) {
        EditTextImpl _impl = (EditTextImpl)_abstractImpl;
        Output ellipsize = this.acquireOutput();
        Output spacingMultiplier = this.acquireOutput();
        Output minLines = this.acquireOutput();
        Output maxLines = this.acquireOutput();
        Output isSingleLine = this.acquireOutput();
        Output text = this.acquireOutput();
        Output textColorStateList = this.acquireOutput();
        Output linkColor = this.acquireOutput();
        Output highlightColor = this.acquireOutput();
        Output textSize = this.acquireOutput();
        Output textAlignment = this.acquireOutput();
        Output textStyle = this.acquireOutput();
        Output shadowRadius = this.acquireOutput();
        Output shadowDx = this.acquireOutput();
        Output shadowDy = this.acquireOutput();
        Output shadowColor = this.acquireOutput();
        Output gravity = this.acquireOutput();
        Output inputType = this.acquireOutput();
        Output imeOptions = this.acquireOutput();
        EditTextSpec.onLoadStyle(c, (Output<TextUtils.TruncateAt>)ellipsize, (Output<Float>)spacingMultiplier, (Output<Integer>)minLines, (Output<Integer>)maxLines, (Output<Boolean>)isSingleLine, (Output<CharSequence>)text, (Output<ColorStateList>)textColorStateList, (Output<Integer>)linkColor, (Output<Integer>)highlightColor, (Output<Integer>)textSize, (Output<Layout.Alignment>)textAlignment, (Output<Integer>)textStyle, (Output<Float>)shadowRadius, (Output<Float>)shadowDx, (Output<Float>)shadowDy, (Output<Integer>)shadowColor, (Output<Integer>)gravity, (Output<Integer>)inputType, (Output<Integer>)imeOptions);
        if (ellipsize.get() != null) {
            _impl.ellipsize = (TextUtils.TruncateAt)ellipsize.get();
        }
        this.releaseOutput(ellipsize);
        if (spacingMultiplier.get() != null) {
            _impl.spacingMultiplier = ((Float)spacingMultiplier.get()).floatValue();
        }
        this.releaseOutput(spacingMultiplier);
        if (minLines.get() != null) {
            _impl.minLines = (Integer)minLines.get();
        }
        this.releaseOutput(minLines);
        if (maxLines.get() != null) {
            _impl.maxLines = (Integer)maxLines.get();
        }
        this.releaseOutput(maxLines);
        if (isSingleLine.get() != null) {
            _impl.isSingleLine = (Boolean)isSingleLine.get();
        }
        this.releaseOutput(isSingleLine);
        if (text.get() != null) {
            _impl.text = (CharSequence)text.get();
        }
        this.releaseOutput(text);
        if (textColorStateList.get() != null) {
            _impl.textColorStateList = (ColorStateList)textColorStateList.get();
        }
        this.releaseOutput(textColorStateList);
        if (linkColor.get() != null) {
            _impl.linkColor = (Integer)linkColor.get();
        }
        this.releaseOutput(linkColor);
        if (highlightColor.get() != null) {
            _impl.highlightColor = (Integer)highlightColor.get();
        }
        this.releaseOutput(highlightColor);
        if (textSize.get() != null) {
            _impl.textSize = (Integer)textSize.get();
        }
        this.releaseOutput(textSize);
        if (textAlignment.get() != null) {
            _impl.textAlignment = (Layout.Alignment)textAlignment.get();
        }
        this.releaseOutput(textAlignment);
        if (textStyle.get() != null) {
            _impl.textStyle = (Integer)textStyle.get();
        }
        this.releaseOutput(textStyle);
        if (shadowRadius.get() != null) {
            _impl.shadowRadius = ((Float)shadowRadius.get()).floatValue();
        }
        this.releaseOutput(shadowRadius);
        if (shadowDx.get() != null) {
            _impl.shadowDx = ((Float)shadowDx.get()).floatValue();
        }
        this.releaseOutput(shadowDx);
        if (shadowDy.get() != null) {
            _impl.shadowDy = ((Float)shadowDy.get()).floatValue();
        }
        this.releaseOutput(shadowDy);
        if (shadowColor.get() != null) {
            _impl.shadowColor = (Integer)shadowColor.get();
        }
        this.releaseOutput(shadowColor);
        if (gravity.get() != null) {
            _impl.gravity = (Integer)gravity.get();
        }
        this.releaseOutput(gravity);
        if (inputType.get() != null) {
            _impl.inputType = (Integer)inputType.get();
        }
        this.releaseOutput(inputType);
        if (imeOptions.get() != null) {
            _impl.imeOptions = (Integer)imeOptions.get();
        }
        this.releaseOutput(imeOptions);
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component _abstractImpl) {
        EditTextImpl _impl = (EditTextImpl)_abstractImpl;
        EditTextSpec.onMeasure(c, layout, widthSpec, heightSpec, size, _impl.text, _impl.hint, _impl.ellipsize, _impl.minLines, _impl.maxLines, _impl.maxLength, _impl.shadowRadius, _impl.shadowDx, _impl.shadowDy, _impl.shadowColor, _impl.isSingleLine, _impl.textColor, _impl.textColorStateList, _impl.hintColor, _impl.hintColorStateList, _impl.linkColor, _impl.highlightColor, _impl.textSize, _impl.extraSpacing, _impl.spacingMultiplier, _impl.textStyle, _impl.typeface, _impl.textAlignment, _impl.gravity, _impl.editable, _impl.selection, _impl.inputType, _impl.rawInputType, _impl.imeOptions);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected Object onCreateMountContent(ComponentContext c) {
        EditTextSpec.EditTextTextTextChangedEventHandler _result = EditTextSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object editText, Component _abstractImpl) {
        EditTextImpl _impl = (EditTextImpl)_abstractImpl;
        EditTextSpec.onMount(c, (EditTextSpec.EditTextTextTextChangedEventHandler)((Object)editText), _impl.text, _impl.hint, _impl.ellipsize, _impl.minLines, _impl.maxLines, _impl.maxLength, _impl.shadowRadius, _impl.shadowDx, _impl.shadowDy, _impl.shadowColor, _impl.isSingleLine, _impl.textColor, _impl.textColorStateList, _impl.hintColor, _impl.hintColorStateList, _impl.linkColor, _impl.highlightColor, _impl.textSize, _impl.extraSpacing, _impl.spacingMultiplier, _impl.textStyle, _impl.typeface, _impl.textAlignment, _impl.gravity, _impl.editable, _impl.selection, _impl.inputType, _impl.rawInputType, _impl.imeOptions);
    }

    protected void onBind(ComponentContext c, Object editText, Component _abstractImpl) {
        EditTextImpl _impl = (EditTextImpl)_abstractImpl;
        EditTextSpec.onBind(c, (EditTextSpec.EditTextTextTextChangedEventHandler)((Object)editText));
    }

    protected void onUnbind(ComponentContext c, Object editText, Component _abstractImpl) {
        EditTextImpl _impl = (EditTextImpl)_abstractImpl;
        EditTextSpec.onUnbind(c, (EditTextSpec.EditTextTextTextChangedEventHandler)((Object)editText));
    }

    protected void onUnmount(ComponentContext c, Object editText, Component _abstractImpl) {
        EditTextImpl _impl = (EditTextImpl)_abstractImpl;
        EditTextSpec.onUnmount(c, (EditTextSpec.EditTextTextTextChangedEventHandler)((Object)editText));
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 15;
    }

    public boolean isPureRender() {
        return true;
    }

    public static EventHandler getTextChangedEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((EditTextImpl)context.getComponentScope()).textChangedEventHandler;
    }

    static void dispatchTextChangedEvent(EventHandler _eventHandler, String text) {
        TextChangedEvent _eventState = (TextChangedEvent)sTextChangedEventPool.acquire();
        if (_eventState == null) {
            _eventState = new TextChangedEvent();
        }
        _eventState.text = text;
        EventDispatcher _lifecycle = _eventHandler.mHasEventDispatcher.getEventDispatcher();
        _lifecycle.dispatchOnEvent(_eventHandler, (Object)_eventState);
        _eventState.text = null;
        sTextChangedEventPool.release((Object)_eventState);
    }

    public static Builder create(ComponentContext context) {
        return EditText.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new EditTextImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<EditText, Builder> {
        EditTextImpl mEditTextImpl;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, EditTextImpl editTextImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)editTextImpl);
            this.mEditTextImpl = editTextImpl;
            this.mContext = context;
        }

        public Builder text(CharSequence text) {
            this.mEditTextImpl.text = text;
            return this;
        }

        public Builder textRes(@StringRes int resId) {
            this.mEditTextImpl.text = this.resolveStringRes(resId);
            return this;
        }

        public Builder textRes(@StringRes int resId, Object ... formatArgs) {
            this.mEditTextImpl.text = this.resolveStringRes(resId, formatArgs);
            return this;
        }

        public Builder textAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mEditTextImpl.text = this.resolveStringAttr(attrResId, defResId);
            return this;
        }

        public Builder textAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.text = this.resolveStringAttr(attrResId, 0);
            return this;
        }

        public Builder hint(CharSequence hint) {
            this.mEditTextImpl.hint = hint;
            return this;
        }

        public Builder hintRes(@StringRes int resId) {
            this.mEditTextImpl.hint = this.resolveStringRes(resId);
            return this;
        }

        public Builder hintRes(@StringRes int resId, Object ... formatArgs) {
            this.mEditTextImpl.hint = this.resolveStringRes(resId, formatArgs);
            return this;
        }

        public Builder hintAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mEditTextImpl.hint = this.resolveStringAttr(attrResId, defResId);
            return this;
        }

        public Builder hintAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.hint = this.resolveStringAttr(attrResId, 0);
            return this;
        }

        public Builder ellipsize(TextUtils.TruncateAt ellipsize) {
            this.mEditTextImpl.ellipsize = ellipsize;
            return this;
        }

        public Builder minLines(int minLines) {
            this.mEditTextImpl.minLines = minLines;
            return this;
        }

        public Builder minLinesRes(@IntegerRes int resId) {
            this.mEditTextImpl.minLines = this.resolveIntRes(resId);
            return this;
        }

        public Builder minLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mEditTextImpl.minLines = this.resolveIntAttr(attrResId, defResId);
            return this;
        }

        public Builder minLinesAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.minLines = this.resolveIntAttr(attrResId, 0);
            return this;
        }

        public Builder maxLines(int maxLines) {
            this.mEditTextImpl.maxLines = maxLines;
            return this;
        }

        public Builder maxLinesRes(@IntegerRes int resId) {
            this.mEditTextImpl.maxLines = this.resolveIntRes(resId);
            return this;
        }

        public Builder maxLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mEditTextImpl.maxLines = this.resolveIntAttr(attrResId, defResId);
            return this;
        }

        public Builder maxLinesAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.maxLines = this.resolveIntAttr(attrResId, 0);
            return this;
        }

        public Builder maxLength(int maxLength) {
            this.mEditTextImpl.maxLength = maxLength;
            return this;
        }

        public Builder maxLengthRes(@IntegerRes int resId) {
            this.mEditTextImpl.maxLength = this.resolveIntRes(resId);
            return this;
        }

        public Builder maxLengthAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mEditTextImpl.maxLength = this.resolveIntAttr(attrResId, defResId);
            return this;
        }

        public Builder maxLengthAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.maxLength = this.resolveIntAttr(attrResId, 0);
            return this;
        }

        public Builder shadowRadiusPx(@Px float shadowRadius) {
            this.mEditTextImpl.shadowRadius = shadowRadius;
            return this;
        }

        public Builder shadowRadiusRes(@DimenRes int resId) {
            this.mEditTextImpl.shadowRadius = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder shadowRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditTextImpl.shadowRadius = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowRadiusAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.shadowRadius = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder shadowRadiusDip(@Dimension(unit=0) float dip) {
            this.mEditTextImpl.shadowRadius = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowDxPx(@Px float shadowDx) {
            this.mEditTextImpl.shadowDx = shadowDx;
            return this;
        }

        public Builder shadowDxRes(@DimenRes int resId) {
            this.mEditTextImpl.shadowDx = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditTextImpl.shadowDx = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowDxAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.shadowDx = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder shadowDxDip(@Dimension(unit=0) float dip) {
            this.mEditTextImpl.shadowDx = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowDyPx(@Px float shadowDy) {
            this.mEditTextImpl.shadowDy = shadowDy;
            return this;
        }

        public Builder shadowDyRes(@DimenRes int resId) {
            this.mEditTextImpl.shadowDy = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditTextImpl.shadowDy = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowDyAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.shadowDy = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder shadowDyDip(@Dimension(unit=0) float dip) {
            this.mEditTextImpl.shadowDy = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowColor(@ColorInt int shadowColor) {
            this.mEditTextImpl.shadowColor = shadowColor;
            return this;
        }

        public Builder shadowColorRes(@ColorRes int resId) {
            this.mEditTextImpl.shadowColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder shadowColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditTextImpl.shadowColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowColorAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.shadowColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder isSingleLine(boolean isSingleLine) {
            this.mEditTextImpl.isSingleLine = isSingleLine;
            return this;
        }

        public Builder isSingleLineRes(@BoolRes int resId) {
            this.mEditTextImpl.isSingleLine = this.resolveBoolRes(resId);
            return this;
        }

        public Builder isSingleLineAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mEditTextImpl.isSingleLine = this.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        public Builder isSingleLineAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.isSingleLine = this.resolveBoolAttr(attrResId, 0);
            return this;
        }

        public Builder textColor(@ColorInt int textColor) {
            this.mEditTextImpl.textColor = textColor;
            return this;
        }

        public Builder textColorRes(@ColorRes int resId) {
            this.mEditTextImpl.textColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder textColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditTextImpl.textColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder textColorAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.textColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder textColorStateList(ColorStateList textColorStateList) {
            this.mEditTextImpl.textColorStateList = textColorStateList;
            return this;
        }

        public Builder hintColor(@ColorInt int hintColor) {
            this.mEditTextImpl.hintColor = hintColor;
            return this;
        }

        public Builder hintColorRes(@ColorRes int resId) {
            this.mEditTextImpl.hintColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder hintColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditTextImpl.hintColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder hintColorAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.hintColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder hintColorStateList(ColorStateList hintColorStateList) {
            this.mEditTextImpl.hintColorStateList = hintColorStateList;
            return this;
        }

        public Builder linkColor(@ColorInt int linkColor) {
            this.mEditTextImpl.linkColor = linkColor;
            return this;
        }

        public Builder linkColorRes(@ColorRes int resId) {
            this.mEditTextImpl.linkColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder linkColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditTextImpl.linkColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder linkColorAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.linkColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder highlightColor(@ColorInt int highlightColor) {
            this.mEditTextImpl.highlightColor = highlightColor;
            return this;
        }

        public Builder highlightColorRes(@ColorRes int resId) {
            this.mEditTextImpl.highlightColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditTextImpl.highlightColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder highlightColorAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.highlightColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder textSizePx(@Px int textSize) {
            this.mEditTextImpl.textSize = textSize;
            return this;
        }

        public Builder textSizeRes(@DimenRes int resId) {
            this.mEditTextImpl.textSize = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder textSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditTextImpl.textSize = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder textSizeAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.textSize = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder textSizeDip(@Dimension(unit=0) float dip) {
            this.mEditTextImpl.textSize = this.dipsToPixels(dip);
            return this;
        }

        public Builder textSizeSp(@Dimension(unit=2) float sip) {
            this.mEditTextImpl.textSize = this.sipsToPixels(sip);
            return this;
        }

        public Builder extraSpacingPx(@Px float extraSpacing) {
            this.mEditTextImpl.extraSpacing = extraSpacing;
            return this;
        }

        public Builder extraSpacingRes(@DimenRes int resId) {
            this.mEditTextImpl.extraSpacing = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder extraSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditTextImpl.extraSpacing = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder extraSpacingAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.extraSpacing = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder extraSpacingDip(@Dimension(unit=0) float dip) {
            this.mEditTextImpl.extraSpacing = this.dipsToPixels(dip);
            return this;
        }

        public Builder spacingMultiplier(float spacingMultiplier) {
            this.mEditTextImpl.spacingMultiplier = spacingMultiplier;
            return this;
        }

        public Builder spacingMultiplierRes(@DimenRes int resId) {
            this.mEditTextImpl.spacingMultiplier = this.resolveFloatRes(resId);
            return this;
        }

        public Builder spacingMultiplierAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditTextImpl.spacingMultiplier = this.resolveFloatAttr(attrResId, defResId);
            return this;
        }

        public Builder spacingMultiplierAttr(@AttrRes int attrResId) {
            this.mEditTextImpl.spacingMultiplier = this.resolveFloatAttr(attrResId, 0);
            return this;
        }

        public Builder textStyle(int textStyle) {
            this.mEditTextImpl.textStyle = textStyle;
            return this;
        }

        public Builder typeface(Typeface typeface) {
            this.mEditTextImpl.typeface = typeface;
            return this;
        }

        public Builder textAlignment(Layout.Alignment textAlignment) {
            this.mEditTextImpl.textAlignment = textAlignment;
            return this;
        }

        public Builder gravity(int gravity) {
            this.mEditTextImpl.gravity = gravity;
            return this;
        }

        public Builder editable(boolean editable) {
            this.mEditTextImpl.editable = editable;
            return this;
        }

        public Builder selection(int selection) {
            this.mEditTextImpl.selection = selection;
            return this;
        }

        public Builder inputType(int inputType) {
            this.mEditTextImpl.inputType = inputType;
            return this;
        }

        public Builder rawInputType(int rawInputType) {
            this.mEditTextImpl.rawInputType = rawInputType;
            return this;
        }

        public Builder imeOptions(int imeOptions) {
            this.mEditTextImpl.imeOptions = imeOptions;
            return this;
        }

        public Builder textChangedEventHandler(EventHandler textChangedEventHandler) {
            this.mEditTextImpl.textChangedEventHandler = textChangedEventHandler;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<EditText> build() {
            EditTextImpl editTextImpl = this.mEditTextImpl;
            this.release();
            return editTextImpl;
        }

        protected void release() {
            super.release();
            this.mEditTextImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class EditTextImpl
    extends Component<EditText>
    implements Cloneable {
        @Prop(resType=ResType.STRING, optional=true)
        CharSequence text;
        @Prop(resType=ResType.STRING, optional=true)
        CharSequence hint;
        @Prop(resType=ResType.NONE, optional=true)
        TextUtils.TruncateAt ellipsize;
        @Prop(resType=ResType.INT, optional=true)
        int minLines = Integer.MIN_VALUE;
        @Prop(resType=ResType.INT, optional=true)
        int maxLines = Integer.MAX_VALUE;
        @Prop(resType=ResType.INT, optional=true)
        int maxLength = Integer.MAX_VALUE;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float shadowRadius;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float shadowDx;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float shadowDy;
        @Prop(resType=ResType.COLOR, optional=true)
        int shadowColor = -7829368;
        @Prop(resType=ResType.BOOL, optional=true)
        boolean isSingleLine;
        @Prop(resType=ResType.COLOR, optional=true)
        int textColor = 0;
        @Prop(resType=ResType.NONE, optional=true)
        ColorStateList textColorStateList = EditTextSpec.textColorStateList;
        @Prop(resType=ResType.COLOR, optional=true)
        int hintColor = 0;
        @Prop(resType=ResType.NONE, optional=true)
        ColorStateList hintColorStateList = EditTextSpec.hintColorStateList;
        @Prop(resType=ResType.COLOR, optional=true)
        int linkColor = 0;
        @Prop(resType=ResType.COLOR, optional=true)
        int highlightColor;
        @Prop(resType=ResType.DIMEN_TEXT, optional=true)
        int textSize = 13;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float extraSpacing;
        @Prop(resType=ResType.FLOAT, optional=true)
        float spacingMultiplier = 1.0f;
        @Prop(resType=ResType.NONE, optional=true)
        int textStyle = EditTextSpec.textStyle;
        @Prop(resType=ResType.NONE, optional=true)
        Typeface typeface = EditTextSpec.typeface;
        @Prop(resType=ResType.NONE, optional=true)
        Layout.Alignment textAlignment = EditTextSpec.textAlignment;
        @Prop(resType=ResType.NONE, optional=true)
        int gravity = 8388627;
        @Prop(resType=ResType.NONE, optional=true)
        boolean editable = true;
        @Prop(resType=ResType.NONE, optional=true)
        int selection = -1;
        @Prop(resType=ResType.NONE, optional=true)
        int inputType = 131073;
        @Prop(resType=ResType.NONE, optional=true)
        int rawInputType = 0;
        @Prop(resType=ResType.NONE, optional=true)
        int imeOptions = 0;
        EventHandler textChangedEventHandler;

        private EditTextImpl() {
            super((ComponentLifecycle)EditText.get());
        }

        public String getSimpleName() {
            return "EditText";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            EditTextImpl editTextImpl = (EditTextImpl)other;
            if (this.getId() == editTextImpl.getId()) {
                return true;
            }
            if (this.text != null ? !this.text.equals(editTextImpl.text) : editTextImpl.text != null) {
                return false;
            }
            if (this.hint != null ? !this.hint.equals(editTextImpl.hint) : editTextImpl.hint != null) {
                return false;
            }
            if (this.ellipsize != null ? !this.ellipsize.equals((Object)editTextImpl.ellipsize) : editTextImpl.ellipsize != null) {
                return false;
            }
            if (this.minLines != editTextImpl.minLines) {
                return false;
            }
            if (this.maxLines != editTextImpl.maxLines) {
                return false;
            }
            if (this.maxLength != editTextImpl.maxLength) {
                return false;
            }
            if (Float.compare(this.shadowRadius, editTextImpl.shadowRadius) != 0) {
                return false;
            }
            if (Float.compare(this.shadowDx, editTextImpl.shadowDx) != 0) {
                return false;
            }
            if (Float.compare(this.shadowDy, editTextImpl.shadowDy) != 0) {
                return false;
            }
            if (this.shadowColor != editTextImpl.shadowColor) {
                return false;
            }
            if (this.isSingleLine != editTextImpl.isSingleLine) {
                return false;
            }
            if (this.textColor != editTextImpl.textColor) {
                return false;
            }
            if (this.textColorStateList != null ? !this.textColorStateList.equals(editTextImpl.textColorStateList) : editTextImpl.textColorStateList != null) {
                return false;
            }
            if (this.hintColor != editTextImpl.hintColor) {
                return false;
            }
            if (this.hintColorStateList != null ? !this.hintColorStateList.equals(editTextImpl.hintColorStateList) : editTextImpl.hintColorStateList != null) {
                return false;
            }
            if (this.linkColor != editTextImpl.linkColor) {
                return false;
            }
            if (this.highlightColor != editTextImpl.highlightColor) {
                return false;
            }
            if (this.textSize != editTextImpl.textSize) {
                return false;
            }
            if (Float.compare(this.extraSpacing, editTextImpl.extraSpacing) != 0) {
                return false;
            }
            if (Float.compare(this.spacingMultiplier, editTextImpl.spacingMultiplier) != 0) {
                return false;
            }
            if (this.textStyle != editTextImpl.textStyle) {
                return false;
            }
            if (this.typeface != null ? !this.typeface.equals((Object)editTextImpl.typeface) : editTextImpl.typeface != null) {
                return false;
            }
            if (this.textAlignment != null ? !this.textAlignment.equals((Object)editTextImpl.textAlignment) : editTextImpl.textAlignment != null) {
                return false;
            }
            if (this.gravity != editTextImpl.gravity) {
                return false;
            }
            if (this.editable != editTextImpl.editable) {
                return false;
            }
            if (this.selection != editTextImpl.selection) {
                return false;
            }
            if (this.inputType != editTextImpl.inputType) {
                return false;
            }
            if (this.rawInputType != editTextImpl.rawInputType) {
                return false;
            }
            return this.imeOptions == editTextImpl.imeOptions;
        }
    }
}

