/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.v4.util.Pools;
import com.facebook.litho.Component;
import com.facebook.litho.widget.RenderInfo;

public class ComponentRenderInfo
extends RenderInfo {
    private static final Pools.Pool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);
    private final Component mComponent;

    public static Builder create() {
        Builder builder = (Builder)sBuilderPool.acquire();
        if (builder == null) {
            builder = new Builder();
        }
        return builder;
    }

    private ComponentRenderInfo(Builder builder) {
        super(builder);
        this.mComponent = builder.component;
    }

    public static RenderInfo createEmpty() {
        return new ComponentRenderInfo(new Builder());
    }

    @Override
    public Component getComponent() {
        return this.mComponent;
    }

    @Override
    public boolean rendersComponent() {
        return true;
    }

    @Override
    public String getName() {
        return this.mComponent.getSimpleName();
    }

    public static class Builder
    extends RenderInfo.Builder<Builder> {
        private Component component;

        public Builder component(Component component) {
            this.component = component;
            return this;
        }

        public ComponentRenderInfo build() {
            if (this.component == null) {
                throw new IllegalStateException("Component must be provided.");
            }
            ComponentRenderInfo renderInfo = new ComponentRenderInfo(this);
            this.release();
            return renderInfo;
        }

        @Override
        void release() {
            super.release();
            this.component = null;
            sBuilderPool.release((Object)this);
        }
    }
}

