/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.Resources;
import com.facebook.litho.Column;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.annotations.LayoutSpec;
import com.facebook.litho.annotations.OnCreateLayout;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardClip;
import com.facebook.litho.widget.CardShadow;
import com.facebook.litho.widget.CardShadowDrawable;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;

@LayoutSpec(isPureRender=true)
class CardSpec {
    private static final int DEFAULT_CORNER_RADIUS_DP = 2;
    private static final int DEFAULT_SHADOW_SIZE_DP = 2;
    @PropDefault
    static final int cardBackgroundColor = -1;
    @PropDefault
    static final int clippingColor = -1;
    @PropDefault
    static final int shadowStartColor = 0x37000000;
    @PropDefault
    static final int shadowEndColor = 0x3000000;
    @PropDefault
    static final float cornerRadius = -1.0f;
    @PropDefault
    static final float elevation = -1.0f;

    CardSpec() {
    }

    private static float pixels(Resources resources, int dips) {
        float scale = resources.getDisplayMetrics().density;
        return (float)dips * scale + 0.5f;
    }

    @OnCreateLayout
    static ComponentLayout onCreateLayout(ComponentContext c, @Prop Component<?> content, @Prop(optional=true, resType=ResType.COLOR) int cardBackgroundColor, @Prop(optional=true, resType=ResType.COLOR) int clippingColor, @Prop(optional=true, resType=ResType.COLOR) int shadowStartColor, @Prop(optional=true, resType=ResType.COLOR) int shadowEndColor, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float cornerRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float elevation) {
        Resources resources = c.getResources();
        if (cornerRadius == -1.0f) {
            cornerRadius = CardSpec.pixels(resources, 2);
        }
        if (elevation == -1.0f) {
            elevation = CardSpec.pixels(resources, 2);
        }
        int shadowTop = CardShadowDrawable.getShadowTop(elevation);
        int shadowBottom = CardShadowDrawable.getShadowBottom(elevation);
        int shadowHorizontal = CardShadowDrawable.getShadowHorizontal(elevation);
        return Column.create((ComponentContext)c).child((ComponentLayout.Builder)Column.create((ComponentContext)c).marginPx(YogaEdge.HORIZONTAL, shadowHorizontal).marginPx(YogaEdge.TOP, shadowTop).marginPx(YogaEdge.BOTTOM, shadowBottom).backgroundColor(cardBackgroundColor).child(content).child(CardClip.create(c).clippingColor(clippingColor).cornerRadiusPx(cornerRadius).withLayout().positionType(YogaPositionType.ABSOLUTE).positionPx(YogaEdge.ALL, 0))).child(CardShadow.create(c).shadowStartColor(shadowStartColor).shadowEndColor(shadowEndColor).cornerRadiusPx(cornerRadius).shadowSizePx(elevation).withLayout().positionType(YogaPositionType.ABSOLUTE).positionPx(YogaEdge.ALL, 0)).build();
    }
}

