/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;

class CardShadowDrawable
extends Drawable {
    static final float SHADOW_MULTIPLIER = 1.5f;
    private int mShadowStartColor;
    private int mShadowEndColor;
    private final Paint mEdgeShadowPaint;
    private final Path mCornerShadowTopPath = new Path();
    private final Paint mCornerShadowTopPaint;
    private final Path mCornerShadowBottomPath = new Path();
    private final Paint mCornerShadowBottomPaint;
    private float mCornerRadius;
    private float mShadowSize;
    private float mRawShadowSize;
    private boolean mDirty = true;

    CardShadowDrawable() {
        this.mCornerShadowTopPaint = new Paint(5);
        this.mCornerShadowTopPaint.setStyle(Paint.Style.FILL);
        this.mCornerShadowBottomPaint = new Paint(5);
        this.mCornerShadowBottomPaint.setStyle(Paint.Style.FILL);
        this.mEdgeShadowPaint = new Paint(this.mCornerShadowTopPaint);
        this.mEdgeShadowPaint.setAntiAlias(false);
    }

    public void setAlpha(int alpha) {
        this.mCornerShadowTopPaint.setAlpha(alpha);
        this.mCornerShadowBottomPaint.setAlpha(alpha);
        this.mEdgeShadowPaint.setAlpha(alpha);
    }

    static int getShadowHorizontal(float shadowSize) {
        return (int)Math.ceil(shadowSize);
    }

    static int getShadowTop(float shadowSize) {
        return (int)Math.ceil(shadowSize / 2.0f);
    }

    static int getShadowRight(float shadowSize) {
        return (int)Math.ceil(shadowSize);
    }

    static int getShadowBottom(float shadowSize) {
        return (int)Math.ceil(shadowSize * 1.5f);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mCornerShadowTopPaint.setColorFilter(cf);
        this.mCornerShadowBottomPaint.setColorFilter(cf);
        this.mEdgeShadowPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        if (this.mDirty) {
            this.buildShadow();
            this.mDirty = false;
        }
        Rect bounds = this.getBounds();
        this.drawShadowCorners(canvas, bounds);
        this.drawShadowEdges(canvas, bounds);
    }

    void setShadowStartColor(int shadowStartColor) {
        if (this.mShadowStartColor == shadowStartColor) {
            return;
        }
        this.mShadowStartColor = shadowStartColor;
        this.mDirty = true;
        this.invalidateSelf();
    }

    void setShadowEndColor(int shadowEndColor) {
        if (this.mShadowEndColor == shadowEndColor) {
            return;
        }
        this.mShadowEndColor = shadowEndColor;
        this.mDirty = true;
        this.invalidateSelf();
    }

    void setCornerRadius(float radius) {
        if (this.mCornerRadius == (radius = (float)((int)(radius + 0.5f)))) {
            return;
        }
        this.mCornerRadius = radius;
        this.mDirty = true;
        this.invalidateSelf();
    }

    void setShadowSize(float shadowSize) {
        if (shadowSize < 0.0f) {
            throw new IllegalArgumentException("invalid shadow size");
        }
        if (this.mRawShadowSize == (shadowSize = (float)CardShadowDrawable.toEven(shadowSize))) {
            return;
        }
        this.mRawShadowSize = shadowSize;
        this.mShadowSize = (int)(shadowSize * 1.5f + 0.5f);
        this.mDirty = true;
        this.invalidateSelf();
    }

    private void buildShadow() {
        int shadowHorizontal = CardShadowDrawable.getShadowHorizontal(this.mRawShadowSize);
        int shadowTop = CardShadowDrawable.getShadowTop(this.mRawShadowSize);
        int shadowBottom = CardShadowDrawable.getShadowBottom(this.mRawShadowSize);
        RectF topInnerBounds = new RectF((float)CardShadowDrawable.getShadowHorizontal(this.mRawShadowSize), (float)CardShadowDrawable.getShadowTop(this.mRawShadowSize), (float)CardShadowDrawable.getShadowHorizontal(this.mRawShadowSize) + 2.0f * this.mCornerRadius, (float)CardShadowDrawable.getShadowTop(this.mRawShadowSize) + 2.0f * this.mCornerRadius);
        RectF topOuterBounds = new RectF(0.0f, 0.0f, 2.0f * this.mCornerRadius, 2.0f * this.mCornerRadius);
        this.mCornerShadowTopPath.reset();
        this.mCornerShadowTopPath.setFillType(Path.FillType.EVEN_ODD);
        this.mCornerShadowTopPath.moveTo((float)shadowHorizontal + this.mCornerRadius, (float)shadowTop);
        this.mCornerShadowTopPath.arcTo(topInnerBounds, 270.0f, -90.0f, true);
        this.mCornerShadowTopPath.rLineTo((float)(-shadowHorizontal), 0.0f);
        this.mCornerShadowTopPath.lineTo(0.0f, this.mCornerRadius);
        this.mCornerShadowTopPath.arcTo(topOuterBounds, 180.0f, 90.0f, true);
        this.mCornerShadowTopPath.lineTo((float)shadowHorizontal + this.mCornerRadius, 0.0f);
        this.mCornerShadowTopPath.rLineTo(0.0f, (float)shadowTop);
        this.mCornerShadowTopPath.close();
        this.mCornerShadowTopPaint.setShader((Shader)new RadialGradient((float)shadowHorizontal + this.mCornerRadius, (float)shadowTop + this.mCornerRadius + this.mRawShadowSize / 2.0f, this.mShadowSize, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        RectF bottomInnerBounds = new RectF((float)CardShadowDrawable.getShadowHorizontal(this.mRawShadowSize), (float)CardShadowDrawable.getShadowBottom(this.mRawShadowSize), (float)CardShadowDrawable.getShadowHorizontal(this.mRawShadowSize) + 2.0f * this.mCornerRadius, (float)CardShadowDrawable.getShadowBottom(this.mRawShadowSize) + 2.0f * this.mCornerRadius);
        RectF bottomOuterBounds = new RectF(0.0f, 0.0f, 2.0f * this.mCornerRadius, 2.0f * this.mCornerRadius);
        this.mCornerShadowBottomPath.reset();
        this.mCornerShadowBottomPath.setFillType(Path.FillType.EVEN_ODD);
        this.mCornerShadowBottomPath.moveTo((float)shadowHorizontal + this.mCornerRadius, (float)shadowBottom);
        this.mCornerShadowBottomPath.arcTo(bottomInnerBounds, 270.0f, -90.0f, true);
        this.mCornerShadowBottomPath.rLineTo((float)(-shadowHorizontal), 0.0f);
        this.mCornerShadowBottomPath.lineTo(0.0f, this.mCornerRadius);
        this.mCornerShadowBottomPath.arcTo(bottomOuterBounds, 180.0f, 90.0f, true);
        this.mCornerShadowBottomPath.lineTo((float)shadowHorizontal + this.mCornerRadius, 0.0f);
        this.mCornerShadowBottomPath.rLineTo(0.0f, (float)shadowBottom);
        this.mCornerShadowBottomPath.close();
        this.mCornerShadowBottomPaint.setShader((Shader)new RadialGradient((float)shadowHorizontal + this.mShadowSize / 2.0f, (float)shadowBottom + this.mShadowSize / 2.0f, this.mShadowSize, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        this.mEdgeShadowPaint.setShader((Shader)new LinearGradient(0.0f, this.mCornerRadius + this.mShadowSize, 0.0f, 0.0f, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        this.mEdgeShadowPaint.setAntiAlias(false);
    }

    private void drawShadowCorners(Canvas canvas, Rect bounds) {
        int saved = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.top);
        canvas.drawPath(this.mCornerShadowTopPath, this.mCornerShadowTopPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate((float)bounds.right, (float)bounds.bottom);
        canvas.scale(-1.0f, -1.0f);
        canvas.drawPath(this.mCornerShadowBottomPath, this.mCornerShadowBottomPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.bottom);
        canvas.scale(1.0f, -1.0f);
        canvas.drawPath(this.mCornerShadowBottomPath, this.mCornerShadowBottomPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate((float)bounds.right, (float)bounds.top);
        canvas.scale(-1.0f, 1.0f);
        canvas.drawPath(this.mCornerShadowTopPath, this.mCornerShadowTopPaint);
        canvas.restoreToCount(saved);
    }

    private void drawShadowEdges(Canvas canvas, Rect bounds) {
        int paddingLeft = CardShadowDrawable.getShadowHorizontal(this.mRawShadowSize);
        int paddingTop = CardShadowDrawable.getShadowTop(this.mRawShadowSize);
        int paddingRight = CardShadowDrawable.getShadowRight(this.mRawShadowSize);
        int paddingBottom = CardShadowDrawable.getShadowBottom(this.mRawShadowSize);
        int saved = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.top);
        canvas.drawRect((float)paddingLeft + this.mCornerRadius, 0.0f, (float)bounds.width() - this.mCornerRadius - (float)paddingRight, (float)paddingTop, this.mEdgeShadowPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate((float)bounds.right, (float)bounds.bottom);
        canvas.rotate(180.0f);
        canvas.drawRect((float)paddingRight + this.mCornerRadius, 0.0f, (float)bounds.width() - this.mCornerRadius - (float)paddingLeft, (float)paddingBottom, this.mEdgeShadowPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.bottom);
        canvas.rotate(270.0f);
        canvas.drawRect((float)paddingBottom + this.mCornerRadius, 0.0f, (float)bounds.height() - this.mCornerRadius - (float)paddingTop, (float)paddingLeft, this.mEdgeShadowPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate((float)bounds.right, (float)bounds.top);
        canvas.rotate(90.0f);
        canvas.drawRect((float)paddingTop + this.mCornerRadius, 0.0f, (float)bounds.height() - this.mCornerRadius - (float)paddingBottom, (float)paddingRight, this.mEdgeShadowPaint);
        canvas.restoreToCount(saved);
    }

    private static int toEven(float value) {
        int i = (int)(value + 0.5f);
        if (i % 2 == 1) {
            return i - 1;
        }
        return i;
    }
}

