/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.Px;
import android.support.v4.util.Pools;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardShadowDrawable;
import com.facebook.litho.widget.CardShadowSpec;

final class CardShadow
extends ComponentLifecycle {
    private static CardShadow sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private CardShadow() {
    }

    private static synchronized CardShadow get() {
        if (sInstance == null) {
            sInstance = new CardShadow();
        }
        return sInstance;
    }

    protected Object onCreateMountContent(ComponentContext c) {
        CardShadowDrawable _result = CardShadowSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext context, Object cardShadowDrawable, Component _abstractImpl) {
        CardShadowImpl _impl = (CardShadowImpl)_abstractImpl;
        CardShadowSpec.onMount(context, (CardShadowDrawable)((Object)cardShadowDrawable), _impl.shadowStartColor, _impl.shadowEndColor, _impl.cornerRadius, _impl.shadowSize);
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 15;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return CardShadow.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new CardShadowImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<CardShadow, Builder> {
        CardShadowImpl mCardShadowImpl;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, CardShadowImpl cardShadowImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)cardShadowImpl);
            this.mCardShadowImpl = cardShadowImpl;
            this.mContext = context;
        }

        public Builder shadowStartColor(@ColorInt int shadowStartColor) {
            this.mCardShadowImpl.shadowStartColor = shadowStartColor;
            return this;
        }

        public Builder shadowStartColorRes(@ColorRes int resId) {
            this.mCardShadowImpl.shadowStartColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder shadowStartColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardShadowImpl.shadowStartColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowStartColorAttr(@AttrRes int attrResId) {
            this.mCardShadowImpl.shadowStartColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder shadowEndColor(@ColorInt int shadowEndColor) {
            this.mCardShadowImpl.shadowEndColor = shadowEndColor;
            return this;
        }

        public Builder shadowEndColorRes(@ColorRes int resId) {
            this.mCardShadowImpl.shadowEndColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder shadowEndColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardShadowImpl.shadowEndColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowEndColorAttr(@AttrRes int attrResId) {
            this.mCardShadowImpl.shadowEndColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder cornerRadiusPx(@Px float cornerRadius) {
            this.mCardShadowImpl.cornerRadius = cornerRadius;
            return this;
        }

        public Builder cornerRadiusRes(@DimenRes int resId) {
            this.mCardShadowImpl.cornerRadius = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardShadowImpl.cornerRadius = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCardShadowImpl.cornerRadius = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder cornerRadiusDip(@Dimension(unit=0) float dip) {
            this.mCardShadowImpl.cornerRadius = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowSizePx(@Px float shadowSize) {
            this.mCardShadowImpl.shadowSize = shadowSize;
            return this;
        }

        public Builder shadowSizeRes(@DimenRes int resId) {
            this.mCardShadowImpl.shadowSize = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder shadowSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardShadowImpl.shadowSize = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowSizeAttr(@AttrRes int attrResId) {
            this.mCardShadowImpl.shadowSize = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder shadowSizeDip(@Dimension(unit=0) float dip) {
            this.mCardShadowImpl.shadowSize = this.dipsToPixels(dip);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<CardShadow> build() {
            CardShadowImpl cardShadowImpl = this.mCardShadowImpl;
            this.release();
            return cardShadowImpl;
        }

        protected void release() {
            super.release();
            this.mCardShadowImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class CardShadowImpl
    extends Component<CardShadow>
    implements Cloneable {
        @Prop(resType=ResType.COLOR, optional=true)
        int shadowStartColor;
        @Prop(resType=ResType.COLOR, optional=true)
        int shadowEndColor;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float cornerRadius;
        @Prop(resType=ResType.DIMEN_SIZE, optional=true)
        float shadowSize;

        private CardShadowImpl() {
            super((ComponentLifecycle)CardShadow.get());
        }

        public String getSimpleName() {
            return "CardShadow";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CardShadowImpl cardShadowImpl = (CardShadowImpl)other;
            if (this.getId() == cardShadowImpl.getId()) {
                return true;
            }
            if (this.shadowStartColor != cardShadowImpl.shadowStartColor) {
                return false;
            }
            if (this.shadowEndColor != cardShadowImpl.shadowEndColor) {
                return false;
            }
            if (Float.compare(this.cornerRadius, cardShadowImpl.cornerRadius) != 0) {
                return false;
            }
            return Float.compare(this.shadowSize, cardShadowImpl.shadowSize) == 0;
        }
    }
}

