/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import com.facebook.litho.viewcompat.ViewBinder;
import com.facebook.litho.viewcompat.ViewCreator;
import com.facebook.litho.widget.BaseRenderInfo;

public class ViewRenderInfo
extends BaseRenderInfo {
    private final ViewBinder mViewBinder;
    private final ViewCreator mViewCreator;
    private final boolean mHasCustomViewType;
    private int mViewType;

    public static Builder create() {
        return new Builder();
    }

    private ViewRenderInfo(Builder builder) {
        super(builder);
        this.mViewBinder = builder.viewBinder;
        this.mViewCreator = builder.viewCreator;
        this.mHasCustomViewType = builder.hasCustomViewType;
        if (this.mHasCustomViewType) {
            this.mViewType = builder.viewType;
        }
    }

    @Override
    public boolean rendersView() {
        return true;
    }

    @Override
    public ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    @Override
    public ViewCreator getViewCreator() {
        return this.mViewCreator;
    }

    @Override
    public boolean hasCustomViewType() {
        return this.mHasCustomViewType;
    }

    @Override
    public void setViewType(int viewType) {
        if (this.mHasCustomViewType) {
            throw new UnsupportedOperationException("Cannot override custom view type.");
        }
        this.mViewType = viewType;
    }

    @Override
    public int getViewType() {
        return this.mViewType;
    }

    @Override
    public String getName() {
        return "View (viewType=" + this.mViewType + ")";
    }

    public static class Builder
    extends BaseRenderInfo.Builder<Builder> {
        private ViewBinder viewBinder;
        private ViewCreator viewCreator;
        private boolean hasCustomViewType = false;
        private int viewType = 0;

        public Builder viewCreator(ViewCreator viewCreator) {
            this.viewCreator = viewCreator;
            return this;
        }

        public Builder viewBinder(ViewBinder viewBinder) {
            this.viewBinder = viewBinder;
            return this;
        }

        public Builder customViewType(int viewType) {
            this.hasCustomViewType = true;
            this.viewType = viewType;
            return this;
        }

        public ViewRenderInfo build() {
            if (this.viewCreator == null || this.viewBinder == null) {
                throw new IllegalStateException("Both viewCreator and viewBinder must be provided.");
            }
            return new ViewRenderInfo(this);
        }

        @Override
        public Builder isFullSpan(boolean isFullSpan) {
            throw new UnsupportedOperationException("ViewRenderInfo does not support isFullSpan.");
        }
    }
}

