/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.AttrRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import androidx.core.widget.NestedScrollView;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.Diff;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.LithoScrollView;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.litho.widget.VerticalScrollSpec;
import java.util.BitSet;

public final class VerticalScroll
extends Component {
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=10)
    Component childComponent;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int fadingEdgeLength;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean fillViewport;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean incrementalMountEnabled;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int initialScrollOffsetPixels;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean nestedScrollingEnabled;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    VerticalScrollSpec.OnInterceptTouchListener onInterceptTouchListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    NestedScrollView.OnScrollChangeListener onScrollChangeListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ScrollStateListener scrollStateListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean scrollbarEnabled;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean scrollbarFadingEnabled = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean verticalFadingEdgeEnabled;

    private VerticalScroll() {
        super("VerticalScroll");
    }

    private VerticalScrollStateContainer getStateContainerImpl(ComponentContext c) {
        return (VerticalScrollStateContainer)super.getStateContainer(c);
    }

    protected VerticalScrollStateContainer createStateContainer() {
        return new VerticalScrollStateContainer();
    }

    protected VerticalScrollInterStagePropsContainer createInterStagePropsContainer() {
        return new VerticalScrollInterStagePropsContainer();
    }

    private VerticalScrollInterStagePropsContainer getInterStagePropsContainerImpl(ComponentContext c) {
        return (VerticalScrollInterStagePropsContainer)super.getInterStagePropsContainer(c);
    }

    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        VerticalScroll verticalScrollRef = (VerticalScroll)other;
        if (this.childComponent != null ? !this.childComponent.isEquivalentTo(verticalScrollRef.childComponent) : verticalScrollRef.childComponent != null) {
            return false;
        }
        if (this.fadingEdgeLength != verticalScrollRef.fadingEdgeLength) {
            return false;
        }
        if (this.fillViewport != verticalScrollRef.fillViewport) {
            return false;
        }
        if (this.incrementalMountEnabled != verticalScrollRef.incrementalMountEnabled) {
            return false;
        }
        if (this.initialScrollOffsetPixels != verticalScrollRef.initialScrollOffsetPixels) {
            return false;
        }
        if (this.nestedScrollingEnabled != verticalScrollRef.nestedScrollingEnabled) {
            return false;
        }
        if (this.onInterceptTouchListener != null ? !this.onInterceptTouchListener.equals(verticalScrollRef.onInterceptTouchListener) : verticalScrollRef.onInterceptTouchListener != null) {
            return false;
        }
        if (this.onScrollChangeListener != null ? !this.onScrollChangeListener.equals(verticalScrollRef.onScrollChangeListener) : verticalScrollRef.onScrollChangeListener != null) {
            return false;
        }
        if (this.scrollStateListener != null ? !this.scrollStateListener.equals(verticalScrollRef.scrollStateListener) : verticalScrollRef.scrollStateListener != null) {
            return false;
        }
        if (this.scrollbarEnabled != verticalScrollRef.scrollbarEnabled) {
            return false;
        }
        if (this.scrollbarFadingEnabled != verticalScrollRef.scrollbarFadingEnabled) {
            return false;
        }
        return this.verticalFadingEdgeEnabled == verticalScrollRef.verticalFadingEdgeEnabled;
    }

    protected void copyInterStageImpl(InterStagePropsContainer copyIntoInterStagePropsContainer, InterStagePropsContainer copyFromInterStagePropsContainer) {
        VerticalScrollInterStagePropsContainer copyIntoInterStagePropsContainer_ref = (VerticalScrollInterStagePropsContainer)copyIntoInterStagePropsContainer;
        VerticalScrollInterStagePropsContainer copyFromInterStagePropsContainer_ref = (VerticalScrollInterStagePropsContainer)copyFromInterStagePropsContainer;
        copyIntoInterStagePropsContainer_ref.measuredHeight = copyFromInterStagePropsContainer_ref.measuredHeight;
        copyIntoInterStagePropsContainer_ref.measuredWidth = copyFromInterStagePropsContainer_ref.measuredWidth;
    }

    public VerticalScroll makeShallowCopy() {
        VerticalScroll component = (VerticalScroll)super.makeShallowCopy();
        component.childComponent = component.childComponent != null ? component.childComponent.makeShallowCopy() : null;
        component.setStateContainer(new VerticalScrollStateContainer());
        component.setInterStagePropsContainer(this.createInterStagePropsContainer());
        return component;
    }

    protected void createInitialState(ComponentContext context) {
        StateValue scrollPosition = new StateValue();
        StateValue childComponentTree = new StateValue();
        VerticalScrollSpec.onCreateInitialState(context, (StateValue<VerticalScrollSpec.ScrollPosition>)scrollPosition, (StateValue<ComponentTree>)childComponentTree, this.childComponent, this.initialScrollOffsetPixels, this.incrementalMountEnabled);
        this.getStateContainerImpl((ComponentContext)context).scrollPosition = (VerticalScrollSpec.ScrollPosition)scrollPosition.get();
        this.getStateContainerImpl((ComponentContext)context).childComponentTree = (ComponentTree)childComponentTree.get();
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout2, int widthSpec, int heightSpec, Size size) {
        Output measuredWidthTmp = new Output();
        Output measuredHeightTmp = new Output();
        VerticalScrollSpec.onMeasure(c, layout2, widthSpec, heightSpec, size, this.childComponent, this.fillViewport, this.getStateContainerImpl((ComponentContext)c).childComponentTree, (Output<Integer>)measuredWidthTmp, (Output<Integer>)measuredHeightTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)c).measuredWidth = (Integer)measuredWidthTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)c).measuredHeight = (Integer)measuredHeightTmp.get();
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout2) {
        VerticalScrollSpec.onBoundsDefined(c, layout2, this.childComponent, this.fillViewport, this.getStateContainerImpl((ComponentContext)c).childComponentTree, this.getInterStagePropsContainerImpl((ComponentContext)c).measuredWidth, this.getInterStagePropsContainerImpl((ComponentContext)c).measuredHeight);
    }

    protected Object onCreateMountContent(Context context) {
        LithoScrollView _result = VerticalScrollSpec.onCreateMountContent(context);
        return _result;
    }

    protected void onMount(ComponentContext context, Object lithoScrollView) {
        VerticalScrollSpec.onMount(context, (LithoScrollView)((Object)lithoScrollView), this.scrollbarEnabled, this.scrollbarFadingEnabled, this.nestedScrollingEnabled, this.incrementalMountEnabled, this.verticalFadingEdgeEnabled, this.fadingEdgeLength, this.onScrollChangeListener, this.scrollStateListener, this.onInterceptTouchListener, this.getStateContainerImpl((ComponentContext)context).childComponentTree, this.getStateContainerImpl((ComponentContext)context).scrollPosition);
    }

    protected void onUnmount(ComponentContext context, Object lithoScrollView) {
        VerticalScrollSpec.onUnmount(context, (LithoScrollView)((Object)lithoScrollView));
    }

    protected boolean shouldUpdate(ComponentContext _prevScopedContext, Component _prevAbstractImpl, ComponentContext _nextScopedContext, Component _nextAbstractImpl) {
        VerticalScroll _prevImpl = (VerticalScroll)_prevAbstractImpl;
        VerticalScroll _nextImpl = (VerticalScroll)_nextAbstractImpl;
        Diff childComponent = new Diff((Object)(_prevImpl == null ? null : _prevImpl.childComponent), (Object)(_nextImpl == null ? null : _nextImpl.childComponent));
        Diff scrollbarEnabled = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.scrollbarEnabled)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.scrollbarEnabled));
        Diff scrollbarFadingEnabled = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.scrollbarFadingEnabled)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.scrollbarFadingEnabled));
        Diff fillViewport = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.fillViewport)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.fillViewport));
        Diff nestedScrollingEnabled = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.nestedScrollingEnabled)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.nestedScrollingEnabled));
        Diff incrementalMountEnabled = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.incrementalMountEnabled)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.incrementalMountEnabled));
        boolean _result = VerticalScrollSpec.shouldUpdate((Diff<Component>)childComponent, (Diff<Boolean>)scrollbarEnabled, (Diff<Boolean>)scrollbarFadingEnabled, (Diff<Boolean>)fillViewport, (Diff<Boolean>)nestedScrollingEnabled, (Diff<Boolean>)incrementalMountEnabled);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 3;
    }

    protected boolean canPreallocate() {
        return false;
    }

    public boolean hasChildLithoViews() {
        return true;
    }

    public boolean callsShouldUpdateOnMount() {
        return true;
    }

    public boolean isPureRender() {
        return true;
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(StateContainer _prevStateContainer, StateContainer _nextStateContainer) {
        VerticalScrollStateContainer prevStateContainer = (VerticalScrollStateContainer)_prevStateContainer;
        VerticalScrollStateContainer nextStateContainer = (VerticalScrollStateContainer)_nextStateContainer;
        nextStateContainer.childComponentTree = prevStateContainer.childComponentTree;
        nextStateContainer.scrollPosition = prevStateContainer.scrollPosition;
    }

    public static Builder create(ComponentContext context) {
        return VerticalScroll.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        VerticalScroll instance = new VerticalScroll();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder> {
        VerticalScroll mVerticalScroll;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"childComponent"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, VerticalScroll verticalScrollRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)verticalScrollRef);
            this.mVerticalScroll = verticalScrollRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mVerticalScroll = (VerticalScroll)component;
        }

        @PropSetter(value="childComponent", required=true)
        @RequiredProp(value="childComponent")
        public Builder childComponent(Component childComponent) {
            this.mVerticalScroll.childComponent = childComponent == null ? null : childComponent.makeShallowCopy();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="childComponent", required=true)
        @RequiredProp(value="childComponent")
        public Builder childComponent(Component.Builder<?> childComponentBuilder) {
            this.mVerticalScroll.childComponent = childComponentBuilder == null ? null : childComponentBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthPx(@Px int fadingEdgeLength) {
            this.mVerticalScroll.fadingEdgeLength = fadingEdgeLength;
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthDip(@Dimension(unit=0) float dip) {
            this.mVerticalScroll.fadingEdgeLength = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthRes(@DimenRes int resId) {
            this.mVerticalScroll.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mVerticalScroll.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId) {
            this.mVerticalScroll.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="fillViewport", required=false)
        public Builder fillViewport(boolean fillViewport) {
            this.mVerticalScroll.fillViewport = fillViewport;
            return this;
        }

        @PropSetter(value="incrementalMountEnabled", required=false)
        public Builder incrementalMountEnabled(boolean incrementalMountEnabled) {
            this.mVerticalScroll.incrementalMountEnabled = incrementalMountEnabled;
            return this;
        }

        @PropSetter(value="initialScrollOffsetPixels", required=false)
        public Builder initialScrollOffsetPixels(int initialScrollOffsetPixels) {
            this.mVerticalScroll.initialScrollOffsetPixels = initialScrollOffsetPixels;
            return this;
        }

        @PropSetter(value="nestedScrollingEnabled", required=false)
        public Builder nestedScrollingEnabled(boolean nestedScrollingEnabled) {
            this.mVerticalScroll.nestedScrollingEnabled = nestedScrollingEnabled;
            return this;
        }

        @PropSetter(value="onInterceptTouchListener", required=false)
        public Builder onInterceptTouchListener(@Nullable VerticalScrollSpec.OnInterceptTouchListener onInterceptTouchListener) {
            this.mVerticalScroll.onInterceptTouchListener = onInterceptTouchListener;
            return this;
        }

        @PropSetter(value="onScrollChangeListener", required=false)
        public Builder onScrollChangeListener(@Nullable NestedScrollView.OnScrollChangeListener onScrollChangeListener) {
            this.mVerticalScroll.onScrollChangeListener = onScrollChangeListener;
            return this;
        }

        @PropSetter(value="scrollStateListener", required=false)
        public Builder scrollStateListener(ScrollStateListener scrollStateListener) {
            this.mVerticalScroll.scrollStateListener = scrollStateListener;
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabled(boolean scrollbarEnabled) {
            this.mVerticalScroll.scrollbarEnabled = scrollbarEnabled;
            return this;
        }

        @PropSetter(value="scrollbarFadingEnabled", required=false)
        public Builder scrollbarFadingEnabled(boolean scrollbarFadingEnabled) {
            this.mVerticalScroll.scrollbarFadingEnabled = scrollbarFadingEnabled;
            return this;
        }

        @PropSetter(value="verticalFadingEdgeEnabled", required=false)
        public Builder verticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
            this.mVerticalScroll.verticalFadingEdgeEnabled = verticalFadingEdgeEnabled;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public VerticalScroll build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mVerticalScroll;
        }
    }

    @VisibleForTesting(otherwise=2)
    static class VerticalScrollStateContainer
    extends StateContainer {
        @State
        @Comparable(type=13)
        ComponentTree childComponentTree;
        @State
        @Comparable(type=13)
        VerticalScrollSpec.ScrollPosition scrollPosition;

        VerticalScrollStateContainer() {
        }

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            Object[] params = stateUpdate.params;
            int cfr_ignored_0 = stateUpdate.type;
        }
    }

    static class VerticalScrollInterStagePropsContainer
    implements InterStagePropsContainer {
        Integer measuredHeight;
        Integer measuredWidth;

        VerticalScrollInterStagePropsContainer() {
        }
    }
}

