/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;

class TransparencyEnabledCardClipDrawable
extends Drawable {
    private final RectF mScratchRect = new RectF();
    private final Paint mBackgroundPaint = new Paint(5);
    private float mCornerRadius;

    TransparencyEnabledCardClipDrawable() {
    }

    public void setAlpha(int alpha) {
        this.mBackgroundPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mBackgroundPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mCornerRadius, this.mCornerRadius, this.mBackgroundPaint);
        } else {
            this.mScratchRect.set(bounds);
            canvas.drawRoundRect(this.mScratchRect, this.mCornerRadius, this.mCornerRadius, this.mBackgroundPaint);
        }
    }

    void setBackgroundColor(int backgroundColor) {
        if (this.mBackgroundPaint.getColor() == backgroundColor) {
            return;
        }
        this.mBackgroundPaint.setColor(backgroundColor);
        this.invalidateSelf();
    }

    void setCornerRadius(float radius) {
        if (this.mCornerRadius == (radius = (float)((int)(radius + 0.5f)))) {
            return;
        }
        this.mCornerRadius = radius;
        this.invalidateSelf();
    }
}

