/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Px;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.TransparencyEnabledCardClipDrawable;
import com.facebook.litho.widget.TransparencyEnabledCardClipSpec;

public final class TransparencyEnabledCardClip
extends Component {
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int cardBackgroundColor = -1;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float cornerRadius;

    private TransparencyEnabledCardClip() {
        super("TransparencyEnabledCardClip");
    }

    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        TransparencyEnabledCardClip transparencyEnabledCardClipRef = (TransparencyEnabledCardClip)other;
        if (this.cardBackgroundColor != transparencyEnabledCardClipRef.cardBackgroundColor) {
            return false;
        }
        return Float.compare(this.cornerRadius, transparencyEnabledCardClipRef.cornerRadius) == 0;
    }

    protected Object onCreateMountContent(Context c) {
        TransparencyEnabledCardClipDrawable _result = TransparencyEnabledCardClipSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object cardClipDrawable) {
        TransparencyEnabledCardClipSpec.onMount(c, (TransparencyEnabledCardClipDrawable)((Object)cardClipDrawable), this.cardBackgroundColor, this.cornerRadius);
    }

    protected void onUnmount(ComponentContext c, Object cardClipDrawable) {
        TransparencyEnabledCardClipSpec.onUnmount(c, (TransparencyEnabledCardClipDrawable)((Object)cardClipDrawable));
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 3;
    }

    protected boolean canPreallocate() {
        return false;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return TransparencyEnabledCardClip.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        TransparencyEnabledCardClip instance = new TransparencyEnabledCardClip();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder> {
        TransparencyEnabledCardClip mTransparencyEnabledCardClip;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, TransparencyEnabledCardClip transparencyEnabledCardClipRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)transparencyEnabledCardClipRef);
            this.mTransparencyEnabledCardClip = transparencyEnabledCardClipRef;
            this.mContext = context;
        }

        protected void setComponent(Component component) {
            this.mTransparencyEnabledCardClip = (TransparencyEnabledCardClip)component;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColor(@ColorInt int cardBackgroundColor) {
            this.mTransparencyEnabledCardClip.cardBackgroundColor = cardBackgroundColor;
            return this;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColorRes(@ColorRes int resId) {
            this.mTransparencyEnabledCardClip.cardBackgroundColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTransparencyEnabledCardClip.cardBackgroundColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColorAttr(@AttrRes int attrResId) {
            this.mTransparencyEnabledCardClip.cardBackgroundColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusPx(@Px float cornerRadius) {
            this.mTransparencyEnabledCardClip.cornerRadius = cornerRadius;
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusDip(@Dimension(unit=0) float dip) {
            this.mTransparencyEnabledCardClip.cornerRadius = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusSp(@Dimension(unit=2) float sip) {
            this.mTransparencyEnabledCardClip.cornerRadius = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusRes(@DimenRes int resId) {
            this.mTransparencyEnabledCardClip.cornerRadius = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTransparencyEnabledCardClip.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId) {
            this.mTransparencyEnabledCardClip.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public TransparencyEnabledCardClip build() {
            return this.mTransparencyEnabledCardClip;
        }
    }
}

