/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.Wrapper;
import com.facebook.litho.annotations.CachedValue;
import com.facebook.litho.annotations.LayoutSpec;
import com.facebook.litho.annotations.OnCalculateCachedValue;
import com.facebook.litho.annotations.OnCreateLayout;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;

@LayoutSpec(simpleNameDelegate="content")
class TouchableFeedbackSpec {
    @PropDefault
    static final int color = -1;
    @PropDefault
    static final int highlightColor = -3355444;

    TouchableFeedbackSpec() {
    }

    @OnCreateLayout
    static Component onCreateLayout(ComponentContext c, @Prop Component content, @CachedValue Drawable rippleDrawable) {
        return ((Wrapper.Builder)Wrapper.create((ComponentContext)c).delegate(content).background(rippleDrawable)).build();
    }

    @OnCalculateCachedValue(name="rippleDrawable")
    static Drawable onCalculateCachedValue(ComponentContext c, @Prop(optional=true, resType=ResType.COLOR) int color, @Prop(optional=true, resType=ResType.COLOR) int highlightColor) {
        return TouchableFeedbackSpec.getRippleDrawable(color, highlightColor);
    }

    public static Drawable getRippleDrawable(int normalColor, int pressedColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new RippleDrawable(ColorStateList.valueOf((int)pressedColor), (Drawable)new ColorDrawable(normalColor), TouchableFeedbackSpec.getRippleMask(pressedColor));
        }
        return TouchableFeedbackSpec.getStateListDrawable(normalColor, pressedColor);
    }

    private static Drawable getRippleMask(int color) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RectShape());
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    public static StateListDrawable getStateListDrawable(int normalColor, int pressedColor) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16842908}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16843518}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[0], (Drawable)new ColorDrawable(normalColor));
        return states;
    }
}

