/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.Layout;
import androidx.annotation.VisibleForTesting;
import com.facebook.fbui.textlayoutbuilder.util.LayoutMeasureUtil;
import java.lang.ref.WeakReference;

public class TextureWarmer {
    private static final String TAG = TextureWarmer.class.getName();
    private static final int WARMER_THREAD_PRIORITY = 14;
    private static TextureWarmer sInstance;
    private final WarmerHandler mHandler;

    public static synchronized TextureWarmer getInstance() {
        if (sInstance == null) {
            sInstance = new TextureWarmer();
        }
        return sInstance;
    }

    private TextureWarmer() {
        HandlerThread handlerThread = new HandlerThread(TAG, 14);
        handlerThread.start();
        this.mHandler = new WarmerHandler(handlerThread.getLooper());
    }

    @VisibleForTesting
    Looper getWarmerLooper() {
        return this.mHandler.getLooper();
    }

    public void warmLayout(Layout layout2) {
        this.mHandler.obtainMessage(0, new WeakReference<Layout>(layout2)).sendToTarget();
    }

    public void warmDrawable(WarmDrawable drawable) {
        this.mHandler.obtainMessage(1, new WeakReference<WarmDrawable>(drawable)).sendToTarget();
    }

    private static final class WarmerHandler
    extends Handler {
        public static final int WARM_LAYOUT = 0;
        public static final int WARM_DRAWABLE = 1;
        private final Picture mPicture;

        private WarmerHandler(Looper looper) {
            super(looper);
            Picture picture;
            try {
                picture = new Picture();
            }
            catch (RuntimeException e) {
                picture = null;
            }
            this.mPicture = picture;
        }

        public void handleMessage(Message msg) {
            if (this.mPicture == null) {
                return;
            }
            try {
                switch (msg.what) {
                    case 0: {
                        Layout layout2 = (Layout)((WeakReference)msg.obj).get();
                        if (layout2 == null) break;
                        Canvas canvas = this.mPicture.beginRecording(layout2.getWidth(), LayoutMeasureUtil.getHeight((Layout)layout2));
                        layout2.draw(canvas);
                        this.mPicture.endRecording();
                        break;
                    }
                    case 1: {
                        WarmDrawable warmDrawable = (WarmDrawable)((WeakReference)msg.obj).get();
                        if (warmDrawable == null) break;
                        Canvas canvas = this.mPicture.beginRecording(warmDrawable.width, warmDrawable.height);
                        warmDrawable.drawable.draw(canvas);
                        this.mPicture.endRecording();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class WarmDrawable {
        private final Drawable drawable;
        private final int width;
        private final int height;

        public WarmDrawable(Drawable drawable, int width, int height) {
            this.drawable = drawable;
            this.width = width;
            this.height = height;
        }
    }
}

