/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.annotation.TargetApi;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.LithoView;
import com.facebook.litho.widget.HasStickyHeader;
import com.facebook.litho.widget.SectionsRecyclerView;
import com.facebook.litho.widget.StickyHeaderController;

@TargetApi(value=14)
class StickyHeaderControllerImpl
extends RecyclerView.OnScrollListener
implements StickyHeaderController {
    private static final String FIRST_VISIBLE_STICKY_HEADER_NULL = "StickyHeaderControllerImpl:FirstVisibleStickyHeaderNull";
    static final String RECYCLER_ARGUMENT_NULL = "Cannot initialize with null SectionsRecyclerView.";
    static final String RECYCLER_ALREADY_INITIALIZED = "SectionsRecyclerView has already been initialized but never reset.";
    static final String RECYCLER_NOT_INITIALIZED = "SectionsRecyclerView has not been set yet.";
    static final String LAYOUTMANAGER_NOT_INITIALIZED = "LayoutManager of RecyclerView is not initialized yet.";
    private final HasStickyHeader mHasStickyHeader;
    @Nullable
    private SectionsRecyclerView mSectionsRecyclerView;
    @Nullable
    private RecyclerView.LayoutManager mLayoutManager;
    @Nullable
    private View lastTranslatedView;
    private int previousStickyHeaderPosition = -1;

    StickyHeaderControllerImpl(HasStickyHeader hasStickyHeader) {
        this.mHasStickyHeader = hasStickyHeader;
    }

    @Override
    public void init(SectionsRecyclerView SectionsRecyclerView2) {
        if (SectionsRecyclerView2 == null) {
            throw new RuntimeException(RECYCLER_ARGUMENT_NULL);
        }
        if (this.mSectionsRecyclerView != null) {
            throw new RuntimeException(RECYCLER_ALREADY_INITIALIZED);
        }
        this.mSectionsRecyclerView = SectionsRecyclerView2;
        this.mSectionsRecyclerView.hideStickyHeader();
        this.mLayoutManager = SectionsRecyclerView2.getRecyclerView().getLayoutManager();
        if (this.mLayoutManager == null) {
            throw new RuntimeException(LAYOUTMANAGER_NOT_INITIALIZED);
        }
        this.mSectionsRecyclerView.getRecyclerView().addOnScrollListener((RecyclerView.OnScrollListener)this);
    }

    @Override
    public void reset() {
        if (this.mSectionsRecyclerView == null) {
            throw new IllegalStateException(RECYCLER_NOT_INITIALIZED);
        }
        this.mSectionsRecyclerView.getRecyclerView().removeOnScrollListener((RecyclerView.OnScrollListener)this);
        this.mLayoutManager = null;
        this.mSectionsRecyclerView = null;
    }

    @Override
    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        int firstVisiblePosition = this.mHasStickyHeader.findFirstVisibleItemPosition();
        if (firstVisiblePosition == -1) {
            return;
        }
        int stickyHeaderPosition = this.findStickyHeaderPosition(firstVisiblePosition);
        ComponentTree firstVisibleItemComponentTree = this.mHasStickyHeader.getComponentForStickyHeaderAt(firstVisiblePosition);
        if (this.lastTranslatedView != null && firstVisibleItemComponentTree != null && this.lastTranslatedView != firstVisibleItemComponentTree.getLithoView()) {
            this.lastTranslatedView.setTranslationY(0.0f);
            this.lastTranslatedView = null;
        }
        if (stickyHeaderPosition == -1 || firstVisibleItemComponentTree == null) {
            this.mSectionsRecyclerView.hideStickyHeader();
            this.previousStickyHeaderPosition = -1;
            return;
        }
        if (firstVisiblePosition == stickyHeaderPosition) {
            LithoView firstVisibleView = firstVisibleItemComponentTree.getLithoView();
            if (firstVisibleView == null) {
                ComponentsReporter.emitMessage((ComponentsReporter.LogLevel)ComponentsReporter.LogLevel.ERROR, (String)FIRST_VISIBLE_STICKY_HEADER_NULL, (String)("First visible sticky header item is null, RV.hasPendingAdapterUpdates: " + this.mSectionsRecyclerView.getRecyclerView().hasPendingAdapterUpdates() + ", first visible component: " + firstVisibleItemComponentTree.getSimpleName() + ", hasMounted: " + firstVisibleItemComponentTree.hasMounted() + ", isReleased: " + firstVisibleItemComponentTree.isReleased()));
            } else if (!this.mHasStickyHeader.isValidPosition(stickyHeaderPosition + 1) || !this.mHasStickyHeader.isSticky(stickyHeaderPosition + 1)) {
                firstVisibleView.setTranslationY((float)(-firstVisibleView.getTop()));
            }
            this.lastTranslatedView = firstVisibleView;
            this.mSectionsRecyclerView.hideStickyHeader();
            this.previousStickyHeaderPosition = -1;
        } else {
            if (this.mSectionsRecyclerView.isStickyHeaderHidden() || stickyHeaderPosition != this.previousStickyHeaderPosition) {
                this.initStickyHeader(stickyHeaderPosition);
                this.mSectionsRecyclerView.showStickyHeader();
            }
            int lastVisiblePosition = this.mHasStickyHeader.findLastVisibleItemPosition();
            int translationY = 0;
            for (int i = firstVisiblePosition; i <= lastVisiblePosition; ++i) {
                if (!this.mHasStickyHeader.isSticky(i)) continue;
                View nextStickyHeader = this.mLayoutManager.findViewByPosition(i);
                int offsetBetweenStickyHeaders = nextStickyHeader.getTop() - this.mSectionsRecyclerView.getStickyHeader().getBottom() + this.mSectionsRecyclerView.getPaddingTop();
                translationY = Math.min(offsetBetweenStickyHeaders, 0);
                break;
            }
            this.mSectionsRecyclerView.setStickyHeaderVerticalOffset(translationY);
            this.previousStickyHeaderPosition = stickyHeaderPosition;
        }
    }

    private void initStickyHeader(int stickyHeaderPosition) {
        ComponentTree componentTree = this.mHasStickyHeader.getComponentForStickyHeaderAt(stickyHeaderPosition);
        StickyHeaderControllerImpl.detachLithoViewIfNeeded(componentTree.getLithoView());
        this.mSectionsRecyclerView.setStickyComponent(componentTree);
    }

    private static void detachLithoViewIfNeeded(LithoView view) {
        boolean isAttachedToWindow;
        if (view == null) {
            return;
        }
        boolean bl = isAttachedToWindow = view.getWindowToken() != null;
        if (isAttachedToWindow) {
            view.onStartTemporaryDetach();
        }
    }

    @VisibleForTesting(otherwise=2)
    int findStickyHeaderPosition(int currentFirstVisiblePosition) {
        for (int i = currentFirstVisiblePosition; i >= 0; --i) {
            if (!this.mHasStickyHeader.isSticky(i)) continue;
            return i;
        }
        return -1;
    }
}

