/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;

public class StartSnapHelper
extends SnapHelper {
    private static final int MAX_SCROLL_ON_FLING_DURATION = 100;
    private static final float MILLISECONDS_PER_INCH = 100.0f;
    @Nullable
    private OrientationHelper mVerticalHelper;
    @Nullable
    private OrientationHelper mHorizontalHelper;
    @Nullable
    private RecyclerView.LayoutManager mVerticalHelperLayoutManager;
    @Nullable
    private RecyclerView.LayoutManager mHorizontalHelperLayoutManager;
    @Nullable
    private RecyclerView mRecyclerView;
    private final int mFlingOffset;

    public StartSnapHelper(int flingOffset) {
        this.mFlingOffset = flingOffset;
    }

    @Nullable
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[]{layoutManager.canScrollHorizontally() ? this.distanceToStart(layoutManager, targetView, this.getHorizontalHelper(layoutManager)) : 0, layoutManager.canScrollVertically() ? this.distanceToStart(layoutManager, targetView, this.getVerticalHelper(layoutManager)) : 0};
        return out;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        this.mRecyclerView = recyclerView;
        super.attachToRecyclerView(recyclerView);
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager.canScrollVertically()) {
            return StartSnapHelper.findViewClosestToStart(layoutManager, this.getVerticalHelper(layoutManager));
        }
        if (layoutManager.canScrollHorizontally()) {
            return StartSnapHelper.findViewClosestToStart(layoutManager, this.getHorizontalHelper(layoutManager));
        }
        return null;
    }

    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int velocityX, int velocityY) {
        int targetPos;
        RecyclerView.SmoothScroller.ScrollVectorProvider vectorProvider;
        PointF vectorForEnd;
        int itemCount = layoutManager.getItemCount();
        if (itemCount == 0) {
            return -1;
        }
        boolean isHorizontal = layoutManager.canScrollHorizontally();
        OrientationHelper orientationHelper = isHorizontal ? this.getHorizontalHelper(layoutManager) : this.getVerticalHelper(layoutManager);
        View firstBeforeStartChild = StartSnapHelper.findFirstViewBeforeStart(layoutManager, orientationHelper);
        if (firstBeforeStartChild == null) {
            return -1;
        }
        int firstBeforeStartPosition = layoutManager.getPosition(firstBeforeStartChild);
        if (firstBeforeStartPosition == -1) {
            return -1;
        }
        boolean forwardDirection = isHorizontal ? velocityX > 0 : velocityY > 0;
        boolean reverseLayout = false;
        if (layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider && (vectorForEnd = (vectorProvider = (RecyclerView.SmoothScroller.ScrollVectorProvider)layoutManager).computeScrollVectorForPosition(itemCount - 1)) != null) {
            boolean bl = reverseLayout = vectorForEnd.x < 0.0f || vectorForEnd.y < 0.0f;
        }
        int n = forwardDirection ? (reverseLayout ? firstBeforeStartPosition - this.mFlingOffset : firstBeforeStartPosition + this.mFlingOffset) : (targetPos = firstBeforeStartPosition);
        if (targetPos < 0) {
            targetPos = 0;
        }
        if (targetPos >= itemCount) {
            targetPos = itemCount - 1;
        }
        return targetPos;
    }

    @Nullable
    protected LinearSmoothScroller createSnapScroller(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider)) {
            return null;
        }
        return new LinearSmoothScroller(this.mRecyclerView.getContext()){

            protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
                int[] snapDistances = StartSnapHelper.this.calculateDistanceToFinalSnap(StartSnapHelper.this.mRecyclerView.getLayoutManager(), targetView);
                int dx = snapDistances[0];
                int dy = snapDistances[1];
                int time = this.calculateTimeForDeceleration(Math.max(Math.abs(dx), Math.abs(dy)));
                if (time > 0) {
                    action.update(dx, dy, time, (Interpolator)this.mDecelerateInterpolator);
                }
            }

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                return 100.0f / (float)displayMetrics.densityDpi;
            }

            protected int calculateTimeForScrolling(int dx) {
                return Math.min(100, super.calculateTimeForScrolling(dx));
            }
        };
    }

    private int distanceToStart(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView, OrientationHelper helper) {
        int childStart = helper.getDecoratedStart(targetView);
        int containerStart = helper.getStartAfterPadding();
        return childStart - containerStart;
    }

    @Nullable
    private static View findViewClosestToStart(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        int childCount = layoutManager.getChildCount();
        if (childCount == 0) {
            return null;
        }
        View closestChild = null;
        int start = helper.getStartAfterPadding();
        int absClosest = Integer.MAX_VALUE;
        for (int i = 0; i < childCount; ++i) {
            View child = layoutManager.getChildAt(i);
            int childStart = helper.getDecoratedStart(child);
            int absDistance = Math.abs(childStart - start);
            if (absDistance >= absClosest) continue;
            absClosest = absDistance;
            closestChild = child;
        }
        return closestChild;
    }

    @Nullable
    private static View findFirstViewBeforeStart(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        int childCount = layoutManager.getChildCount();
        if (childCount == 0) {
            return null;
        }
        View closestChild = null;
        int start = helper.getStartAfterPadding();
        int absClosest = Integer.MAX_VALUE;
        for (int i = 0; i < childCount; ++i) {
            View child = layoutManager.getChildAt(i);
            int childStart = helper.getDecoratedStart(child);
            int absDistance = Math.abs(childStart - start);
            if (childStart >= start || absDistance >= absClosest) continue;
            absClosest = absDistance;
            closestChild = child;
        }
        return closestChild;
    }

    @NonNull
    private OrientationHelper getVerticalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null || this.mVerticalHelperLayoutManager != layoutManager) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
            this.mVerticalHelperLayoutManager = layoutManager;
        }
        return this.mVerticalHelper;
    }

    @NonNull
    private OrientationHelper getHorizontalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null || this.mHorizontalHelperLayoutManager != layoutManager) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
            this.mHorizontalHelperLayoutManager = layoutManager;
        }
        return this.mHorizontalHelper;
    }
}

