/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.facebook.litho.LithoView;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.widget.ComponentTreeHolder;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.LayoutInfoUtils;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.litho.widget.RenderInfo;
import com.facebook.litho.widget.StaggeredGridLayoutHelper;
import java.lang.ref.WeakReference;
import java.util.List;

public class StaggeredGridLayoutInfo
implements LayoutInfo {
    public static final String OVERRIDE_SIZE = "OVERRIDE_SIZE";
    private final StaggeredGridLayoutManager mStaggeredGridLayoutManager;

    public StaggeredGridLayoutInfo(int spanCount, int orientation, boolean reverseLayout, int gapStrategy) {
        this(spanCount, orientation, reverseLayout, gapStrategy, false, false);
    }

    public StaggeredGridLayoutInfo(int spanCount, int orientation, boolean reverseLayout, int gapStrategy, boolean eagerlyClearsSpanAssignmentsOnUpdates, boolean invalidatesItemDecorationsOnUpdates) {
        this.mStaggeredGridLayoutManager = new LithoStaggeredGridLayoutManager(spanCount, orientation, eagerlyClearsSpanAssignmentsOnUpdates, invalidatesItemDecorationsOnUpdates);
        this.mStaggeredGridLayoutManager.setReverseLayout(reverseLayout);
        this.mStaggeredGridLayoutManager.setGapStrategy(gapStrategy);
    }

    @Override
    public int getScrollDirection() {
        return this.mStaggeredGridLayoutManager.getOrientation();
    }

    @Override
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mStaggeredGridLayoutManager;
    }

    @Override
    public void setRenderInfoCollection(LayoutInfo.RenderInfoCollection renderInfoCollection) {
    }

    @Override
    public void scrollToPositionWithOffset(int position, int offset) {
        this.mStaggeredGridLayoutManager.scrollToPositionWithOffset(position, offset);
    }

    @Override
    public int approximateRangeSize(int firstMeasuredItemWidth, int firstMeasuredItemHeight, int recyclerMeasuredWidth, int recyclerMeasuredHeight) {
        int spanCount = this.mStaggeredGridLayoutManager.getSpanCount();
        switch (this.mStaggeredGridLayoutManager.getOrientation()) {
            case 0: {
                int colCount = (int)Math.ceil((double)recyclerMeasuredWidth / (double)firstMeasuredItemWidth);
                return colCount * spanCount;
            }
        }
        int rowCount = (int)Math.ceil((double)recyclerMeasuredHeight / (double)firstMeasuredItemHeight);
        return rowCount * spanCount;
    }

    @Override
    public int getChildWidthSpec(int widthSpec, RenderInfo renderInfo) {
        switch (this.mStaggeredGridLayoutManager.getOrientation()) {
            case 0: {
                return SizeSpec.makeSizeSpec((int)0, (int)0);
            }
        }
        Integer overrideWidth = (Integer)renderInfo.getCustomAttribute(OVERRIDE_SIZE);
        if (overrideWidth != null) {
            return SizeSpec.makeSizeSpec((int)overrideWidth, (int)0x40000000);
        }
        int spanCount = this.mStaggeredGridLayoutManager.getSpanCount();
        int spanSize = renderInfo.isFullSpan() ? this.mStaggeredGridLayoutManager.getSpanCount() : 1;
        return SizeSpec.makeSizeSpec((int)(spanSize * (SizeSpec.getSize((int)widthSpec) / spanCount)), (int)0x40000000);
    }

    @Override
    public int getChildHeightSpec(int heightSpec, RenderInfo renderInfo) {
        switch (this.mStaggeredGridLayoutManager.getOrientation()) {
            case 0: {
                Integer overrideHeight = (Integer)renderInfo.getCustomAttribute(OVERRIDE_SIZE);
                if (overrideHeight != null) {
                    return SizeSpec.makeSizeSpec((int)overrideHeight, (int)0x40000000);
                }
                int spanCount = this.mStaggeredGridLayoutManager.getSpanCount();
                int spanSize = renderInfo.isFullSpan() ? this.mStaggeredGridLayoutManager.getSpanCount() : 1;
                return SizeSpec.makeSizeSpec((int)(spanSize * (SizeSpec.getSize((int)heightSpec) / spanCount)), (int)0x40000000);
            }
        }
        return SizeSpec.makeSizeSpec((int)0, (int)0);
    }

    @Override
    public ViewportFiller createViewportFiller(int measuredWidth, int measuredHeight) {
        return new ViewportFiller(measuredWidth, measuredHeight, this.getScrollDirection(), this.mStaggeredGridLayoutManager.getSpanCount());
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return StaggeredGridLayoutHelper.findFirstVisibleItemPosition(this.mStaggeredGridLayoutManager);
    }

    @Override
    public int findLastVisibleItemPosition() {
        return StaggeredGridLayoutHelper.findLastVisibleItemPosition(this.mStaggeredGridLayoutManager);
    }

    @Override
    public int findFirstFullyVisibleItemPosition() {
        return StaggeredGridLayoutHelper.findFirstFullyVisibleItemPosition(this.mStaggeredGridLayoutManager);
    }

    @Override
    public int findLastFullyVisibleItemPosition() {
        return StaggeredGridLayoutHelper.findLastFullyVisibleItemPosition(this.mStaggeredGridLayoutManager);
    }

    @Override
    public int getItemCount() {
        return this.mStaggeredGridLayoutManager.getItemCount();
    }

    @Override
    public int computeWrappedHeight(int maxHeight, List<ComponentTreeHolder> componentTreeHolders) {
        int itemCount = componentTreeHolders.size();
        int spanCount = this.mStaggeredGridLayoutManager.getSpanCount();
        int measuredHeight = 0;
        switch (this.mStaggeredGridLayoutManager.getOrientation()) {
            case 1: {
                for (int i = 0; i < itemCount; i += spanCount) {
                    measuredHeight += LayoutInfoUtils.getMaxHeightInRow(i, i + spanCount, componentTreeHolders);
                    measuredHeight += LayoutInfoUtils.getTopDecorationHeight((RecyclerView.LayoutManager)this.mStaggeredGridLayoutManager, i);
                    if ((measuredHeight += LayoutInfoUtils.getBottomDecorationHeight((RecyclerView.LayoutManager)this.mStaggeredGridLayoutManager, i)) <= maxHeight) continue;
                    measuredHeight = maxHeight;
                    break;
                }
                return measuredHeight;
            }
        }
        throw new IllegalStateException("This method should only be called when orientation is vertical");
    }

    static class ViewportFiller
    implements LayoutInfo.ViewportFiller {
        private final int mWidth;
        private final int mHeight;
        private final int mOrientation;
        private final int mSpanCount;
        private int mIndexOfSpan;
        private int[] mFills;
        private int mMaxFill;

        public ViewportFiller(int width, int height, int orientation, int spanCount) {
            this.mWidth = width;
            this.mHeight = height;
            this.mOrientation = orientation;
            this.mSpanCount = spanCount;
            this.mFills = new int[spanCount];
        }

        @Override
        public boolean wantsMore() {
            int target = this.mOrientation == 1 ? this.mHeight : this.mWidth;
            return this.mMaxFill < target;
        }

        @Override
        public void add(RenderInfo renderInfo, int width, int height) {
            int n = this.mIndexOfSpan;
            this.mFills[n] = this.mFills[n] + (this.mOrientation == 1 ? height : width);
            this.mMaxFill = Math.max(this.mMaxFill, this.mFills[this.mIndexOfSpan]);
            if (++this.mIndexOfSpan == this.mSpanCount) {
                this.mIndexOfSpan = 0;
            }
        }

        @Override
        public int getFill() {
            return this.mMaxFill;
        }
    }

    private static class LithoStaggeredGridLayoutManager
    extends StaggeredGridLayoutManager {
        private boolean mEagerlyClearsSpanAssignmentsOnUpdates;
        private boolean mInvalidatesItemDecorationsOnUpdates;
        private int[] mStaggeredGridResult;
        private WeakReference<RecyclerView> mRecyclerViewToInvalidateItemDecorations = new WeakReference<Object>(null);

        public LithoStaggeredGridLayoutManager(int spanCount, int orientation, boolean eagerlyClearsSpanAssignmentsOnUpdates, boolean invalidatesItemDecorationsOnUpdates) {
            super(spanCount, orientation);
            this.mEagerlyClearsSpanAssignmentsOnUpdates = eagerlyClearsSpanAssignmentsOnUpdates;
            this.mInvalidatesItemDecorationsOnUpdates = invalidatesItemDecorationsOnUpdates;
        }

        public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
            if (lp instanceof RecyclerBinder.RecyclerViewLayoutManagerOverrideParams) {
                return new LayoutParams((RecyclerBinder.RecyclerViewLayoutManagerOverrideParams)lp);
            }
            return super.generateLayoutParams(lp);
        }

        public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
            this.invalidateSpanAssignmentsEagerlyIfNeeded(recyclerView);
            this.prepareToInvalidateItemDecorationsIfNeeded(recyclerView);
            super.onItemsRemoved(recyclerView, positionStart, itemCount);
        }

        public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
            this.invalidateSpanAssignmentsEagerlyIfNeeded(recyclerView);
            this.prepareToInvalidateItemDecorationsIfNeeded(recyclerView);
            super.onItemsAdded(recyclerView, positionStart, itemCount);
        }

        public void onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
            this.invalidateSpanAssignmentsEagerlyIfNeeded(recyclerView);
            this.prepareToInvalidateItemDecorationsIfNeeded(recyclerView);
            super.onItemsMoved(recyclerView, from, to, itemCount);
        }

        public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
            this.invalidateSpanAssignmentsEagerlyIfNeeded(recyclerView);
            this.prepareToInvalidateItemDecorationsIfNeeded(recyclerView);
            super.onItemsUpdated(recyclerView, positionStart, itemCount, payload);
        }

        public void onLayoutCompleted(RecyclerView.State recyclerViewState) {
            super.onLayoutCompleted(recyclerViewState);
            final RecyclerView recyclerViewToInvalidateItemDecorations = (RecyclerView)this.mRecyclerViewToInvalidateItemDecorations.get();
            if (recyclerViewToInvalidateItemDecorations != null) {
                recyclerViewToInvalidateItemDecorations.getHandler().postAtFrontOfQueue(new Runnable(){

                    @Override
                    public void run() {
                        if (recyclerViewToInvalidateItemDecorations.isComputingLayout()) {
                            return;
                        }
                        recyclerViewToInvalidateItemDecorations.invalidateItemDecorations();
                    }
                });
                this.mRecyclerViewToInvalidateItemDecorations.clear();
            }
        }

        private void prepareToInvalidateItemDecorationsIfNeeded(RecyclerView recyclerView) {
            if (this.mInvalidatesItemDecorationsOnUpdates) {
                this.mRecyclerViewToInvalidateItemDecorations = new WeakReference<RecyclerView>(recyclerView);
            }
        }

        private void invalidateSpanAssignmentsEagerlyIfNeeded(RecyclerView recyclerView) {
            if (this.mEagerlyClearsSpanAssignmentsOnUpdates) {
                this.onItemsChanged(recyclerView);
            }
        }

        public int[] findLastCompletelyVisibleItemPositions(@Nullable int[] into) {
            return super.findLastCompletelyVisibleItemPositions(this.getStaggeredGridResult(into));
        }

        public int[] findFirstCompletelyVisibleItemPositions(@Nullable int[] into) {
            return super.findLastCompletelyVisibleItemPositions(this.getStaggeredGridResult(into));
        }

        public int[] findLastVisibleItemPositions(@Nullable int[] into) {
            return super.findLastVisibleItemPositions(this.getStaggeredGridResult(into));
        }

        public int[] findFirstVisibleItemPositions(@Nullable int[] into) {
            return super.findFirstVisibleItemPositions(this.getStaggeredGridResult(into));
        }

        private int[] getStaggeredGridResult(int[] into) {
            if (into == null) {
                if (this.mStaggeredGridResult == null) {
                    this.mStaggeredGridResult = new int[this.getSpanCount()];
                }
                into = this.mStaggeredGridResult;
            }
            return into;
        }

        public static class LayoutParams
        extends StaggeredGridLayoutManager.LayoutParams
        implements LithoView.LayoutManagerOverrideParams {
            private final int mOverrideWidthMeasureSpec;
            private final int mOverrideHeightMeasureSpec;

            public LayoutParams(RecyclerBinder.RecyclerViewLayoutManagerOverrideParams source) {
                super((RecyclerView.LayoutParams)source);
                this.setFullSpan(source.isFullSpan());
                this.mOverrideWidthMeasureSpec = source.getWidthMeasureSpec();
                this.mOverrideHeightMeasureSpec = source.getHeightMeasureSpec();
            }

            public int getWidthMeasureSpec() {
                return this.mOverrideWidthMeasureSpec;
            }

            public int getHeightMeasureSpec() {
                return this.mOverrideHeightMeasureSpec;
            }

            public boolean hasValidAdapterPosition() {
                return false;
            }
        }
    }
}

