/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.core.graphics.ColorUtils;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.annotations.LayoutSpec;
import com.facebook.litho.annotations.OnCreateLayout;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.Image;

@LayoutSpec
class SolidColorSpec {
    @PropDefault
    static final float alpha = -1.0f;

    SolidColorSpec() {
    }

    @OnCreateLayout
    static Component onCreateLayout(ComponentContext c, @Prop(resType=ResType.COLOR) int color, @Prop(optional=true, isCommonProp=true, overrideCommonPropBehavior=true) float alpha) {
        if (alpha >= 0.0f) {
            alpha = Math.min(1.0f, alpha);
            color = ColorUtils.setAlphaComponent((int)color, (int)((int)(alpha * 255.0f)));
        }
        return Image.create(c).scaleType(ImageView.ScaleType.FIT_XY).drawable((Drawable)new ColorDrawable(color)).build();
    }
}

