/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.facebook.litho.widget.CenterSnappingSmoothScroller;
import com.facebook.litho.widget.CustomSpeedLinearSnapHelper;
import com.facebook.litho.widget.EdgeSnappingSmoothScroller;
import com.facebook.litho.widget.SmoothScrollAlignmentType;
import com.facebook.litho.widget.StartSnapHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nullable;

public class SnapUtil {
    public static final int SNAP_NONE = Integer.MIN_VALUE;
    public static final int SNAP_TO_END = 1;
    public static final int SNAP_TO_START = -1;
    public static final int SNAP_TO_CENTER = Integer.MAX_VALUE;
    public static final int SNAP_TO_CENTER_CHILD = 0x7FFFFFFE;
    public static final int SNAP_TO_CENTER_CHILD_WITH_CUSTOM_SPEED = 0x7FFFFFFD;
    public static final int SNAP_TO_START_DEFAULT_FLING_OFFSET = 1;

    @Nullable
    public static SnapHelper getSnapHelper(int snapMode, int deltaJumpThreshold, int startSnapFlingOffset) {
        switch (snapMode) {
            case 0x7FFFFFFF: {
                return new PagerSnapHelper();
            }
            case -1: {
                return new StartSnapHelper(startSnapFlingOffset);
            }
            case 0x7FFFFFFE: {
                return new LinearSnapHelper();
            }
            case 0x7FFFFFFD: {
                return new CustomSpeedLinearSnapHelper(deltaJumpThreshold);
            }
        }
        return null;
    }

    public static RecyclerView.SmoothScroller getSmoothScrollerWithOffset(Context context, int offset, SmoothScrollAlignmentType type) {
        if (type == SmoothScrollAlignmentType.SNAP_TO_ANY || type == SmoothScrollAlignmentType.SNAP_TO_START || type == SmoothScrollAlignmentType.SNAP_TO_END) {
            int snapPreference = type.getValue();
            return new EdgeSnappingSmoothScroller(context, snapPreference, offset);
        }
        if (type == SmoothScrollAlignmentType.SNAP_TO_CENTER) {
            return new CenterSnappingSmoothScroller(context, offset);
        }
        return new LinearSmoothScroller(context);
    }

    public static int getSnapModeFromString(@Nullable String snapString) {
        if (snapString == null) {
            return Integer.MIN_VALUE;
        }
        switch (snapString) {
            case "SNAP_TO_END": {
                return 1;
            }
            case "SNAP_TO_START": {
                return -1;
            }
            case "SNAP_TO_CENTER": {
                return Integer.MAX_VALUE;
            }
            case "SNAP_TO_CENTER_CHILD": {
                return 0x7FFFFFFE;
            }
            case "SNAP_TO_CENTER_CHILD_WITH_CUSTOM_SPEED": {
                return 0x7FFFFFFD;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SnapMode {
    }
}

