/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.util.SparseArray;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.viewcompat.ViewCreator;
import com.facebook.litho.widget.RenderInfo;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RenderInfoViewCreatorController {
    @VisibleForTesting
    final SparseArray<ViewCreator> mViewTypeToViewCreator = new SparseArray();
    @VisibleForTesting
    final Map<ViewCreator, Integer> mViewCreatorToViewType = new HashMap<ViewCreator, Integer>();
    public static final int DEFAULT_COMPONENT_VIEW_TYPE = 0;
    private final boolean mCustomViewTypeEnabled;
    private final int mComponentViewType;
    private int mViewTypeCounter;

    public RenderInfoViewCreatorController(boolean customViewTypeEnabled, int componentViewType) {
        this.mCustomViewTypeEnabled = customViewTypeEnabled;
        this.mComponentViewType = componentViewType;
        this.mViewTypeCounter = componentViewType + 1;
    }

    @UiThread
    public void maybeTrackViewCreator(RenderInfo renderInfo) {
        int viewType;
        if (!renderInfo.rendersView()) {
            return;
        }
        this.ensureCustomViewTypeValidity(renderInfo);
        ViewCreator viewCreator = renderInfo.getViewCreator();
        if (this.mViewCreatorToViewType.containsKey(viewCreator)) {
            viewType = this.mViewCreatorToViewType.get(viewCreator);
        } else {
            int n;
            if (renderInfo.hasCustomViewType()) {
                n = renderInfo.getViewType();
            } else {
                int n2 = this.mViewTypeCounter;
                n = n2;
                this.mViewTypeCounter = n2 + 1;
            }
            viewType = n;
            this.mViewTypeToViewCreator.put(viewType, (Object)viewCreator);
            this.mViewCreatorToViewType.put(viewCreator, viewType);
        }
        if (!renderInfo.hasCustomViewType()) {
            renderInfo.setViewType(viewType);
        }
    }

    private void ensureCustomViewTypeValidity(RenderInfo renderInfo) {
        if (this.mCustomViewTypeEnabled && !renderInfo.hasCustomViewType()) {
            throw new IllegalStateException("If you enable custom viewTypes, you must provide a customViewType in ViewRenderInfo.");
        }
        if (!this.mCustomViewTypeEnabled && renderInfo.hasCustomViewType()) {
            throw new IllegalStateException("You must enable custom viewTypes to provide customViewType in ViewRenderInfo.");
        }
        if (this.mCustomViewTypeEnabled && this.mComponentViewType == renderInfo.getViewType()) {
            throw new IllegalStateException("CustomViewType cannot be the same as ComponentViewType.");
        }
    }

    @Nullable
    public ViewCreator getViewCreator(int viewType) {
        return (ViewCreator)this.mViewTypeToViewCreator.get(viewType);
    }

    int getComponentViewType() {
        return this.mComponentViewType;
    }
}

