/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import com.facebook.litho.ComponentContext;
import com.facebook.litho.widget.ChangeSetCompleteCallback;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.litho.widget.RecyclerBinderUpdateCallback;
import com.facebook.litho.widget.RenderInfo;
import java.util.ArrayList;
import java.util.List;

public class RecyclerBinderOperationExecutor
implements RecyclerBinderUpdateCallback.OperationExecutor {
    private final RecyclerBinder mRecyclerBinder;

    public RecyclerBinderOperationExecutor(RecyclerBinder recyclerBinder) {
        this.mRecyclerBinder = recyclerBinder;
    }

    @Override
    public void executeOperations(ComponentContext c, List<RecyclerBinderUpdateCallback.Operation> operations) {
        int size = operations.size();
        block6: for (int i = 0; i < size; ++i) {
            RecyclerBinderUpdateCallback.Operation operation = operations.get(i);
            List<RecyclerBinderUpdateCallback.ComponentContainer> components = operation.getComponentContainers();
            ArrayList<RenderInfo> renderInfos = null;
            if (components != null && components.size() > 1) {
                renderInfos = new ArrayList<RenderInfo>();
                int componentsSize = components.size();
                for (int j = 0; j < componentsSize; ++j) {
                    renderInfos.add(components.get(j).getRenderInfo());
                }
            }
            switch (operation.getType()) {
                case 0: {
                    if (renderInfos != null) {
                        this.mRecyclerBinder.insertRangeAt(operation.getIndex(), renderInfos);
                        continue block6;
                    }
                    this.mRecyclerBinder.insertItemAt(operation.getIndex(), operation.getComponentContainers().get(0).getRenderInfo());
                    continue block6;
                }
                case 2: {
                    this.mRecyclerBinder.removeRangeAt(operation.getIndex(), operation.getToIndex());
                    continue block6;
                }
                case 3: {
                    this.mRecyclerBinder.moveItem(operation.getIndex(), operation.getToIndex());
                    continue block6;
                }
                case 1: {
                    if (renderInfos != null) {
                        this.mRecyclerBinder.updateRangeAt(operation.getIndex(), renderInfos);
                        continue block6;
                    }
                    this.mRecyclerBinder.updateItemAt(operation.getIndex(), operation.getComponentContainers().get(0).getRenderInfo());
                }
            }
        }
        this.mRecyclerBinder.notifyChangeSetComplete(true, new ChangeSetCompleteCallback(){

            @Override
            public void onDataBound() {
            }

            @Override
            public void onDataRendered(boolean isMounted, long uptimeMillis) {
            }
        });
    }
}

