/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.Diff;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.Size;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.LithoRecylerView;
import com.facebook.litho.widget.PTRRefreshEvent;
import com.facebook.litho.widget.ReMeasureEvent;
import com.facebook.litho.widget.RecyclerEventsController;
import com.facebook.litho.widget.RecyclerSpec;
import com.facebook.litho.widget.SectionsRecyclerView;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public final class Recycler
extends Component {
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=13)
    Binder<RecyclerView> binder;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int bottomPadding = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean clipChildren = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean clipToPadding = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    CharSequence contentDescription;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int fadingEdgeLength;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean hasFixedSize = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean horizontalFadingEdgeEnabled;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    RecyclerView.ItemAnimator itemAnimator = RecyclerSpec.itemAnimator;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    RecyclerView.ItemDecoration itemDecoration;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int leftPadding = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean nestedScrollingEnabled = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    RecyclerView.OnItemTouchListener onItemTouchListener;
    @Prop(resType=ResType.NONE, optional=true, varArg="onScrollListener")
    @Comparable(type=5)
    @Nullable
    List<RecyclerView.OnScrollListener> onScrollListeners = Collections.emptyList();
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int overScrollMode = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean pullToRefresh = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    RecyclerEventsController recyclerEventsController;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    @IdRes
    int recyclerViewId = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=11)
    @Nullable
    EventHandler refreshHandler;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=13)
    @Nullable
    Integer refreshProgressBarBackgroundColor;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int refreshProgressBarColor = -16777216;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int rightPadding = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int scrollBarStyle = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    SnapHelper snapHelper;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int topPadding = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    LithoRecylerView.TouchInterceptor touchInterceptor;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean verticalFadingEdgeEnabled;
    @Nullable
    EventHandler pTRRefreshEventHandler;

    private Recycler() {
        super("Recycler");
    }

    private RecyclerStateContainer getStateContainerImpl(ComponentContext c) {
        return (RecyclerStateContainer)super.getStateContainer(c);
    }

    protected RecyclerStateContainer createStateContainer() {
        return new RecyclerStateContainer();
    }

    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        Recycler recyclerRef = (Recycler)other;
        if (this.binder != null ? !this.binder.equals(recyclerRef.binder) : recyclerRef.binder != null) {
            return false;
        }
        if (this.bottomPadding != recyclerRef.bottomPadding) {
            return false;
        }
        if (this.clipChildren != recyclerRef.clipChildren) {
            return false;
        }
        if (this.clipToPadding != recyclerRef.clipToPadding) {
            return false;
        }
        if (this.contentDescription != null ? !this.contentDescription.equals(recyclerRef.contentDescription) : recyclerRef.contentDescription != null) {
            return false;
        }
        if (this.fadingEdgeLength != recyclerRef.fadingEdgeLength) {
            return false;
        }
        if (this.hasFixedSize != recyclerRef.hasFixedSize) {
            return false;
        }
        if (this.horizontalFadingEdgeEnabled != recyclerRef.horizontalFadingEdgeEnabled) {
            return false;
        }
        if (this.itemAnimator != null ? !this.itemAnimator.equals(recyclerRef.itemAnimator) : recyclerRef.itemAnimator != null) {
            return false;
        }
        if (this.itemDecoration != null ? !this.itemDecoration.equals(recyclerRef.itemDecoration) : recyclerRef.itemDecoration != null) {
            return false;
        }
        if (this.leftPadding != recyclerRef.leftPadding) {
            return false;
        }
        if (this.nestedScrollingEnabled != recyclerRef.nestedScrollingEnabled) {
            return false;
        }
        if (this.onItemTouchListener != null ? !this.onItemTouchListener.equals(recyclerRef.onItemTouchListener) : recyclerRef.onItemTouchListener != null) {
            return false;
        }
        if (this.onScrollListeners != null ? !this.onScrollListeners.equals(recyclerRef.onScrollListeners) : recyclerRef.onScrollListeners != null) {
            return false;
        }
        if (this.overScrollMode != recyclerRef.overScrollMode) {
            return false;
        }
        if (this.pullToRefresh != recyclerRef.pullToRefresh) {
            return false;
        }
        if (this.recyclerEventsController != null ? !this.recyclerEventsController.equals(recyclerRef.recyclerEventsController) : recyclerRef.recyclerEventsController != null) {
            return false;
        }
        if (this.recyclerViewId != recyclerRef.recyclerViewId) {
            return false;
        }
        if (this.refreshHandler != null ? !this.refreshHandler.isEquivalentTo(recyclerRef.refreshHandler) : recyclerRef.refreshHandler != null) {
            return false;
        }
        if (this.refreshProgressBarBackgroundColor != null ? !this.refreshProgressBarBackgroundColor.equals(recyclerRef.refreshProgressBarBackgroundColor) : recyclerRef.refreshProgressBarBackgroundColor != null) {
            return false;
        }
        if (this.refreshProgressBarColor != recyclerRef.refreshProgressBarColor) {
            return false;
        }
        if (this.rightPadding != recyclerRef.rightPadding) {
            return false;
        }
        if (this.scrollBarStyle != recyclerRef.scrollBarStyle) {
            return false;
        }
        if (this.snapHelper != null ? !this.snapHelper.equals(recyclerRef.snapHelper) : recyclerRef.snapHelper != null) {
            return false;
        }
        if (this.topPadding != recyclerRef.topPadding) {
            return false;
        }
        if (this.touchInterceptor != null ? !this.touchInterceptor.equals(recyclerRef.touchInterceptor) : recyclerRef.touchInterceptor != null) {
            return false;
        }
        return this.verticalFadingEdgeEnabled == recyclerRef.verticalFadingEdgeEnabled;
    }

    public Recycler makeShallowCopy() {
        Recycler component = (Recycler)super.makeShallowCopy();
        component.setStateContainer(new RecyclerStateContainer());
        return component;
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size measureOutput) {
        RecyclerSpec.onMeasure(c, layout, widthSpec, heightSpec, measureOutput, this.binder);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext context, ComponentLayout layout) {
        RecyclerSpec.onBoundsDefined(context, layout, this.binder);
    }

    protected Object onCreateMountContent(Context c) {
        SectionsRecyclerView _result = RecyclerSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object sectionsRecycler) {
        RecyclerSpec.onMount(c, (SectionsRecyclerView)((Object)sectionsRecycler), this.binder, this.hasFixedSize, this.clipToPadding, this.leftPadding, this.rightPadding, this.topPadding, this.bottomPadding, this.refreshProgressBarBackgroundColor, this.refreshProgressBarColor, this.clipChildren, this.nestedScrollingEnabled, this.scrollBarStyle, this.itemDecoration, this.horizontalFadingEdgeEnabled, this.verticalFadingEdgeEnabled, this.fadingEdgeLength, this.recyclerViewId, this.overScrollMode, this.contentDescription, this.itemAnimator);
    }

    protected void onBind(ComponentContext context, Object sectionsRecycler) {
        RecyclerSpec.onBind(context, (SectionsRecyclerView)((Object)sectionsRecycler), this.binder, this.recyclerEventsController, this.onScrollListeners, this.snapHelper, this.pullToRefresh, this.touchInterceptor, this.onItemTouchListener, this.refreshHandler);
    }

    protected void onUnbind(ComponentContext context, Object sectionsRecycler) {
        RecyclerSpec.onUnbind(context, (SectionsRecyclerView)((Object)sectionsRecycler), this.binder, this.recyclerEventsController, this.onItemTouchListener, this.onScrollListeners);
    }

    protected void onUnmount(ComponentContext context, Object sectionsRecycler) {
        RecyclerSpec.onUnmount(context, (SectionsRecyclerView)((Object)sectionsRecycler), this.binder, this.itemDecoration, this.refreshProgressBarBackgroundColor, this.snapHelper);
    }

    protected boolean shouldUpdate(ComponentContext _prevScopedContext, Component _prevAbstractImpl, ComponentContext _nextScopedContext, Component _nextAbstractImpl) {
        Recycler _prevImpl = (Recycler)_prevAbstractImpl;
        Recycler _nextImpl = (Recycler)_nextAbstractImpl;
        Diff binder = new Diff(_prevImpl == null ? null : _prevImpl.binder, _nextImpl == null ? null : _nextImpl.binder);
        Diff hasFixedSize = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.hasFixedSize)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.hasFixedSize));
        Diff clipToPadding = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.clipToPadding)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.clipToPadding));
        Diff leftPadding = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.leftPadding)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.leftPadding));
        Diff rightPadding = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.rightPadding)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.rightPadding));
        Diff topPadding = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.topPadding)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.topPadding));
        Diff bottomPadding = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.bottomPadding)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.bottomPadding));
        Diff refreshProgressBarBackgroundColor = new Diff((Object)(_prevImpl == null ? null : _prevImpl.refreshProgressBarBackgroundColor), (Object)(_nextImpl == null ? null : _nextImpl.refreshProgressBarBackgroundColor));
        Diff refreshProgressBarColor = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.refreshProgressBarColor)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.refreshProgressBarColor));
        Diff clipChildren = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.clipChildren)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.clipChildren));
        Diff scrollBarStyle = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.scrollBarStyle)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.scrollBarStyle));
        Diff itemDecoration = new Diff((Object)(_prevImpl == null ? null : _prevImpl.itemDecoration), (Object)(_nextImpl == null ? null : _nextImpl.itemDecoration));
        Diff horizontalFadingEdgeEnabled = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.horizontalFadingEdgeEnabled)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.horizontalFadingEdgeEnabled));
        Diff verticalFadingEdgeEnabled = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.verticalFadingEdgeEnabled)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.verticalFadingEdgeEnabled));
        Diff fadingEdgeLength = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.fadingEdgeLength)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.fadingEdgeLength));
        Diff itemAnimator = new Diff((Object)(_prevImpl == null ? null : _prevImpl.itemAnimator), (Object)(_nextImpl == null ? null : _nextImpl.itemAnimator));
        Diff measureVersion = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.getStateContainerImpl((ComponentContext)_prevScopedContext).measureVersion)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.getStateContainerImpl((ComponentContext)_nextScopedContext).measureVersion));
        boolean _result = RecyclerSpec.shouldUpdate((Diff<Binder<RecyclerView>>)binder, (Diff<Boolean>)hasFixedSize, (Diff<Boolean>)clipToPadding, (Diff<Integer>)leftPadding, (Diff<Integer>)rightPadding, (Diff<Integer>)topPadding, (Diff<Integer>)bottomPadding, (Diff<Integer>)refreshProgressBarBackgroundColor, (Diff<Integer>)refreshProgressBarColor, (Diff<Boolean>)clipChildren, (Diff<Integer>)scrollBarStyle, (Diff<RecyclerView.ItemDecoration>)itemDecoration, (Diff<Boolean>)horizontalFadingEdgeEnabled, (Diff<Boolean>)verticalFadingEdgeEnabled, (Diff<Integer>)fadingEdgeLength, (Diff<RecyclerView.ItemAnimator>)itemAnimator, (Diff<Integer>)measureVersion);
        return _result;
    }

    protected void createInitialState(ComponentContext _0) {
        StateValue measureVersion = new StateValue();
        RecyclerSpec.onCreateInitialState((StateValue<Integer>)measureVersion);
        this.getStateContainerImpl((ComponentContext)_0).measureVersion = (Integer)measureVersion.get();
    }

    protected boolean shouldAlwaysRemeasure() {
        boolean _result = RecyclerSpec.shouldAlwaysRemeasure(this.binder);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 3;
    }

    protected boolean canPreallocate() {
        return false;
    }

    public boolean hasChildLithoViews() {
        return true;
    }

    public boolean callsShouldUpdateOnMount() {
        return true;
    }

    public boolean isPureRender() {
        return true;
    }

    @Nullable
    public static EventHandler getPTRRefreshEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((Recycler)context.getComponentScope()).pTRRefreshEventHandler;
    }

    static Boolean dispatchPTRRefreshEvent(EventHandler _eventHandler) {
        PTRRefreshEvent _eventState = new PTRRefreshEvent();
        EventDispatcher _lifecycle = _eventHandler.mHasEventDispatcher.getEventDispatcher();
        return (Boolean)_lifecycle.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    private void onRemeasure(HasEventDispatcher _abstract, ComponentContext c) {
        Recycler _ref = (Recycler)_abstract;
        RecyclerSpec.onRemeasure(c, _ref.getStateContainerImpl((ComponentContext)c).measureVersion);
    }

    public static EventHandler<ReMeasureEvent> onRemeasure(ComponentContext c) {
        return Recycler.newEventHandler(Recycler.class, (String)"Recycler", (ComponentContext)c, (int)946341036, (Object[])new Object[]{c});
    }

    protected Object dispatchOnEventImpl(EventHandler eventHandler, Object eventState) {
        int id = eventHandler.id;
        switch (id) {
            case 946341036: {
                ReMeasureEvent _event = (ReMeasureEvent)eventState;
                this.onRemeasure(eventHandler.mHasEventDispatcher, (ComponentContext)eventHandler.params[0]);
                return null;
            }
            case -1048037474: {
                Recycler.dispatchErrorEvent((ComponentContext)((ComponentContext)eventHandler.params[0]), (ErrorEvent)((ErrorEvent)eventState));
                return null;
            }
        }
        return null;
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(StateContainer _prevStateContainer, StateContainer _nextStateContainer) {
        RecyclerStateContainer prevStateContainer = (RecyclerStateContainer)_prevStateContainer;
        RecyclerStateContainer nextStateContainer = (RecyclerStateContainer)_nextStateContainer;
        nextStateContainer.measureVersion = prevStateContainer.measureVersion;
    }

    protected static void onUpdateMeasure(ComponentContext c, int measureVer) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{measureVer});
        c.updateStateAsync(_stateUpdate, "updateState:Recycler.onUpdateMeasure");
    }

    protected static void onUpdateMeasureAsync(ComponentContext c, int measureVer) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{measureVer});
        c.updateStateAsync(_stateUpdate, "updateState:Recycler.onUpdateMeasure");
    }

    protected static void onUpdateMeasureSync(ComponentContext c, int measureVer) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{measureVer});
        c.updateStateSync(_stateUpdate, "updateState:Recycler.onUpdateMeasure");
    }

    public static Builder create(ComponentContext context) {
        return Recycler.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        Recycler instance = new Recycler();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder> {
        Recycler mRecycler;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"binder"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, Recycler recyclerRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)recyclerRef);
            this.mRecycler = recyclerRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mRecycler = (Recycler)component;
        }

        @PropSetter(value="binder", required=true)
        @RequiredProp(value="binder")
        public Builder binder(Binder<RecyclerView> binder) {
            this.mRecycler.binder = binder;
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="bottomPadding", required=false)
        public Builder bottomPadding(int bottomPadding) {
            this.mRecycler.bottomPadding = bottomPadding;
            return this;
        }

        @PropSetter(value="clipChildren", required=false)
        public Builder clipChildren(boolean clipChildren) {
            this.mRecycler.clipChildren = clipChildren;
            return this;
        }

        @PropSetter(value="clipToPadding", required=false)
        public Builder clipToPadding(boolean clipToPadding) {
            this.mRecycler.clipToPadding = clipToPadding;
            return this;
        }

        @PropSetter(value="contentDescription", required=false)
        public Builder contentDescription(@Nullable CharSequence contentDescription) {
            super.contentDescription(contentDescription);
            this.mRecycler.contentDescription = contentDescription;
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthPx(@Px int fadingEdgeLength) {
            this.mRecycler.fadingEdgeLength = fadingEdgeLength;
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthDip(@Dimension(unit=0) float dip) {
            this.mRecycler.fadingEdgeLength = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthRes(@DimenRes int resId) {
            this.mRecycler.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mRecycler.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="fadingEdgeLength", required=false)
        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId) {
            this.mRecycler.fadingEdgeLength = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="hasFixedSize", required=false)
        public Builder hasFixedSize(boolean hasFixedSize) {
            this.mRecycler.hasFixedSize = hasFixedSize;
            return this;
        }

        @PropSetter(value="horizontalFadingEdgeEnabled", required=false)
        public Builder horizontalFadingEdgeEnabled(boolean horizontalFadingEdgeEnabled) {
            this.mRecycler.horizontalFadingEdgeEnabled = horizontalFadingEdgeEnabled;
            return this;
        }

        @PropSetter(value="itemAnimator", required=false)
        public Builder itemAnimator(@Nullable RecyclerView.ItemAnimator itemAnimator) {
            this.mRecycler.itemAnimator = itemAnimator;
            return this;
        }

        @PropSetter(value="itemDecoration", required=false)
        public Builder itemDecoration(RecyclerView.ItemDecoration itemDecoration) {
            this.mRecycler.itemDecoration = itemDecoration;
            return this;
        }

        @PropSetter(value="leftPadding", required=false)
        public Builder leftPadding(int leftPadding) {
            this.mRecycler.leftPadding = leftPadding;
            return this;
        }

        @PropSetter(value="nestedScrollingEnabled", required=false)
        public Builder nestedScrollingEnabled(boolean nestedScrollingEnabled) {
            this.mRecycler.nestedScrollingEnabled = nestedScrollingEnabled;
            return this;
        }

        @PropSetter(value="onItemTouchListener", required=false)
        public Builder onItemTouchListener(RecyclerView.OnItemTouchListener onItemTouchListener) {
            this.mRecycler.onItemTouchListener = onItemTouchListener;
            return this;
        }

        @PropSetter(value="onScrollListeners", required=false)
        public Builder onScrollListener(@Nullable RecyclerView.OnScrollListener onScrollListener) {
            if (onScrollListener == null) {
                return this;
            }
            if (this.mRecycler.onScrollListeners == Collections.EMPTY_LIST) {
                this.mRecycler.onScrollListeners = new ArrayList<RecyclerView.OnScrollListener>();
            }
            this.mRecycler.onScrollListeners.add(onScrollListener);
            return this;
        }

        @PropSetter(value="onScrollListeners", required=false)
        public Builder onScrollListeners(@Nullable List<RecyclerView.OnScrollListener> onScrollListeners) {
            if (onScrollListeners == null) {
                return this;
            }
            if (this.mRecycler.onScrollListeners.isEmpty()) {
                this.mRecycler.onScrollListeners = onScrollListeners;
            } else {
                this.mRecycler.onScrollListeners.addAll(onScrollListeners);
            }
            return this;
        }

        @PropSetter(value="overScrollMode", required=false)
        public Builder overScrollMode(int overScrollMode) {
            this.mRecycler.overScrollMode = overScrollMode;
            return this;
        }

        @PropSetter(value="pullToRefresh", required=false)
        public Builder pullToRefresh(boolean pullToRefresh) {
            this.mRecycler.pullToRefresh = pullToRefresh;
            return this;
        }

        @PropSetter(value="recyclerEventsController", required=false)
        public Builder recyclerEventsController(RecyclerEventsController recyclerEventsController) {
            this.mRecycler.recyclerEventsController = recyclerEventsController;
            return this;
        }

        @PropSetter(value="recyclerViewId", required=false)
        public Builder recyclerViewId(@IdRes int recyclerViewId) {
            this.mRecycler.recyclerViewId = recyclerViewId;
            return this;
        }

        @PropSetter(value="refreshHandler", required=false)
        public Builder refreshHandler(@Nullable EventHandler refreshHandler) {
            this.mRecycler.refreshHandler = refreshHandler;
            return this;
        }

        @PropSetter(value="refreshProgressBarBackgroundColor", required=false)
        public Builder refreshProgressBarBackgroundColor(@Nullable @ColorInt Integer refreshProgressBarBackgroundColor) {
            this.mRecycler.refreshProgressBarBackgroundColor = refreshProgressBarBackgroundColor;
            return this;
        }

        @PropSetter(value="refreshProgressBarBackgroundColor", required=false)
        public Builder refreshProgressBarBackgroundColorRes(@ColorRes int resId) {
            this.mRecycler.refreshProgressBarBackgroundColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="refreshProgressBarBackgroundColor", required=false)
        public Builder refreshProgressBarBackgroundColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mRecycler.refreshProgressBarBackgroundColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="refreshProgressBarBackgroundColor", required=false)
        public Builder refreshProgressBarBackgroundColorAttr(@AttrRes int attrResId) {
            this.mRecycler.refreshProgressBarBackgroundColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="refreshProgressBarColor", required=false)
        public Builder refreshProgressBarColor(@ColorInt int refreshProgressBarColor) {
            this.mRecycler.refreshProgressBarColor = refreshProgressBarColor;
            return this;
        }

        @PropSetter(value="refreshProgressBarColor", required=false)
        public Builder refreshProgressBarColorRes(@ColorRes int resId) {
            this.mRecycler.refreshProgressBarColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="refreshProgressBarColor", required=false)
        public Builder refreshProgressBarColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mRecycler.refreshProgressBarColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="refreshProgressBarColor", required=false)
        public Builder refreshProgressBarColorAttr(@AttrRes int attrResId) {
            this.mRecycler.refreshProgressBarColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="rightPadding", required=false)
        public Builder rightPadding(int rightPadding) {
            this.mRecycler.rightPadding = rightPadding;
            return this;
        }

        @PropSetter(value="scrollBarStyle", required=false)
        public Builder scrollBarStyle(int scrollBarStyle) {
            this.mRecycler.scrollBarStyle = scrollBarStyle;
            return this;
        }

        @PropSetter(value="snapHelper", required=false)
        public Builder snapHelper(@Nullable SnapHelper snapHelper) {
            this.mRecycler.snapHelper = snapHelper;
            return this;
        }

        @PropSetter(value="topPadding", required=false)
        public Builder topPadding(int topPadding) {
            this.mRecycler.topPadding = topPadding;
            return this;
        }

        @PropSetter(value="touchInterceptor", required=false)
        public Builder touchInterceptor(@Nullable LithoRecylerView.TouchInterceptor touchInterceptor) {
            this.mRecycler.touchInterceptor = touchInterceptor;
            return this;
        }

        @PropSetter(value="verticalFadingEdgeEnabled", required=false)
        public Builder verticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
            this.mRecycler.verticalFadingEdgeEnabled = verticalFadingEdgeEnabled;
            return this;
        }

        public Builder pTRRefreshEventHandler(@Nullable EventHandler pTRRefreshEventHandler) {
            this.mRecycler.pTRRefreshEventHandler = pTRRefreshEventHandler;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Recycler build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mRecycler;
        }
    }

    @VisibleForTesting(otherwise=2)
    static class RecyclerStateContainer
    extends StateContainer {
        @State
        @Comparable(type=3)
        int measureVersion;

        RecyclerStateContainer() {
        }

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            Object[] params = stateUpdate.params;
            switch (stateUpdate.type) {
                case 0: {
                    StateValue measureVersion = new StateValue();
                    measureVersion.set((Object)this.measureVersion);
                    RecyclerSpec.onUpdateMeasure((Integer)params[0], (StateValue<Integer>)measureVersion);
                    this.measureVersion = (Integer)measureVersion.get();
                }
            }
        }
    }
}

