/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ProgressBar;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.ProgressSpec;

public final class Progress
extends Component {
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int color = 0;
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable indeterminateDrawable;

    private Progress() {
        super("Progress");
    }

    protected ProgressInterStagePropsContainer createInterStagePropsContainer() {
        return new ProgressInterStagePropsContainer();
    }

    private ProgressInterStagePropsContainer getInterStagePropsContainerImpl(ComponentContext c) {
        return (ProgressInterStagePropsContainer)super.getInterStagePropsContainer(c);
    }

    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        Progress progressRef = (Progress)other;
        if (this.color != progressRef.color) {
            return false;
        }
        return !(this.indeterminateDrawable != null ? !this.indeterminateDrawable.equals(progressRef.indeterminateDrawable) : progressRef.indeterminateDrawable != null);
    }

    protected void copyInterStageImpl(InterStagePropsContainer copyIntoInterStagePropsContainer, InterStagePropsContainer copyFromInterStagePropsContainer) {
        ProgressInterStagePropsContainer copyIntoInterStagePropsContainer_ref = (ProgressInterStagePropsContainer)copyIntoInterStagePropsContainer;
        ProgressInterStagePropsContainer copyFromInterStagePropsContainer_ref = (ProgressInterStagePropsContainer)copyFromInterStagePropsContainer;
        copyIntoInterStagePropsContainer_ref.resolvedIndeterminateDrawable = copyFromInterStagePropsContainer_ref.resolvedIndeterminateDrawable;
    }

    public Progress makeShallowCopy() {
        Progress component = (Progress)super.makeShallowCopy();
        component.setInterStagePropsContainer(this.createInterStagePropsContainer());
        return component;
    }

    protected void onLoadStyle(ComponentContext c) {
        Output indeterminateDrawableTmp = new Output();
        ProgressSpec.onLoadStyle(c, (Output<Drawable>)indeterminateDrawableTmp);
        if (indeterminateDrawableTmp.get() != null) {
            this.indeterminateDrawable = (Drawable)indeterminateDrawableTmp.get();
        }
    }

    protected void onPrepare(ComponentContext c) {
        Output resolvedIndeterminateDrawableTmp = new Output();
        ProgressSpec.onPrepare(c, this.indeterminateDrawable, (Output<Drawable>)resolvedIndeterminateDrawableTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)c).resolvedIndeterminateDrawable = (Drawable)resolvedIndeterminateDrawableTmp.get();
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size) {
        ProgressSpec.onMeasure(c, layout, widthSpec, heightSpec, size);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onMount(ComponentContext c, Object progressBar) {
        ProgressSpec.onMount(c, (ProgressBar)progressBar, this.color, this.getInterStagePropsContainerImpl((ComponentContext)c).resolvedIndeterminateDrawable);
    }

    protected void onUnmount(ComponentContext c, Object progressBar) {
        ProgressSpec.onUnmount(c, (ProgressBar)progressBar, this.color, this.getInterStagePropsContainerImpl((ComponentContext)c).resolvedIndeterminateDrawable);
    }

    protected Object onCreateMountContent(Context c) {
        ProgressBar _result = ProgressSpec.onCreateMountContent(c);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 3;
    }

    protected boolean canPreallocate() {
        return false;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Progress.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        Progress instance = new Progress();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder> {
        Progress mProgress;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, Progress progressRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)progressRef);
            this.mProgress = progressRef;
            this.mContext = context;
        }

        protected void setComponent(Component component) {
            this.mProgress = (Progress)component;
        }

        @PropSetter(value="color", required=false)
        public Builder color(@ColorInt int color) {
            this.mProgress.color = color;
            return this;
        }

        @PropSetter(value="color", required=false)
        public Builder colorRes(@ColorRes int resId) {
            this.mProgress.color = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="color", required=false)
        public Builder colorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mProgress.color = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="color", required=false)
        public Builder colorAttr(@AttrRes int attrResId) {
            this.mProgress.color = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="indeterminateDrawable", required=false)
        public Builder indeterminateDrawable(Drawable indeterminateDrawable) {
            this.mProgress.indeterminateDrawable = indeterminateDrawable;
            return this;
        }

        @PropSetter(value="indeterminateDrawable", required=false)
        public Builder indeterminateDrawableRes(@DrawableRes int resId) {
            this.mProgress.indeterminateDrawable = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="indeterminateDrawable", required=false)
        public Builder indeterminateDrawableAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mProgress.indeterminateDrawable = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="indeterminateDrawable", required=false)
        public Builder indeterminateDrawableAttr(@AttrRes int attrResId) {
            this.mProgress.indeterminateDrawable = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Progress build() {
            return this.mProgress;
        }
    }

    static class ProgressInterStagePropsContainer
    implements InterStagePropsContainer {
        Drawable resolvedIndeterminateDrawable;

        ProgressInterStagePropsContainer() {
        }
    }
}

