/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.widget.ComponentTreeHolder;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.LayoutInfoUtils;
import com.facebook.litho.widget.RenderInfo;
import java.util.List;

public class LinearLayoutInfo
implements LayoutInfo {
    private static final int MAX_SANE_RANGE = 10;
    private static final int MIN_SANE_RANGE = 2;
    private final LinearLayoutManager mLinearLayoutManager;

    public LinearLayoutInfo(LinearLayoutManager linearLayoutManager) {
        this.mLinearLayoutManager = linearLayoutManager;
    }

    public LinearLayoutInfo(ComponentContext context, int orientation, boolean reverseLayout) {
        this(context.getAndroidContext(), orientation, reverseLayout);
    }

    public LinearLayoutInfo(Context context, int orientation, boolean reverseLayout) {
        this.mLinearLayoutManager = new InternalLinearLayoutManager(context, orientation, reverseLayout);
        this.mLinearLayoutManager.setMeasurementCacheEnabled(false);
    }

    @Override
    public int getScrollDirection() {
        return this.mLinearLayoutManager.getOrientation();
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return this.mLinearLayoutManager.findFirstVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        return this.mLinearLayoutManager.findLastVisibleItemPosition();
    }

    @Override
    public int findFirstFullyVisibleItemPosition() {
        return this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition();
    }

    @Override
    public int findLastFullyVisibleItemPosition() {
        return this.mLinearLayoutManager.findLastCompletelyVisibleItemPosition();
    }

    @Override
    public int getItemCount() {
        return this.mLinearLayoutManager.getItemCount();
    }

    @Override
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mLinearLayoutManager;
    }

    @Override
    public void setRenderInfoCollection(@Nullable LayoutInfo.RenderInfoCollection renderInfoCollection) {
    }

    @Override
    public void scrollToPositionWithOffset(int position, int offset) {
        this.mLinearLayoutManager.scrollToPositionWithOffset(position, offset);
    }

    @Override
    public int approximateRangeSize(int firstMeasuredItemWidth, int firstMeasuredItemHeight, int recyclerMeasuredWidth, int recyclerMeasuredHeight) {
        int approximateRange;
        switch (this.mLinearLayoutManager.getOrientation()) {
            case 0: {
                approximateRange = (int)Math.ceil((float)recyclerMeasuredWidth / (float)firstMeasuredItemWidth);
                break;
            }
            default: {
                approximateRange = (int)Math.ceil((float)recyclerMeasuredHeight / (float)firstMeasuredItemHeight);
            }
        }
        if (approximateRange < 2) {
            approximateRange = 2;
        } else if (approximateRange > 10) {
            approximateRange = 10;
        }
        return approximateRange;
    }

    @Override
    public int getChildHeightSpec(int heightSpec, RenderInfo renderInfo) {
        switch (this.mLinearLayoutManager.getOrientation()) {
            case 0: {
                return heightSpec;
            }
        }
        return SizeSpec.makeSizeSpec((int)0, (int)0);
    }

    @Override
    public int getChildWidthSpec(int widthSpec, RenderInfo renderInfo) {
        switch (this.mLinearLayoutManager.getOrientation()) {
            case 0: {
                return SizeSpec.makeSizeSpec((int)0, (int)0);
            }
        }
        return widthSpec;
    }

    @Override
    public ViewportFiller createViewportFiller(int measuredWidth, int measuredHeight) {
        return new ViewportFiller(measuredWidth, measuredHeight, this.getScrollDirection());
    }

    @Override
    public int computeWrappedHeight(int maxHeight, List<ComponentTreeHolder> componentTreeHolders) {
        return LayoutInfoUtils.computeLinearLayoutWrappedHeight(this.mLinearLayoutManager, maxHeight, componentTreeHolders);
    }

    public static class ViewportFiller
    implements LayoutInfo.ViewportFiller {
        private final int mWidth;
        private final int mHeight;
        private final int mOrientation;
        private int mFill;

        public ViewportFiller(int width, int height, int orientation) {
            this.mWidth = width;
            this.mHeight = height;
            this.mOrientation = orientation;
        }

        @Override
        public boolean wantsMore() {
            int target = this.mOrientation == 1 ? this.mHeight : this.mWidth;
            return this.mFill < target;
        }

        @Override
        public void add(RenderInfo renderInfo, int width, int height) {
            this.mFill += this.mOrientation == 1 ? height : width;
        }

        @Override
        public int getFill() {
            return this.mFill;
        }
    }

    private static class InternalLinearLayoutManager
    extends LinearLayoutManager {
        InternalLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
            super(context, orientation, reverseLayout);
        }

        public RecyclerView.LayoutParams generateDefaultLayoutParams() {
            return this.getOrientation() == 1 ? new RecyclerView.LayoutParams(-1, -2) : new RecyclerView.LayoutParams(-2, -1);
        }

        public boolean supportsPredictiveItemAnimations() {
            return this.getOrientation() == 0 ? false : super.supportsPredictiveItemAnimations();
        }
    }
}

