/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.widget.ComponentTreeHolder;
import java.util.List;

public class LayoutInfoUtils {
    private LayoutInfoUtils() {
    }

    public static int getTopDecorationHeight(RecyclerView.LayoutManager layoutManager, int position) {
        View itemView = layoutManager.getChildAt(position);
        return itemView != null ? layoutManager.getTopDecorationHeight(itemView) : 0;
    }

    public static int getBottomDecorationHeight(RecyclerView.LayoutManager layoutManager, int position) {
        View itemView = layoutManager.getChildAt(position);
        return itemView != null ? layoutManager.getBottomDecorationHeight(itemView) : 0;
    }

    public static int computeLinearLayoutWrappedHeight(LinearLayoutManager linearLayoutManager, int maxHeight, List<ComponentTreeHolder> componentTreeHolders) {
        int itemCount = componentTreeHolders.size();
        int measuredHeight = 0;
        switch (linearLayoutManager.getOrientation()) {
            case 1: {
                for (int i = 0; i < itemCount; ++i) {
                    ComponentTreeHolder holder = componentTreeHolders.get(i);
                    measuredHeight += holder.getMeasuredHeight();
                    measuredHeight += LayoutInfoUtils.getTopDecorationHeight((RecyclerView.LayoutManager)linearLayoutManager, i);
                    if ((measuredHeight += LayoutInfoUtils.getBottomDecorationHeight((RecyclerView.LayoutManager)linearLayoutManager, i)) <= maxHeight) continue;
                    measuredHeight = maxHeight;
                    break;
                }
                return measuredHeight;
            }
        }
        throw new IllegalStateException("This method should only be called when orientation is vertical");
    }

    public static int getMaxHeightInRow(int start, int end, List<ComponentTreeHolder> componentTreeHolders) {
        int itemCount = componentTreeHolders.size();
        int measuredHeight = 0;
        for (int i = start; i < end && i < itemCount; ++i) {
            ComponentTreeHolder holder = componentTreeHolders.get(i);
            measuredHeight = Math.max(measuredHeight, holder.getMeasuredHeight());
        }
        return measuredHeight;
    }
}

