/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.Diff;
import com.facebook.litho.DrawableMatrix;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBind;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.ShouldUpdate;
import com.facebook.litho.drawable.DrawableUtils;
import com.facebook.litho.utils.MeasureUtils;
import javax.annotation.Nullable;

@MountSpec(isPureRender=true, poolSize=30)
class ImageSpec {
    private static final ImageView.ScaleType[] SCALE_TYPE = ImageView.ScaleType.values();

    ImageSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<Drawable> drawable, Output<ImageView.ScaleType> scaleType) {
        TypedArray a = c.obtainStyledAttributes(R.styleable.Image, 0);
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.Image_android_src) {
                drawable.set((Object)c.getAndroidContext().getResources().getDrawable(a.getResourceId(attr2, 0)));
                continue;
            }
            if (attr2 != R.styleable.Image_android_scaleType) continue;
            scaleType.set((Object)SCALE_TYPE[a.getInteger(attr2, -1)]);
        }
        a.recycle();
    }

    @OnMeasure
    static void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, @Prop(resType=ResType.DRAWABLE) @Nullable Drawable drawable) {
        if (drawable == null || drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            size.width = 0;
            size.height = 0;
            return;
        }
        int intrinsicHeight = drawable.getIntrinsicHeight();
        int intrinsicWidth = drawable.getIntrinsicWidth();
        if (SizeSpec.getMode((int)widthSpec) == 0 && SizeSpec.getMode((int)heightSpec) == 0) {
            size.width = intrinsicWidth;
            size.height = intrinsicHeight;
            return;
        }
        float aspectRatio = (float)intrinsicWidth / (float)intrinsicHeight;
        MeasureUtils.measureWithAspectRatio((int)widthSpec, (int)heightSpec, (int)intrinsicWidth, (int)intrinsicHeight, (float)aspectRatio, (Size)size);
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext c, ComponentLayout layout, @Prop(resType=ResType.DRAWABLE) @Nullable Drawable drawable, @Nullable @Prop(optional=true) ImageView.ScaleType scaleType, Output<DrawableMatrix> drawableMatrix, Output<Integer> drawableWidth, Output<Integer> drawableHeight) {
        int horizontalPadding = layout.getPaddingLeft() + layout.getPaddingRight();
        int verticalPadding = layout.getPaddingTop() + layout.getPaddingBottom();
        if (ImageView.ScaleType.FIT_XY == scaleType || drawable == null || drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            drawableMatrix.set(null);
            drawableWidth.set((Object)(layout.getWidth() - horizontalPadding));
            drawableHeight.set((Object)(layout.getHeight() - verticalPadding));
        } else {
            DrawableMatrix matrix = DrawableMatrix.create((Drawable)drawable, (ImageView.ScaleType)scaleType, (int)(layout.getWidth() - horizontalPadding), (int)(layout.getHeight() - verticalPadding));
            drawableMatrix.set((Object)matrix);
            drawableWidth.set((Object)drawable.getIntrinsicWidth());
            drawableHeight.set((Object)drawable.getIntrinsicHeight());
        }
    }

    @OnCreateMountContent
    static MatrixDrawable onCreateMountContent(Context c) {
        return new MatrixDrawable();
    }

    @OnMount
    static void onMount(ComponentContext c, MatrixDrawable matrixDrawable, @Prop(resType=ResType.DRAWABLE) @Nullable Drawable drawable, @Nullable DrawableMatrix drawableMatrix) {
        matrixDrawable.mount(drawable, drawableMatrix);
    }

    @OnBind
    static void onBind(ComponentContext c, MatrixDrawable mountedDrawable, Integer drawableWidth, Integer drawableHeight) {
        mountedDrawable.bind(drawableWidth.intValue(), drawableHeight.intValue());
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, MatrixDrawable convertDrawable, @Prop(resType=ResType.DRAWABLE) @Nullable Drawable drawable) {
        convertDrawable.unmount();
    }

    @ShouldUpdate(onMount=true)
    static boolean shouldUpdate(@Prop(optional=true) Diff<ImageView.ScaleType> scaleType, @Prop(resType=ResType.DRAWABLE) Diff<Drawable> drawable) {
        return scaleType.getNext() != scaleType.getPrevious() || !DrawableUtils.isEquivalentTo((Drawable)((Drawable)drawable.getNext()), (Drawable)((Drawable)drawable.getPrevious()));
    }
}

