/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.Diff;
import com.facebook.litho.DrawableMatrix;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.ImageSpec;
import java.util.BitSet;
import javax.annotation.Nullable;

public final class Image
extends Component {
    @Nullable
    @Prop(resType=ResType.DRAWABLE, optional=false)
    @Comparable(type=13)
    Drawable drawable;
    @Nullable
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ImageView.ScaleType scaleType;

    private Image() {
        super("Image");
    }

    protected ImageInterStagePropsContainer createInterStagePropsContainer() {
        return new ImageInterStagePropsContainer();
    }

    private ImageInterStagePropsContainer getInterStagePropsContainerImpl(ComponentContext c) {
        return (ImageInterStagePropsContainer)super.getInterStagePropsContainer(c);
    }

    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        Image imageRef = (Image)other;
        if (this.drawable != null ? !this.drawable.equals(imageRef.drawable) : imageRef.drawable != null) {
            return false;
        }
        return !(this.scaleType != null ? !this.scaleType.equals((Object)imageRef.scaleType) : imageRef.scaleType != null);
    }

    protected void copyInterStageImpl(InterStagePropsContainer copyIntoInterStagePropsContainer, InterStagePropsContainer copyFromInterStagePropsContainer) {
        ImageInterStagePropsContainer copyIntoInterStagePropsContainer_ref = (ImageInterStagePropsContainer)copyIntoInterStagePropsContainer;
        ImageInterStagePropsContainer copyFromInterStagePropsContainer_ref = (ImageInterStagePropsContainer)copyFromInterStagePropsContainer;
        copyIntoInterStagePropsContainer_ref.drawableHeight = copyFromInterStagePropsContainer_ref.drawableHeight;
        copyIntoInterStagePropsContainer_ref.drawableMatrix = copyFromInterStagePropsContainer_ref.drawableMatrix;
        copyIntoInterStagePropsContainer_ref.drawableWidth = copyFromInterStagePropsContainer_ref.drawableWidth;
    }

    public Image makeShallowCopy() {
        Image component = (Image)super.makeShallowCopy();
        component.setInterStagePropsContainer(this.createInterStagePropsContainer());
        return component;
    }

    protected void onLoadStyle(ComponentContext c) {
        Output drawableTmp = new Output();
        Output scaleTypeTmp = new Output();
        ImageSpec.onLoadStyle(c, (Output<Drawable>)drawableTmp, (Output<ImageView.ScaleType>)scaleTypeTmp);
        if (drawableTmp.get() != null) {
            this.drawable = (Drawable)drawableTmp.get();
        }
        if (scaleTypeTmp.get() != null) {
            this.scaleType = (ImageView.ScaleType)scaleTypeTmp.get();
        }
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size) {
        ImageSpec.onMeasure(c, layout, widthSpec, heightSpec, size, this.drawable);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout) {
        Output drawableMatrixTmp = new Output();
        Output drawableWidthTmp = new Output();
        Output drawableHeightTmp = new Output();
        ImageSpec.onBoundsDefined(c, layout, this.drawable, this.scaleType, (Output<DrawableMatrix>)drawableMatrixTmp, (Output<Integer>)drawableWidthTmp, (Output<Integer>)drawableHeightTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)c).drawableMatrix = (DrawableMatrix)drawableMatrixTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)c).drawableWidth = (Integer)drawableWidthTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)c).drawableHeight = (Integer)drawableHeightTmp.get();
    }

    protected Object onCreateMountContent(Context c) {
        MatrixDrawable _result = ImageSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object matrixDrawable) {
        ImageSpec.onMount(c, (MatrixDrawable)matrixDrawable, this.drawable, this.getInterStagePropsContainerImpl((ComponentContext)c).drawableMatrix);
    }

    protected void onBind(ComponentContext c, Object mountedDrawable) {
        ImageSpec.onBind(c, (MatrixDrawable)mountedDrawable, this.getInterStagePropsContainerImpl((ComponentContext)c).drawableWidth, this.getInterStagePropsContainerImpl((ComponentContext)c).drawableHeight);
    }

    protected void onUnmount(ComponentContext c, Object convertDrawable) {
        ImageSpec.onUnmount(c, (MatrixDrawable)convertDrawable, this.drawable);
    }

    protected boolean shouldUpdate(ComponentContext _prevScopedContext, Component _prevAbstractImpl, ComponentContext _nextScopedContext, Component _nextAbstractImpl) {
        Image _prevImpl = (Image)_prevAbstractImpl;
        Image _nextImpl = (Image)_nextAbstractImpl;
        Diff scaleType = new Diff((Object)(_prevImpl == null ? null : _prevImpl.scaleType), (Object)(_nextImpl == null ? null : _nextImpl.scaleType));
        Diff drawable = new Diff((Object)(_prevImpl == null ? null : _prevImpl.drawable), (Object)(_nextImpl == null ? null : _nextImpl.drawable));
        boolean _result = ImageSpec.shouldUpdate((Diff<ImageView.ScaleType>)scaleType, (Diff<Drawable>)drawable);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 30;
    }

    protected boolean canPreallocate() {
        return false;
    }

    protected boolean isMountSizeDependent() {
        return true;
    }

    public boolean callsShouldUpdateOnMount() {
        return true;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Image.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        Image instance = new Image();
        builder.init(context, defStyleAttr, defStyleRes, instance);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder> {
        Image mImage;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"drawable"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, Image imageRef) {
            super.init(context, defStyleAttr, defStyleRes, (Component)imageRef);
            this.mImage = imageRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mImage = (Image)component;
        }

        @PropSetter(value="drawable", required=true)
        @RequiredProp(value="drawable")
        public Builder drawable(@Nullable Drawable drawable) {
            this.mImage.drawable = drawable;
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="drawable", required=true)
        @RequiredProp(value="drawable")
        public Builder drawableRes(@DrawableRes int resId) {
            this.mImage.drawable = this.mResourceResolver.resolveDrawableRes(resId);
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="drawable", required=true)
        @RequiredProp(value="drawable")
        public Builder drawableAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mImage.drawable = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="drawable", required=true)
        @RequiredProp(value="drawable")
        public Builder drawableAttr(@AttrRes int attrResId) {
            this.mImage.drawable = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="scaleType", required=false)
        public Builder scaleType(@Nullable ImageView.ScaleType scaleType) {
            this.mImage.scaleType = scaleType;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Image build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mImage;
        }
    }

    static class ImageInterStagePropsContainer
    implements InterStagePropsContainer {
        Integer drawableHeight;
        DrawableMatrix drawableMatrix;
        Integer drawableWidth;

        ImageInterStagePropsContainer() {
        }
    }
}

